/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimePatternConverter {
    private static final String NUMBERS_ONLY_STRING_PATTERN = "^[-]?(\\d)+$";
    private static final String REPLACEMENT_PATTERN = "[our|inute|econd](s)?";
    private static final String HOUR_REGEX_PATTERN = "((\\d)*(\\d))[h|H]";
    private static final String MINUTES_REGEX_PATTERN = "((\\d)*(\\d))[m|M]";
    private static final String SECONDS_REGEX_PATTERN = "((\\d)*(\\d))[s|S]";

    private TimePatternConverter() {
    }

    public static long toMilliSeconds(String source) throws IllegalArgumentException {
        long milliseconds = 0L;
        boolean foundFlag = false;
        Matcher matcher = TimePatternConverter.createMatcher(NUMBERS_ONLY_STRING_PATTERN, source);
        if (matcher.find()) {
            milliseconds = Long.valueOf(source);
        } else {
            matcher = TimePatternConverter.createMatcher(REPLACEMENT_PATTERN, source);
            String replacedSource = matcher.replaceAll("");
            if ((matcher = TimePatternConverter.createMatcher(HOUR_REGEX_PATTERN, replacedSource)).find()) {
                milliseconds += 3600000L * Long.valueOf(matcher.group(1));
                foundFlag = true;
            }
            if ((matcher = TimePatternConverter.createMatcher(MINUTES_REGEX_PATTERN, replacedSource)).find()) {
                long minutes = Long.valueOf(matcher.group(1));
                if (minutes > 59L && foundFlag) {
                    throw new IllegalArgumentException("Minutes should contain a valid value between 0 and 59: " + source);
                }
                foundFlag = true;
                milliseconds += 60000L * minutes;
            }
            if ((matcher = TimePatternConverter.createMatcher(SECONDS_REGEX_PATTERN, replacedSource)).find()) {
                long seconds = Long.valueOf(matcher.group(1));
                if (seconds > 59L && foundFlag) {
                    throw new IllegalArgumentException("Seconds should contain a valid value between 0 and 59: " + source);
                }
                foundFlag = true;
                milliseconds += 1000L * seconds;
            }
            if (!foundFlag) {
                milliseconds = Long.valueOf(source);
            }
        }
        return milliseconds;
    }

    private static Matcher createMatcher(String regexPattern, String source) {
        Pattern pattern = Pattern.compile(regexPattern, 2);
        return pattern.matcher(source);
    }
}

