/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import java.io.IOException;

abstract class LineBuffer {
    private StringBuilder line = new StringBuilder();
    private boolean sawReturn;

    LineBuffer() {
    }

    protected void add(char[] cbuf, int off, int len) throws IOException {
        int pos = off;
        if (this.sawReturn && len > 0 && this.finishLine(cbuf[pos] == '\n')) {
            ++pos;
        }
        int start2 = pos;
        int end = off + len;
        while (pos < end) {
            switch (cbuf[pos]) {
                case '\r': {
                    this.line.append(cbuf, start2, pos - start2);
                    this.sawReturn = true;
                    if (pos + 1 < end && this.finishLine(cbuf[pos + 1] == '\n')) {
                        ++pos;
                    }
                    start2 = pos + 1;
                    break;
                }
                case '\n': {
                    this.line.append(cbuf, start2, pos - start2);
                    this.finishLine(true);
                    start2 = pos + 1;
                }
            }
            ++pos;
        }
        this.line.append(cbuf, start2, off + len - start2);
    }

    private boolean finishLine(boolean sawNewline) throws IOException {
        this.handleLine(this.line.toString(), this.sawReturn ? (sawNewline ? "\r\n" : "\r") : (sawNewline ? "\n" : ""));
        this.line = new StringBuilder();
        this.sawReturn = false;
        return sawNewline;
    }

    protected void finish() throws IOException {
        if (this.sawReturn || this.line.length() > 0) {
            this.finishLine(false);
        }
    }

    protected abstract void handleLine(String var1, String var2) throws IOException;
}

