/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class BinaryElement
extends AtomicElement<Binary> {
    private final Binary _value;

    BinaryElement(Element parent, Element prev, Binary b) {
        super(parent, prev);
        byte[] data = new byte[b.getLength()];
        System.arraycopy(b.getArray(), b.getArrayOffset(), data, 0, b.getLength());
        this._value = new Binary(data);
    }

    @Override
    public int size() {
        int length = this._value.getLength();
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (length > 255) {
                    parent.setConstructorType(ArrayElement.LARGE);
                    return 4 + length;
                }
                return 1 + length;
            }
            return 4 + length;
        }
        if (length > 255) {
            return 5 + length;
        }
        return 2 + length;
    }

    @Override
    public Binary getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.BINARY;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (b.remaining() < size2) {
            return 0;
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                b.put((byte)this._value.getLength());
            } else {
                b.putInt(this._value.getLength());
            }
        } else if (this._value.getLength() <= 255) {
            b.put((byte)-96);
            b.put((byte)this._value.getLength());
        } else {
            b.put((byte)-80);
            b.put((byte)this._value.getLength());
        }
        b.put(this._value.getArray(), this._value.getArrayOffset(), this._value.getLength());
        return size2;
    }
}

