/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support.internal.support;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.osgi.service.util.internal.aop.ProxyUtils;
import org.springframework.osgi.service.util.internal.aop.ServiceTCCLInterceptor;
import org.springframework.osgi.util.DebugUtils;

public class PublishingServiceFactory
implements ServiceFactory {
    private static final Log log = LogFactory.getLog((Class)PublishingServiceFactory.class);
    private final Object monitor = new Object();
    private final Map proxyCache;
    private final Class[] classes;
    private final Object target;
    private final BeanFactory beanFactory;
    private final String targetBeanName;
    private final boolean createTCCLProxy;
    private final ClassLoader classLoader;
    private final ClassLoader aopClassLoader;
    private final BundleContext bundleContext;

    public PublishingServiceFactory(Class[] classes, Object target, BeanFactory beanFactory, String targetBeanName, boolean createTCCLProxy, ClassLoader classLoader, ClassLoader aopClassLoader, BundleContext bundleContext) {
        this.classes = classes;
        this.target = target;
        this.beanFactory = beanFactory;
        this.targetBeanName = targetBeanName;
        this.createTCCLProxy = createTCCLProxy;
        this.classLoader = classLoader;
        this.aopClassLoader = aopClassLoader;
        this.bundleContext = bundleContext;
        this.proxyCache = createTCCLProxy ? new WeakHashMap(4) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBean() {
        Object object = this.monitor;
        synchronized (object) {
            return this.target == null ? this.beanFactory.getBean(this.targetBeanName) : this.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        Object bn = this.getBean();
        if (bn instanceof ServiceFactory) {
            bn = ((ServiceFactory)bn).getService(bundle, serviceRegistration);
        }
        if (this.createTCCLProxy) {
            Map map2 = this.proxyCache;
            synchronized (map2) {
                WeakReference value = (WeakReference)this.proxyCache.get(bn);
                Object proxy = null;
                if (value != null) {
                    proxy = value.get();
                }
                if (proxy == null) {
                    proxy = this.createCLLProxy(bn);
                    this.proxyCache.put(bn, new WeakReference<Object>(proxy));
                }
                bn = proxy;
            }
        }
        return bn;
    }

    private Object createCLLProxy(Object target) {
        try {
            return ProxyUtils.createProxy(this.classes, target, this.aopClassLoader, this.bundleContext, new Advice[]{new ServiceTCCLInterceptor(this.classLoader)});
        }
        catch (Throwable th) {
            log.error((Object)"Cannot create TCCL managed proxy; falling back to the naked object", th);
            if (th instanceof NoClassDefFoundError) {
                NoClassDefFoundError ncdfe = (NoClassDefFoundError)th;
                if (log.isWarnEnabled()) {
                    DebugUtils.debugClassLoadingThrowable(ncdfe, this.bundleContext.getBundle(), this.classes);
                }
                throw ncdfe;
            }
            return target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object service) {
        Object bn = this.getBean();
        if (bn instanceof ServiceFactory) {
            ((ServiceFactory)bn).ungetService(bundle, serviceRegistration, service);
        }
        if (this.createTCCLProxy) {
            Map map2 = this.proxyCache;
            synchronized (map2) {
                this.proxyCache.values().remove(new WeakReference<Object>(service));
            }
        }
    }
}

