/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

public final class PropertiesUtil {
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties");
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Properties props;

    public PropertiesUtil(Properties props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PropertiesUtil(String propertiesFileName) {
        Properties properties = new Properties();
        for (URL url : LoaderUtil.findResources(propertiesFileName)) {
            InputStream in = null;
            in = url.openStream();
            properties.load(in);
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to close {}", url.toString(), ioe);
            }
            continue;
            catch (IOException ioe) {
                try {
                    LOGGER.error("Unable to read {}", url.toString(), ioe);
                    if (in == null) continue;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe2) {
                            LOGGER.error("Unable to close {}", url.toString(), ioe2);
                        }
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException ioe3) {
                    LOGGER.error("Unable to close {}", url.toString(), ioe3);
                }
            }
        }
        this.props = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Properties loadClose(InputStream in, Object source) {
        Properties props;
        block11: {
            props = new Properties();
            if (null != in) {
                props.load(in);
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close {}", source, e);
                }
                break block11;
                catch (IOException e) {
                    try {
                        LOGGER.error("Unable to read {}", source, e);
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error("Unable to close {}", source, e2);
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        LOGGER.error("Unable to close {}", source, e3);
                    }
                }
            }
        }
        return props;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? this.props.getProperty(name) : prop;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.props.getProperty(name);
        }
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.props.getProperty(name);
        }
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception ignored) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            LOGGER.error("Unable to access system properties.", (Throwable)ex);
            return new Properties();
        }
    }

    public static Properties extractSubset(Properties properties, String prefix) {
        Properties subset = new Properties();
        if (prefix == null || prefix.length() == 0) {
            return subset;
        }
        String prefixToMatch = prefix.charAt(prefix.length() - 1) != '.' ? prefix + '.' : prefix;
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefixToMatch)) continue;
            subset.setProperty(key.substring(prefixToMatch.length()), properties.getProperty(key));
            keys.add(key);
        }
        for (String key : keys) {
            properties.remove(key);
        }
        return subset;
    }
}

