/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="feature", name="requirement-remove", description="Remove provisioning requirements.")
@Service
public class RequirementRemove
extends FeaturesCommandSupport {
    @Argument(required=true, multiValued=true)
    List<String> requirements;
    @Option(name="-r", aliases={"--no-auto-refresh"}, description="Do not automatically refresh bundles", required=false, multiValued=false)
    boolean noRefresh;
    @Option(name="-s", aliases={"--no-auto-start"}, description="Do not start the bundles", required=false, multiValued=false)
    boolean noStart;
    @Option(name="-m", aliases={"--no-auto-manage"}, description="Do not automatically manage bundles", required=false, multiValued=false)
    boolean noManage;
    @Option(name="-v", aliases={"--verbose"}, description="Explain what is being done")
    boolean verbose;
    @Option(name="-t", aliases={"--simulate"}, description="Perform a simulation only")
    boolean simulate;
    @Option(name="-g", aliases={"--region"}, description="Region to apply to")
    String region = "root";

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        this.addOption(FeaturesService.Option.Simulate, this.simulate);
        this.addOption(FeaturesService.Option.NoAutoStartBundles, this.noStart);
        this.addOption(FeaturesService.Option.NoAutoRefreshBundles, this.noRefresh);
        this.addOption(FeaturesService.Option.NoAutoManageBundles, this.noManage);
        this.addOption(FeaturesService.Option.Verbose, this.verbose);
        HashMap<String, HashSet<String>> reqs = new HashMap<String, HashSet<String>>();
        reqs.put(this.region, new HashSet<String>(this.requirements));
        featuresService.removeRequirements(reqs, this.options);
    }
}

