/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.style.Style;
import org.apache.sis.style.se1.Description;
import org.apache.sis.style.se1.FeatureTypeStyle;
import org.apache.sis.style.se1.Symbolizer;

public class Symbology
implements Style,
Cloneable {
    private String name;
    private Description<?> description;
    private boolean isDefault;
    private List<FeatureTypeStyle> fts;
    private Symbolizer<?> defaultSpecification;

    public Symbology() {
        this.fts = new ArrayList<FeatureTypeStyle>();
    }

    public Symbology(Symbology source) {
        this.name = source.name;
        this.description = source.description;
        this.isDefault = source.isDefault;
        this.defaultSpecification = source.defaultSpecification;
        this.fts = new ArrayList<FeatureTypeStyle>(source.fts);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String value) {
        this.name = value;
    }

    public Optional<Description<?>> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(Description<?> value) {
        this.description = value;
    }

    public List<FeatureTypeStyle> featureTypeStyles() {
        return this.fts;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean value) {
        this.isDefault = value;
    }

    public Optional<Symbolizer<?>> getDefaultSpecification() {
        return Optional.ofNullable(this.defaultSpecification);
    }

    public void setDefaultSpecification(Symbolizer<?> value) {
        this.defaultSpecification = value;
    }

    private Object[] properties() {
        return new Object[]{this.name, this.description, this.isDefault, this.fts, this.defaultSpecification};
    }

    public int hashCode() {
        return this.getClass().hashCode() + Arrays.hashCode(this.properties());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass() && Arrays.equals(this.properties(), ((Symbology)obj).properties());
    }

    public Symbology clone() {
        try {
            Symbology clone = (Symbology)super.clone();
            clone.selfClone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void selfClone() {
        if (this.description != null) {
            this.description = this.description.clone();
        }
        if (this.defaultSpecification != null) {
            this.defaultSpecification = this.defaultSpecification.clone();
        }
        this.fts = new ArrayList<FeatureTypeStyle>(this.fts);
        this.fts.replaceAll(FeatureTypeStyle::clone);
    }
}

