/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.apache.sis.util.internal.shared.SetOfUnknownSize;

public abstract class ListOfUnknownSize<E>
extends AbstractSequentialList<E> {
    protected ListOfUnknownSize() {
    }

    protected int sizeIfKnown() {
        return -1;
    }

    @Override
    public int size() {
        int size;
        block1: {
            size = this.sizeIfKnown();
            if (size >= 0) break block1;
            size = 0;
            while (this.exists(size) && ++size != Integer.MAX_VALUE) {
            }
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        int size = this.sizeIfKnown();
        return size == 0 || size < 0 && !this.exists(0);
    }

    protected abstract boolean exists(int var1);

    @Override
    public abstract E get(int var1);

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        java.util.Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            modified |= this.remove(it.next());
        }
        return modified;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new Iterator(index);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.sizeIfKnown() >= 0 ? super.spliterator() : Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    @Override
    public Object[] toArray() {
        return this.sizeIfKnown() >= 0 ? super.toArray() : SetOfUnknownSize.toArray(this.iterator(), new Object[32], true);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.sizeIfKnown() >= 0 ? super.toArray(array) : SetOfUnknownSize.toArray(this.iterator(), array, false);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        java.util.Iterator it = this.iterator();
        java.util.Iterator ot = ((List)object).iterator();
        while (it.hasNext()) {
            if (ot.hasNext() && Objects.equals(it.next(), ot.next())) continue;
            return false;
        }
        return !ot.hasNext();
    }

    private final class Iterator
    implements ListIterator<E> {
        private int cursor;

        Iterator(int index) {
            this.cursor = index;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public boolean hasNext() {
            int size = ListOfUnknownSize.this.sizeIfKnown();
            return size >= 0 ? this.cursor < size : ListOfUnknownSize.this.exists(this.cursor);
        }

        @Override
        public E next() {
            Object element;
            try {
                element = ListOfUnknownSize.this.get(this.cursor);
            }
            catch (IndexOutOfBoundsException e) {
                throw (NoSuchElementException)new NoSuchElementException().initCause(e);
            }
            ++this.cursor;
            return element;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (this.cursor != 0) {
                return ListOfUnknownSize.this.get(--this.cursor);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

