/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.lang.reflect.Array;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.internal.shared.Formulas;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;

public final class WKTUtilities {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.io.wkt");

    private WKTUtilities() {
    }

    public static String toType(Class<?> base, Class<?> type) {
        int end;
        StringBuilder name;
        if (type != base && (name = ReferencingUtilities.toPropertyName(base, type)) != null && CharSequences.regionMatches((CharSequence)name, (int)(end = name.length() - 2), (CharSequence)"CS")) {
            name.setLength(end);
            if ("time".contentEquals(name)) {
                return "temporal";
            }
            if (CharSequences.regionMatches((CharSequence)name, (int)0, (CharSequence)"cartesian")) {
                name.setCharAt(0, 'C');
            }
            return name.toString();
        }
        return null;
    }

    public static FormattableObject toFormattable(CoordinateReferenceSystem object) {
        if (object instanceof FormattableObject) {
            return (FormattableObject)object;
        }
        return AbstractCRS.castOrCopy(object);
    }

    public static FormattableObject toFormattable(MathTransform object, boolean internal) {
        ParameterValueGroup parameters;
        Matrix matrix;
        if (internal && (matrix = MathTransforms.getMatrix(object)) != null) {
            parameters = Affine.parameters(matrix);
        } else if (object instanceof Parameterized) {
            parameters = ((Parameterized)object).getParameterValues();
        } else {
            matrix = MathTransforms.getMatrix(object);
            if (matrix == null) {
                return null;
            }
            parameters = Affine.parameters(matrix);
        }
        return new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                WKTUtilities.appendParamMT(parameters, formatter);
                return "Param_MT";
            }
        };
    }

    public static <Q extends Quantity<Q>> Unit<Q> toFormattable(Unit<Q> unit) {
        if (Units.isAngular(unit) && !unit.getConverterTo(Units.RADIAN).isLinear()) {
            unit = Units.DEGREE;
        }
        return unit;
    }

    public static void appendName(IdentifiedObject object, Formatter formatter, ElementKind type) {
        String name = IdentifiedObjects.getName(object, formatter.getNameAuthority());
        if (name == null && (name = IdentifiedObjects.getName(object, null)) == null) {
            name = Vocabulary.forLocale((Locale)formatter.getLocale()).getString((short)208);
        }
        formatter.append(name, type != null ? type : ElementKind.NAME);
    }

    public static void appendElementIfPositive(final String name, final double value, Formatter formatter) {
        if (value > 0.0) {
            formatter.append(new FormattableObject(){

                @Override
                protected String formatTo(Formatter formatter) {
                    formatter.append(value);
                    return name;
                }
            });
        }
    }

    public static void appendParamMT(ParameterValueGroup parameters, Formatter formatter) {
        if (parameters != null) {
            WKTUtilities.appendName((IdentifiedObject)parameters.getDescriptor(), formatter, ElementKind.PARAMETER);
            WKTUtilities.append((GeneralParameterValue)parameters, formatter);
        }
    }

    public static void append(GeneralParameterValue parameter, Formatter formatter) {
        if (parameter instanceof ParameterValueGroup) {
            boolean first = true;
            for (GeneralParameterValue param : ((ParameterValueGroup)parameter).values()) {
                if (first) {
                    formatter.newLine();
                    first = false;
                }
                WKTUtilities.append(param, formatter);
            }
        }
        if (parameter instanceof ParameterValue) {
            if (!(parameter instanceof FormattableObject)) {
                parameter = new DefaultParameterValue((ParameterValue)parameter);
            }
            formatter.append((FormattableObject)parameter);
            formatter.newLine();
        }
    }

    public static boolean isEPSG(GeneralParameterDescriptor descriptor, boolean ifUndefined) {
        String cs;
        ReferenceIdentifier id;
        if (descriptor != null && (id = descriptor.getName()) != null && (cs = id.getCodeSpace()) != null) {
            return "EPSG".equalsIgnoreCase(cs);
        }
        return ifUndefined;
    }

    public static int[] suggestFractionDigits(Vector[] rows) {
        int length = 0;
        int n = rows.length - 1;
        for (int j = 0; j <= n; ++j) {
            int rl = rows[j].size();
            if (rl <= length) continue;
            length = rl;
        }
        int[] fractionDigits = new int[length];
        Statistics stats = new Statistics(null);
        for (int i = 0; i < length; ++i) {
            boolean isInteger = true;
            for (Vector row : rows) {
                if (row.size() <= i) continue;
                double value = row.doubleValue(i);
                stats.accept(value);
                if (!isInteger || Math.floor(value) == value || Double.isNaN(value)) continue;
                isInteger = false;
            }
            if (!isInteger) {
                fractionDigits[i] = Numerics.suggestFractionDigits((Statistics)stats);
            }
            stats.reset();
        }
        return fractionDigits;
    }

    public static int[] suggestFractionDigits(CoordinateReferenceSystem crs, Vector[] points) {
        int[] fractionDigits = WKTUtilities.suggestFractionDigits(points);
        DatumOrEnsemble.getEllipsoid(crs).ifPresent(ellipsoid -> {
            CoordinateSystem cs = crs.getCoordinateSystem();
            int dimension = Math.min(cs.getDimension(), fractionDigits.length);
            double scale = Formulas.scaleComparedToEarth(ellipsoid);
            for (int i = 0; i < dimension; ++i) {
                double precision;
                Unit unit = cs.getAxis(i).getUnit();
                if (Units.isLinear((Unit)unit)) {
                    precision = 0.01 * scale;
                } else if (Units.isAngular((Unit)unit)) {
                    precision = 1.5706706731410455E-9 * scale;
                } else {
                    if (!Units.isTemporal((Unit)unit)) continue;
                    precision = 60.0;
                }
                int f = DecimalFunctions.fractionDigitsForDelta((double)(precision /= Units.toStandardUnit((Unit)unit)), (boolean)false);
                if (f <= fractionDigits[i]) continue;
                fractionDigits[i] = f;
            }
        });
        return fractionDigits;
    }

    public static Object[] cornersAndCenter(Function<int[], Number> tensor, int[] size, int cornerSize) {
        int sizeLimit = cornerSize * 2 + 1;
        int[] shown = (int[])size.clone();
        int[] empty = (int[])size.clone();
        for (int d = 0; d < shown.length; ++d) {
            if (shown[d] <= sizeLimit) continue;
            shown[d] = sizeLimit;
            empty[d] = cornerSize;
        }
        int[] source = new int[shown.length];
        int[] target = new int[shown.length];
        int[] reversed = new int[shown.length];
        int i = 0;
        while (i < reversed.length) {
            reversed[i++] = shown[shown.length - i];
        }
        Object[] numbers = (Object[])Array.newInstance(Number.class, reversed);
        Number[] row = null;
        block6: while (true) {
            if (row == null) {
                Object[] walk = numbers;
                int d = shown.length;
                while (--d >= 1) {
                    walk = (Object[])walk[target[d]];
                }
                row = (Number[])walk;
            }
            row[target[0]] = tensor.apply(source);
            int d = 0;
            block8: while (true) {
                int n = d;
                source[n] = source[n] + 1;
                int n2 = d;
                target[n2] = target[n2] + 1;
                int p = target[n2];
                if (p == shown[d]) {
                    row = null;
                    source[d] = 0;
                    target[d] = 0;
                    if (++d < shown.length) continue;
                    break block6;
                }
                switch (p - empty[d]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        source[d] = size[d] - cornerSize;
                    }
                }
                break;
            }
        }
        Object walk = numbers;
        Object[] previous = null;
        int d = size.length;
        while (--d >= 0) {
            int p = empty[d];
            previous = walk;
            if (p >= previous.length) {
                return numbers;
            }
            walk = previous[p];
            source[d] = size[d] / 2;
        }
        assert (walk == previous[empty[0]]);
        if (walk == null) {
            previous[empty[0]] = tensor.apply(source);
        }
        return numbers;
    }

    public static InternationalString descriptionOfMediumLength(Extent extent) {
        InternationalString description = extent.getDescription();
        if (description != null && description.length() > 255) {
            if (Extents.isWorld((Extent)extent)) {
                description = Extents.WORLD.getDescription();
            } else {
                for (GeographicExtent element : extent.getGeographicElements()) {
                    String name;
                    Identifier id;
                    if (!(element instanceof GeographicDescription) || !((id = ((GeographicDescription)element).getGeographicIdentifier()) instanceof ReferenceIdentifier) || !"EPSG".equalsIgnoreCase(((ReferenceIdentifier)id).getCodeSpace()) || (name = id.getCode()) == null || name.isEmpty() || !Character.isLetter(name.codePointAt(0))) continue;
                    description = new SimpleInternationalString(name);
                    break;
                }
            }
        }
        return description;
    }
}

