/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Arrays;
import java.util.List;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import org.apache.sis.gui.coverage.GridControls;
import org.apache.sis.gui.coverage.GridError;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.internal.MouseDrags;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.util.internal.shared.Numerics;

final class GridViewSkin
extends SkinBase<GridView>
implements EventHandler<MouseEvent> {
    private static final int HEADER_MARGIN = 9;
    private static final int MIN_CELL_SIZE = 4;
    private static final int MIN_ERROR_BOX_SIZE = 140;
    private Text[] headerRow = new Text[0];
    private Text[] headerColumn = this.headerRow;
    private Text[] valueCells = this.headerRow;
    private final Rectangle topBackground;
    private final Rectangle leftBackground;
    private double cellWidth;
    private double cellHeight;
    private final Rectangle selection;
    private final Rectangle selectedRow;
    private final Rectangle selectedColumn;
    private boolean isDragging;
    private double xPanPrevious;
    private double yPanPrevious;
    private final ScrollBar xScrollBar;
    private final ScrollBar yScrollBar;
    private int indexOfFirstError;
    private int indexAfterLastError;
    private final Rectangle clip;
    private static final int WIDTH_PROPERTY = 0;
    private static final int HEIGHT_PROPERTY = 1;
    private static final int HEADER_PROPERTY = 2;

    GridViewSkin(GridView view) {
        super((Control)view);
        this.cellWidth = GridViewSkin.toValidCellSize(view.cellWidth.get());
        this.cellHeight = GridViewSkin.toValidCellSize(view.cellHeight.get());
        double valuesRegionX = GridViewSkin.toValidCellSize(view.headerWidth.get());
        double valuesRegionY = this.cellHeight + 9.0;
        this.leftBackground = new Rectangle(valuesRegionX, 0.0);
        this.topBackground = new Rectangle(0.0, valuesRegionY);
        this.selection = new Rectangle(valuesRegionX, valuesRegionY, this.cellWidth, this.cellHeight);
        this.selectedRow = new Rectangle(0.0, valuesRegionY, valuesRegionX, this.cellHeight);
        this.selectedColumn = new Rectangle(valuesRegionX, 0.0, this.cellWidth, valuesRegionY);
        this.selection.setFill((Paint)Styles.SELECTION_BACKGROUND);
        this.selectedRow.setFill((Paint)Color.SILVER);
        this.selectedColumn.setFill((Paint)Color.SILVER);
        this.selection.setVisible(false);
        this.selectedRow.setVisible(false);
        this.selectedColumn.setVisible(false);
        this.xScrollBar = new ScrollBar();
        this.yScrollBar = new ScrollBar();
        this.yScrollBar.setOrientation(Orientation.VERTICAL);
        this.clip = new Rectangle();
        view.setClip((Node)this.clip);
    }

    public void install() {
        super.install();
        this.xScrollBar.valueProperty().addListener((p, o, n) -> this.positionChanged((Number)o, (Number)n, false));
        this.yScrollBar.valueProperty().addListener((p, o, n) -> this.positionChanged((Number)o, (Number)n, true));
        GridView view = (GridView)this.getSkinnable();
        this.topBackground.fillProperty().bind(view.headerBackground);
        this.leftBackground.fillProperty().bind(view.headerBackground);
        view.headerWidth.addListener((p, o, n) -> this.cellSizeChanged((Number)o, (Number)n, 2));
        view.cellWidth.addListener((p, o, n) -> this.cellSizeChanged((Number)o, (Number)n, 0));
        view.cellHeight.addListener((p, o, n) -> this.cellSizeChanged((Number)o, (Number)n, 1));
        view.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyTyped);
        view.setOnMouseExited(e -> this.hideSelection());
        view.setOnMouseMoved(this);
        MouseDrags.setHandlers((Region)view, (EventHandler<? super MouseEvent>)((EventHandler)this::onDrag));
    }

    public void dispose() {
        GridView view = (GridView)this.getSkinnable();
        this.topBackground.fillProperty().unbind();
        this.leftBackground.fillProperty().unbind();
        view.setOnMouseExited(null);
        view.setOnMouseMoved(null);
        MouseDrags.setHandlers((Region)view, null);
        super.dispose();
    }

    public final void handle(MouseEvent event) {
        boolean visible;
        double valuesRegionX = this.valuesRegionX();
        double x = (event.getX() - valuesRegionX) / this.cellWidth;
        boolean bl = visible = x >= 0.0 && x < (double)this.headerRow.length;
        if (visible) {
            double valuesRegionY = this.valuesRegionY();
            double y = (event.getY() - valuesRegionY) / this.cellHeight;
            boolean bl2 = visible = y >= 0.0 && y < (double)this.headerColumn.length;
            if (visible) {
                double xminOfValues = this.xScrollBar.getValue();
                double yminOfValues = this.yScrollBar.getValue();
                x = Math.floor(x + xminOfValues);
                y = Math.floor(y + yminOfValues);
                double xpos = valuesRegionX + (x - xminOfValues) * this.cellWidth;
                double ypos = valuesRegionY + (y - yminOfValues) * this.cellHeight;
                this.selection.setX(xpos);
                this.selection.setY(ypos);
                this.selectedRow.setY(ypos);
                this.selectedColumn.setX(xpos);
                GridControls controls = ((GridView)this.getSkinnable()).controls;
                if (controls != null) {
                    controls.status.setLocalCoordinates(x, y);
                }
            }
        }
        this.selection.setVisible(visible);
        this.selectedRow.setVisible(visible);
        this.selectedColumn.setVisible(visible);
        if (!visible) {
            ((GridView)this.getSkinnable()).hideCoordinates();
        }
    }

    private void onDrag(MouseEvent event) {
        double y;
        double x;
        if (event.getButton() == MouseButton.PRIMARY && (x = (event.getX() - this.valuesRegionX()) / this.cellWidth) >= 0.0 && x < (double)this.headerRow.length && (y = (event.getY() - this.valuesRegionY()) / this.cellHeight) >= 0.0 && y < (double)this.headerColumn.length) {
            GridView view = (GridView)this.getSkinnable();
            EventType type = event.getEventType();
            if (type == MouseEvent.MOUSE_PRESSED) {
                view.setCursor(Cursor.CLOSED_HAND);
                view.requestFocus();
                this.isDragging = true;
            } else if (this.isDragging) {
                if (type == MouseEvent.MOUSE_RELEASED) {
                    view.setCursor(Cursor.DEFAULT);
                    this.isDragging = false;
                }
                GridViewSkin.shift(this.xScrollBar, this.xPanPrevious - x, false);
                GridViewSkin.shift(this.yScrollBar, this.yPanPrevious - y, false);
            } else {
                return;
            }
            this.xPanPrevious = x;
            this.yPanPrevious = y;
            event.consume();
        }
    }

    private void onKeyTyped(KeyEvent event) {
        int tx = 0;
        int ty = 0;
        switch (event.getCode()) {
            case RIGHT: 
            case KP_RIGHT: {
                tx = 1;
                break;
            }
            case LEFT: 
            case KP_LEFT: {
                tx = -1;
                break;
            }
            case DOWN: 
            case KP_DOWN: {
                ty = 1;
                break;
            }
            case UP: 
            case KP_UP: {
                ty = -1;
                break;
            }
            case PAGE_DOWN: {
                ty = Math.max(this.headerColumn.length - 3, 1);
                break;
            }
            case PAGE_UP: {
                ty = Math.min(3 - this.headerColumn.length, -1);
                break;
            }
            default: {
                return;
            }
        }
        if (tx != 0) {
            GridViewSkin.shift(this.xScrollBar, tx, true);
        }
        if (ty != 0) {
            GridViewSkin.shift(this.yScrollBar, ty, true);
        }
        event.consume();
    }

    private static void shift(ScrollBar bar, double shift, boolean snap) {
        double value = bar.getValue() + shift;
        if (snap) {
            value = Math.rint(value);
        }
        bar.setValue(Math.max(bar.getMin(), Math.min(bar.getMax(), value)));
    }

    private void positionChanged(Number oldValue, Number newValue, boolean vertical) {
        double shift = newValue.doubleValue() - oldValue.doubleValue();
        if (vertical) {
            double ypos = this.selection.getY() - shift * this.cellHeight;
            this.selection.setY(ypos);
            this.selectedRow.setY(ypos);
        } else {
            double xpos = this.selection.getX() - shift * this.cellWidth;
            this.selection.setX(xpos);
            this.selectedColumn.setX(xpos);
        }
        this.updateCellValues();
    }

    private static double toValidCellSize(double value) {
        return value >= 4.0 ? value : 4.0;
    }

    private void cellSizeChanged(Number oldValue, Number newValue, int property) {
        double value = GridViewSkin.toValidCellSize(newValue.doubleValue());
        switch (property) {
            case 2: {
                this.leftBackground.setWidth(value);
                this.selectedRow.setWidth(value);
                this.selectedColumn.setX(value);
                break;
            }
            case 0: {
                this.cellWidth = value;
                this.selection.setWidth(value);
                this.selectedColumn.setWidth(value);
                if (!(value > oldValue.doubleValue())) break;
                ((GridView)this.getSkinnable()).cellFormat.restorePattern();
                break;
            }
            case 1: {
                this.cellHeight = value;
                this.selection.setHeight(value);
                this.selectedRow.setHeight(value);
                this.selectedColumn.setHeight(value += 9.0);
                this.topBackground.setWidth(value);
            }
        }
        this.hideSelection();
        ((GridView)this.getSkinnable()).requestLayout();
    }

    private void hideSelection() {
        this.selection.setVisible(false);
        this.selectedRow.setVisible(false);
        this.selectedColumn.setVisible(false);
        ((GridView)this.getSkinnable()).hideCoordinates();
    }

    final void errorOccurred(GridError error) {
        this.getChildren().add(this.indexAfterLastError, (Object)error);
        ++this.indexAfterLastError;
    }

    private List<Node> errors() {
        return this.getChildren().subList(this.indexOfFirstError, this.indexAfterLastError);
    }

    final void removeError(GridError error) {
        if (this.errors().remove((Object)error)) {
            --this.indexAfterLastError;
        }
    }

    final void clear() {
        this.errors().clear();
    }

    private static Text[] resize(Text[] cells, int count, boolean header) {
        int i = cells.length;
        if (i != count) {
            cells = Arrays.copyOf(cells, count);
            if (count > i) {
                Font font = header ? Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0) : null;
                do {
                    Text cell = new Text();
                    if (header) {
                        cell.setFont(font);
                    }
                    cells[i] = cell;
                } while (++i < count);
            }
        }
        return cells;
    }

    private double valuesRegionX() {
        return this.leftBackground.getWidth();
    }

    private double valuesRegionY() {
        return this.topBackground.getHeight();
    }

    protected void layoutChildren(double xmin, double ymin, double width, double height) {
        this.clip.setX(xmin);
        this.clip.setY(xmin);
        this.clip.setWidth(width);
        this.clip.setHeight(height);
        double sy = height - 20.0;
        this.xScrollBar.resizeRelocate(0.0, sy, width, 20.0);
        this.yScrollBar.resizeRelocate(width - 20.0, 0.0, 20.0, sy);
        this.leftBackground.setHeight(height);
        this.topBackground.setWidth(width);
        double valuesRegionX = this.valuesRegionX();
        double valuesRegionY = this.valuesRegionY();
        int nx = Math.max(0, (int)Math.ceil((width - valuesRegionX - 20.0) / this.cellWidth + 1.0));
        int ny = Math.max(0, (int)Math.ceil((height - valuesRegionY - 20.0) / this.cellHeight + 1.0));
        int n = Math.multiplyExact(nx, ny);
        GridError[] errors = (GridError[])this.errors().toArray(GridError[]::new);
        Text[] headerRow = GridViewSkin.resize(this.headerRow, nx, true);
        Text[] headerColumn = GridViewSkin.resize(this.headerColumn, ny, true);
        Text[] valueCells = GridViewSkin.resize(this.valueCells, n, false);
        Object[] all = new Node[headerRow.length + headerColumn.length + valueCells.length + errors.length + 7];
        int i = 0;
        all[i++] = this.selection;
        System.arraycopy(valueCells, 0, all, i, n);
        int indexOfFirstError = i += n;
        System.arraycopy(errors, 0, all, i, errors.length);
        int indexAfterLastError = i += errors.length;
        all[i++] = this.topBackground;
        all[i++] = this.selectedColumn;
        all[i++] = this.leftBackground;
        all[i++] = this.selectedRow;
        System.arraycopy(headerRow, 0, all, i, nx);
        System.arraycopy(headerColumn, 0, all, i += nx, ny);
        i += ny;
        all[i++] = this.xScrollBar;
        all[i++] = this.yScrollBar;
        if (i != all.length) {
            throw new AssertionError(i);
        }
        for (Node node : all) {
            node.setManaged(false);
        }
        this.getChildren().setAll(all);
        this.headerRow = headerRow;
        this.headerColumn = headerColumn;
        this.valueCells = valueCells;
        this.indexOfFirstError = indexOfFirstError;
        this.indexAfterLastError = indexAfterLastError;
        GridView view = (GridView)this.getSkinnable();
        view.scaleScrollBar(this.xScrollBar, nx, false);
        view.scaleScrollBar(this.yScrollBar, ny, true);
        this.updateCellValues();
    }

    final void updateCellValues() {
        double cellWidth = this.cellWidth;
        double cellHeight = this.cellHeight;
        double valuesRegionX = this.valuesRegionX();
        double valuesRegionY = this.valuesRegionY();
        double xminOfValues = this.xScrollBar.getValue();
        double yminOfValues = this.yScrollBar.getValue();
        double d = xminOfValues;
        xminOfValues = Math.floor(xminOfValues);
        double xposOfValues = valuesRegionX - (d - xminOfValues) * cellWidth;
        double d2 = yminOfValues;
        yminOfValues = Math.floor(yminOfValues);
        double yposOfValues = valuesRegionY - (d2 - yminOfValues) * cellHeight;
        long xmin = (long)xminOfValues;
        long ymin = (long)yminOfValues;
        double cellInnerWidth = GridViewSkin.toValidCellSize(valuesRegionX - 9.0);
        GridView view = (GridView)this.getSkinnable();
        Text[] cells = this.headerColumn;
        int ny = cells.length;
        for (int y = 0; y < ny; ++y) {
            double ypos = yposOfValues + cellHeight * (double)y;
            GridViewSkin.setRightAlignedText(null, cells[y], view.formatCoordinateValue(ymin + (long)y), 0.0, ypos, cellInnerWidth, cellHeight);
        }
        cellInnerWidth = cellWidth;
        double cellSpacing = view.cellSpacing.get();
        if (cellSpacing > 0.0) {
            cellInnerWidth = GridViewSkin.toValidCellSize(cellInnerWidth - cellSpacing);
        }
        cells = this.headerRow;
        int nx = cells.length;
        for (int x = 0; x < nx; ++x) {
            double xpos = xposOfValues + cellWidth * (double)x;
            GridViewSkin.setRightAlignedText(null, cells[x], view.formatCoordinateValue(xmin + (long)x), xpos, 0.0, cellInnerWidth, valuesRegionY);
        }
        cells = this.valueCells;
        while (true) {
            for (int i = 0; i < cells.length; ++i) {
                int x = i % nx;
                int y = i / nx;
                double xpos = xposOfValues + (double)x * cellWidth;
                double ypos = yposOfValues + (double)y * cellHeight;
                if (GridViewSkin.setRightAlignedText(view, cells[i], view.formatSampleValue(xmin + (long)x, ymin + (long)y), xpos, ypos, cellInnerWidth, cellHeight)) continue;
            }
            break;
        }
        if (this.indexOfFirstError != this.indexAfterLastError) {
            java.awt.Rectangle viewArea = new java.awt.Rectangle(Numerics.clamp((long)xmin), Numerics.clamp((long)ymin), nx - 1, ny - 1);
            for (Node node : this.errors()) {
                boolean visible = false;
                GridError error = (GridError)node;
                java.awt.Rectangle area = error.getVisibleRegion(viewArea);
                if (!area.isEmpty()) {
                    error.resizeRelocate((double)((long)area.x - xmin) * cellWidth + xposOfValues, (double)((long)area.y - ymin) * cellHeight + yposOfValues, (double)area.width * cellWidth, (double)area.height * cellHeight);
                    visible = error.getHeight() >= 140.0 && error.getWidth() >= 140.0;
                }
                error.setVisible(visible);
            }
        }
    }

    private static boolean setRightAlignedText(GridView view, Text cell, String value, double x, double y, double width, double height) {
        boolean redo = false;
        cell.setText((String)value);
        if (value != null) {
            double dx;
            double dy;
            while (true) {
                int cut;
                Bounds bounds = cell.getLayoutBounds();
                dy = height - bounds.getHeight();
                dx = width - bounds.getWidth();
                if (dx >= 0.0) break;
                if (view != null) {
                    if (view.cellFormat.shorterPattern()) {
                        redo = true;
                        break;
                    }
                    view = null;
                }
                if ((cut = ((String)value).length() - 2) < 0) break;
                value = ((String)value).substring(0, cut) + "\u2026";
                cell.setText((String)value);
            }
            x += dx;
            y += dy * 0.5;
        }
        cell.relocate(x, y);
        return redo;
    }
}

