/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.hdfs;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.storm.hdfs.trident.HdfsState;
import org.apache.storm.hdfs.trident.HdfsStateFactory;
import org.apache.storm.hdfs.trident.HdfsUpdater;
import org.apache.storm.hdfs.trident.format.FileNameFormat;
import org.apache.storm.hdfs.trident.format.RecordFormat;
import org.apache.storm.hdfs.trident.format.SimpleFileNameFormat;
import org.apache.storm.hdfs.trident.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.trident.rotation.FileSizeRotationPolicy;
import org.apache.storm.hdfs.trident.rotation.TimedRotationPolicy;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.apache.storm.sql.runtime.SimpleSqlTridentConsumer;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.trident.spout.ITridentDataSource;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.tuple.TridentTuple;

public class HdfsDataSourcesProvider
implements DataSourcesProvider {
    public String scheme() {
        return "hdfs";
    }

    public DataSource construct(URI uri, String inputFormatClass, String outputFormatClass, List<FieldInfo> fields) {
        throw new UnsupportedOperationException();
    }

    public ISqlTridentDataSource constructTrident(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        List fieldNames = FieldInfoUtils.getFieldNames(fields);
        IOutputSerializer serializer = SerdeUtils.getSerializer((String)outputFormatClass, (Properties)properties, (List)fieldNames);
        return new HdfsTridentDataSource(uri.toString(), properties, serializer);
    }

    private static class TridentRecordFormat
    implements RecordFormat {
        private final IOutputSerializer serializer;

        private TridentRecordFormat(IOutputSerializer serializer) {
            this.serializer = serializer;
        }

        public byte[] format(TridentTuple tuple) {
            return this.serializer.write(tuple.getValues(), null).array();
        }
    }

    private static class HdfsTridentDataSource
    implements ISqlTridentDataSource {
        private final String url;
        private final Properties props;
        private final IOutputSerializer serializer;

        private HdfsTridentDataSource(String url, Properties props, IOutputSerializer serializer) {
            this.url = url;
            this.props = props;
            this.serializer = serializer;
        }

        public ITridentDataSource getProducer() {
            throw new UnsupportedOperationException(this.getClass().getName() + " doesn't provide Producer");
        }

        public ISqlTridentDataSource.SqlTridentConsumer getConsumer() {
            SimpleFileNameFormat fileNameFormat = new SimpleFileNameFormat().withPath(this.props.getProperty("hdfs.file.path", "/storm")).withName(this.props.getProperty("hdfs.file.name", "$TIME.$NUM.txt"));
            TridentRecordFormat recordFormat = new TridentRecordFormat(this.serializer);
            String size = this.props.getProperty("hdfs.rotation.size.kb");
            String interval = this.props.getProperty("hdfs.rotation.time.seconds");
            Preconditions.checkArgument((size != null || interval != null ? 1 : 0) != 0, (Object)"Hdfs data source must contain file rotation config");
            Object rotationPolicy = size != null ? new FileSizeRotationPolicy(Float.parseFloat(size), FileSizeRotationPolicy.Units.KB) : new TimedRotationPolicy(Float.parseFloat(interval), TimedRotationPolicy.TimeUnit.SECONDS);
            HdfsState.HdfsFileOptions options = new HdfsState.HdfsFileOptions().withFileNameFormat((FileNameFormat)fileNameFormat).withRecordFormat((RecordFormat)recordFormat).withRotationPolicy((FileRotationPolicy)rotationPolicy).withFsUrl(this.url);
            HdfsStateFactory stateFactory = new HdfsStateFactory().withOptions((HdfsState.Options)options);
            HdfsUpdater stateUpdater = new HdfsUpdater();
            return new SimpleSqlTridentConsumer((StateFactory)stateFactory, (StateUpdater)stateUpdater);
        }
    }
}

