/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.Principal;
import org.apache.kafka.shaded.common.network.TransportLayer;
import org.apache.kafka.shaded.common.security.auth.KafkaPrincipal;

public class PlaintextTransportLayer
implements TransportLayer {
    private final SelectionKey key;
    private final SocketChannel socketChannel;
    private final Principal principal = KafkaPrincipal.ANONYMOUS;

    public PlaintextTransportLayer(SelectionKey key) throws IOException {
        this.key = key;
        this.socketChannel = (SocketChannel)key.channel();
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public boolean finishConnect() throws IOException {
        boolean connected = this.socketChannel.finishConnect();
        if (connected) {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFF7 | 1);
        }
        return connected;
    }

    @Override
    public void disconnect() {
        this.key.cancel();
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.socketChannel.socket().close();
            this.socketChannel.close();
        }
        finally {
            this.key.attach(null);
            this.key.cancel();
        }
    }

    @Override
    public void handshake() throws IOException {
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.socketChannel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.socketChannel.read(dsts, offset, length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.socketChannel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.socketChannel.write(srcs);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.socketChannel.write(srcs, offset, length);
    }

    @Override
    public boolean hasPendingWrites() {
        return false;
    }

    @Override
    public Principal peerPrincipal() throws IOException {
        return this.principal;
    }

    @Override
    public void addInterestOps(int ops2) {
        this.key.interestOps(this.key.interestOps() | ops2);
    }

    @Override
    public void removeInterestOps(int ops2) {
        this.key.interestOps(this.key.interestOps() & ~ops2);
    }

    @Override
    public boolean isMute() {
        return this.key.isValid() && (this.key.interestOps() & 1) == 0;
    }

    @Override
    public long transferFrom(FileChannel fileChannel, long position, long count2) throws IOException {
        return fileChannel.transferTo(position, count2, this.socketChannel);
    }
}

