/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.submit.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.repository.RemoteRepository;

public class AetherUtils {
    private AetherUtils() {
    }

    public static Dependency parseDependency(String dependency) {
        List<String> dependencyAndExclusions = Arrays.asList(dependency.split("\\^"));
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        for (int idx = 1; idx < dependencyAndExclusions.size(); ++idx) {
            exclusions.add(AetherUtils.createExclusion(dependencyAndExclusions.get(idx)));
        }
        DefaultArtifact artifact = new DefaultArtifact(dependencyAndExclusions.get(0));
        return new Dependency((Artifact)artifact, "compile", false, exclusions);
    }

    public static Exclusion createExclusion(String exclusionString) {
        String[] parts = exclusionString.split(":");
        String artifactId = "*";
        String classifier = "*";
        String extension = "*";
        int len = parts.length;
        if (len > 1) {
            artifactId = parts[1];
        }
        if (len > 2) {
            classifier = parts[2];
        }
        if (len > 3) {
            extension = parts[3];
        }
        String groupId = parts[0];
        return new Exclusion(groupId, artifactId, classifier, extension);
    }

    public static String artifactToString(Artifact artifact) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(artifact.getGroupId());
        buffer.append(':').append(artifact.getArtifactId());
        buffer.append(':').append(artifact.getExtension());
        if (artifact.getClassifier().length() > 0) {
            buffer.append(':').append(artifact.getClassifier());
        }
        buffer.append(':').append(artifact.getVersion());
        return buffer.toString();
    }

    public static RemoteRepository parseRemoteRepository(String repository) {
        String[] parts = repository.split("\\^");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Bad remote repository form: " + repository);
        }
        return new RemoteRepository.Builder(parts[0], "default", parts[1]).build();
    }
}

