/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.sisu.inject.Weak;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassRealmUtils {
    private static final boolean GET_IMPORT_REALMS_SUPPORTED;
    private static Map<ClassRealm, Set<String>> namesCache;

    static {
        boolean getImportRealmsSupported = true;
        try {
            ClassRealm.class.getDeclaredMethod("getImportRealms", new Class[0]);
        }
        catch (Exception exception) {
            getImportRealmsSupported = false;
        }
        catch (LinkageError linkageError) {
            getImportRealmsSupported = false;
        }
        GET_IMPORT_REALMS_SUPPORTED = getImportRealmsSupported;
        namesCache = Weak.concurrentKeys();
    }

    private ClassRealmUtils() {
    }

    public static ClassRealm contextRealm() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        while (tccl != null) {
            if (tccl instanceof ClassRealm) {
                return (ClassRealm)tccl;
            }
            tccl = tccl.getParent();
        }
        return null;
    }

    public static Set<String> visibleRealmNames(ClassRealm contextRealm) {
        if (GET_IMPORT_REALMS_SUPPORTED && contextRealm != null) {
            Set<String> names = namesCache.get(contextRealm);
            if (names == null) {
                names = ClassRealmUtils.computeVisibleNames(contextRealm);
                namesCache.put(contextRealm, names);
            }
            return names;
        }
        return null;
    }

    private static Set<String> computeVisibleNames(ClassRealm forRealm) {
        HashSet<String> visibleRealmNames = new HashSet<String>();
        ArrayList<ClassRealm> searchRealms = new ArrayList<ClassRealm>();
        searchRealms.add(forRealm);
        int i = 0;
        while (i < searchRealms.size()) {
            ClassRealm realm = (ClassRealm)searchRealms.get(i);
            if (visibleRealmNames.add(realm.toString())) {
                searchRealms.addAll(realm.getImportRealms());
                ClassRealm parent = realm.getParentRealm();
                if (parent != null) {
                    searchRealms.add(parent);
                }
            }
            ++i;
        }
        return visibleRealmNames;
    }
}

