/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hive.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.storm.common.AbstractAutoCreds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHive
extends AbstractAutoCreds {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHive.class);
    public static final String HIVE_CREDENTIALS = "HIVE_CREDENTIALS";
    public static final String HIVE_CREDENTIALS_CONFIG_KEYS = "hiveCredentialsConfigKeys";
    public static final String HIVE_KEYTAB_FILE_KEY = "hive.keytab.file";
    public static final String HIVE_PRINCIPAL_KEY = "hive.kerberos.principal";
    public String hiveKeytab;
    public String hivePrincipal;
    public String metaStoreURI;

    @Override
    public void doPrepare(Map conf) {
        if (conf.containsKey(HIVE_KEYTAB_FILE_KEY) && conf.containsKey(HIVE_PRINCIPAL_KEY)) {
            this.hiveKeytab = (String)conf.get(HIVE_KEYTAB_FILE_KEY);
            this.hivePrincipal = (String)conf.get(HIVE_PRINCIPAL_KEY);
            this.metaStoreURI = (String)conf.get(HiveConf.ConfVars.METASTOREURIS.varname);
        }
    }

    @Override
    protected String getConfigKeyString() {
        return HIVE_CREDENTIALS_CONFIG_KEYS;
    }

    public void shutdown() {
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String configKey, String topologyOwnerPrincipal) {
        Configuration configuration = this.getHadoopConfiguration(conf, configKey);
        return this.getHadoopCredentials(conf, configuration, topologyOwnerPrincipal);
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String topologyOwnerPrincipal) {
        Configuration configuration = new Configuration();
        return this.getHadoopCredentials(conf, configuration, topologyOwnerPrincipal);
    }

    private Configuration getHadoopConfiguration(Map topoConf, String configKey) {
        Configuration configuration = new Configuration();
        this.fillHadoopConfiguration(topoConf, configKey, configuration);
        return configuration;
    }

    public HiveConf createHiveConf(String metaStoreURI, String hiveMetaStorePrincipal) throws IOException {
        HiveConf hcatConf = new HiveConf();
        hcatConf.setVar(HiveConf.ConfVars.METASTOREURIS, metaStoreURI);
        hcatConf.setIntVar(HiveConf.ConfVars.METASTORETHRIFTCONNECTIONRETRIES, 3);
        hcatConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        hcatConf.setBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, true);
        hcatConf.set(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.varname, hiveMetaStorePrincipal);
        return hcatConf;
    }

    protected byte[] getHadoopCredentials(Map<String, Object> conf, Configuration configuration, String topologyOwnerPrincipal) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                String hiveMetaStoreURI = this.getMetaStoreURI(configuration);
                String hiveMetaStorePrincipal = this.getMetaStorePrincipal(configuration);
                HiveConf hcatConf = this.createHiveConf(hiveMetaStoreURI, hiveMetaStorePrincipal);
                this.login(configuration);
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologyOwnerPrincipal, (UserGroupInformation)currentUser);
                try {
                    Token<DelegationTokenIdentifier> delegationTokenId = this.getDelegationToken(hcatConf, hiveMetaStorePrincipal, topologyOwnerPrincipal);
                    proxyUser.addToken(delegationTokenId);
                    LOG.info("Obtained Hive tokens, adding to user credentials.");
                    Credentials credential = proxyUser.getCredentials();
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bao);
                    credential.write((DataOutput)out);
                    out.flush();
                    out.close();
                    return bao.toByteArray();
                }
                catch (Exception ex) {
                    LOG.debug(" Exception" + ex.getMessage());
                    throw ex;
                }
            }
            throw new RuntimeException("Security is not enabled for Hadoop");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token<DelegationTokenIdentifier> getDelegationToken(HiveConf hcatConf, String metaStoreServicePrincipal, String topologySubmitterUser) throws IOException {
        LOG.info("Creating delegation tokens for principal={}", (Object)metaStoreServicePrincipal);
        try (HCatClient hcatClient = null;){
            hcatClient = HCatClient.create((Configuration)hcatConf);
            String delegationToken = hcatClient.getDelegationToken(topologySubmitterUser, metaStoreServicePrincipal);
            Token delegationTokenId = new Token();
            delegationTokenId.decodeFromUrlString(delegationToken);
            DelegationTokenIdentifier d = new DelegationTokenIdentifier();
            d.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(delegationTokenId.getIdentifier())));
            LOG.info("Created Delegation Token for : " + d.getUser());
            Token token = delegationTokenId;
            return token;
        }
    }

    private String getMetaStoreURI(Configuration configuration) {
        if (configuration.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            return this.metaStoreURI;
        }
        return configuration.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    private String getMetaStorePrincipal(Configuration configuration) {
        if (configuration.get(HIVE_PRINCIPAL_KEY) == null) {
            return this.hivePrincipal;
        }
        return configuration.get(HIVE_PRINCIPAL_KEY);
    }

    private void login(Configuration configuration) throws IOException {
        if (configuration.get(HIVE_KEYTAB_FILE_KEY) == null) {
            configuration.set(HIVE_KEYTAB_FILE_KEY, this.hiveKeytab);
        }
        if (configuration.get(HIVE_PRINCIPAL_KEY) == null) {
            configuration.set(HIVE_PRINCIPAL_KEY, this.hivePrincipal);
        }
        SecurityUtil.login((Configuration)configuration, (String)HIVE_KEYTAB_FILE_KEY, (String)HIVE_PRINCIPAL_KEY);
        LOG.info("Logged into hive with principal {}", (Object)configuration.get(HIVE_PRINCIPAL_KEY));
    }

    @Override
    public void doRenew(Map<String, String> credentials, Map<String, Object> topologyConf, String ownerPrincipal) {
        for (Pair<String, Credentials> cred : this.getCredentials(credentials)) {
            try {
                Configuration configuration = this.getHadoopConfiguration(topologyConf, (String)cred.getFirst());
                String hiveMetaStoreURI = this.getMetaStoreURI(configuration);
                String hiveMetaStorePrincipal = this.getMetaStorePrincipal(configuration);
                Collection tokens = ((Credentials)cred.getSecond()).getAllTokens();
                this.login(configuration);
                if (tokens != null && !tokens.isEmpty()) {
                    for (Token token : tokens) {
                        long expiration = this.renewToken(token, hiveMetaStoreURI, hiveMetaStorePrincipal);
                        LOG.info("Hive delegation token renewed, new expiration time {}", (Object)expiration);
                    }
                    continue;
                }
                LOG.debug("No tokens found for credentials, skipping renewal.");
            }
            catch (Exception e) {
                LOG.warn("could not renew the credentials, one of the possible reason is tokens are beyond renewal period so attempting to get new tokens.", (Throwable)e);
                this.populateCredentials(credentials, topologyConf, ownerPrincipal);
            }
        }
    }

    private long renewToken(Token token, String metaStoreURI, String hiveMetaStorePrincipal) {
        HCatClient hcatClient = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                String tokenStr = token.encodeToUrlString();
                HiveConf hcatConf = this.createHiveConf(metaStoreURI, hiveMetaStorePrincipal);
                LOG.debug("renewing delegation tokens for principal={}", (Object)hiveMetaStorePrincipal);
                hcatClient = HCatClient.create((Configuration)hcatConf);
                Long expiryTime = hcatClient.renewDelegationToken(tokenStr);
                LOG.info("Renewed delegation token. new expiryTime={}", (Object)expiryTime);
                long l = expiryTime;
                return l;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to renew delegation tokens.", ex);
            }
            finally {
                if (hcatClient != null) {
                    try {
                        hcatClient.close();
                    }
                    catch (HCatException e) {
                        LOG.error(" Exception", (Throwable)e);
                    }
                }
            }
        }
        throw new RuntimeException("Security is not enabled for Hadoop");
    }

    @Override
    protected String getCredentialKey(String configKey) {
        return HIVE_CREDENTIALS + configKey;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String topologyOwnerPrincipal = args[0];
        conf.put(HIVE_PRINCIPAL_KEY, args[1]);
        conf.put(HIVE_KEYTAB_FILE_KEY, args[2]);
        conf.put(HiveConf.ConfVars.METASTOREURIS.varname, args[3]);
        AutoHive autoHive = new AutoHive();
        autoHive.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHive.populateCredentials(creds, conf, topologyOwnerPrincipal);
        LOG.info("Got Hive credentials" + autoHive.getCredentials(creds));
        Subject subject = new Subject();
        autoHive.populateSubject(subject, creds);
        LOG.info("Got a Subject " + subject);
    }

    public void populateCredentials(Map<String, String> credentials, Map topoConf) {
        throw new IllegalStateException("SHOULD NOT BE CALLED");
    }

    public void renew(Map<String, String> credentials, Map topologyConf) {
        throw new IllegalStateException("SHOULD NOT BE CALLED");
    }
}

