/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Get
extends Query
implements Row,
Comparable<Row> {
    private static final Log LOG = LogFactory.getLog(Get.class);
    private byte[] row = null;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private int storeLimit = -1;
    private int storeOffset = 0;
    private TimeRange tr = new TimeRange();
    private boolean checkExistenceOnly = false;
    private boolean closestRowBefore = false;
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Get(byte[] row) {
        Mutation.checkRow(row);
        this.row = row;
    }

    public Get(Get get) {
        this(get.getRow());
        this.filter = get.getFilter();
        this.cacheBlocks = get.getCacheBlocks();
        this.maxVersions = get.getMaxVersions();
        this.storeLimit = get.getMaxResultsPerColumnFamily();
        this.storeOffset = get.getRowOffsetPerColumnFamily();
        this.tr = get.getTimeRange();
        this.checkExistenceOnly = get.isCheckExistenceOnly();
        this.closestRowBefore = get.isClosestRowBefore();
        this.familyMap = get.getFamilyMap();
        for (Map.Entry<String, byte[]> attr : get.getAttributesMap().entrySet()) {
            this.setAttribute(attr.getKey(), attr.getValue());
        }
    }

    public boolean isCheckExistenceOnly() {
        return this.checkExistenceOnly;
    }

    public Get setCheckExistenceOnly(boolean checkExistenceOnly) {
        this.checkExistenceOnly = checkExistenceOnly;
        return this;
    }

    public boolean isClosestRowBefore() {
        return this.closestRowBefore;
    }

    public Get setClosestRowBefore(boolean closestRowBefore) {
        this.closestRowBefore = closestRowBefore;
        return this;
    }

    public Get addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Get addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Get setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Get setTimeStamp(long timestamp) throws IOException {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException e) {
            LOG.error((Object)"TimeRange failed, likely caused by integer overflow. ", (Throwable)e);
            throw e;
        }
        return this;
    }

    public Get setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Get setMaxVersions(int maxVersions) throws IOException {
        if (maxVersions <= 0) {
            throw new IOException("maxVersions must be positive");
        }
        this.maxVersions = maxVersions;
        return this;
    }

    public Get setMaxResultsPerColumnFamily(int limit) {
        this.storeLimit = limit;
        return this;
    }

    public Get setRowOffsetPerColumnFamily(int offset) {
        this.storeOffset = offset;
        return this;
    }

    @Override
    public Get setFilter(Filter filter) {
        super.setFilter(filter);
        return this;
    }

    public Get setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getMaxResultsPerColumnFamily() {
        return this.storeLimit;
    }

    public int getRowOffsetPerColumnFamily() {
        return this.storeOffset;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary((byte[])this.row));
        map.put("maxVersions", this.maxVersions);
        map.put("cacheBlocks", this.cacheBlocks);
        ArrayList<Long> timeRange = new ArrayList<Long>();
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary((byte[])entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary((byte[])column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    @Override
    public int compareTo(Row other) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])other.getRow());
    }

    public int hashCode() {
        return Bytes.hashCode((byte[])this.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public Get setAttribute(String name, byte[] value) {
        return (Get)super.setAttribute(name, value);
    }

    @Override
    public Get setId(String id) {
        return (Get)super.setId(id);
    }

    @Override
    public Get setAuthorizations(Authorizations authorizations) {
        return (Get)super.setAuthorizations(authorizations);
    }

    @Override
    public Get setACL(Map<String, Permission> perms) {
        return (Get)super.setACL(perms);
    }

    @Override
    public Get setACL(String user, Permission perms) {
        return (Get)super.setACL(user, perms);
    }

    @Override
    public Get setConsistency(Consistency consistency) {
        return (Get)super.setConsistency(consistency);
    }

    @Override
    public Get setReplicaId(int Id) {
        return (Get)super.setReplicaId(Id);
    }

    @Override
    public Get setIsolationLevel(IsolationLevel level) {
        return (Get)super.setIsolationLevel(level);
    }
}

