/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.expression.CaseExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class StringIndexOf5Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"indexOf", (Object)"StringExpression", (Object)0, (Object)"StringExpression/CharacterExpression/ParameterLiteral"));
        }
        SQLExpression substrExpr = (SQLExpression)args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"indexOf", (Object)"StringExpression", (Object)0, (Object)"StringExpression/CharacterExpression/ParameterLiteral"));
        }
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        if (args.size() == 1) {
            funcArgs.add(expr);
            funcArgs.add(substrExpr);
            SQLExpression oneExpr = ExpressionUtils.getLiteralForOne(this.stmt);
            NumericExpression locateExpr = new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "STRPOS", funcArgs);
            return new NumericExpression(locateExpr, Expression.OP_SUB, oneExpr);
        }
        SQLExpression fromExpr = (SQLExpression)args.get(1);
        if (!(fromExpr instanceof NumericExpression)) {
            throw new NucleusException(LOCALISER.msg("060003", (Object)"indexOf", (Object)"StringExpression", (Object)1, (Object)"NumericExpression"));
        }
        ArrayList<SQLExpression> substrArgs = new ArrayList<SQLExpression>(1);
        substrArgs.add(fromExpr);
        SQLExpression strExpr = this.exprFactory.invokeMethod(this.stmt, "java.lang.String", "substring", expr, substrArgs);
        funcArgs.add(strExpr);
        funcArgs.add(substrExpr);
        NumericExpression locateExpr = new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "STRPOS", funcArgs);
        SQLExpression[] whenExprs = new SQLExpression[1];
        IntegerLiteral zeroExpr = new IntegerLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.class, false), 0, null);
        whenExprs[0] = locateExpr.gt(zeroExpr);
        SQLExpression[] actionExprs = new SQLExpression[1];
        SQLExpression oneExpr = ExpressionUtils.getLiteralForOne(this.stmt);
        NumericExpression posExpr1 = new NumericExpression(locateExpr, Expression.OP_SUB, oneExpr);
        actionExprs[0] = new NumericExpression(posExpr1, Expression.OP_ADD, fromExpr);
        IntegerLiteral elseExpr = new IntegerLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.class, false), -1, null);
        return new CaseExpression(whenExprs, actionExprs, (SQLExpression)elseExpr);
    }
}

