/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.MultiLanguageAttrValue;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;

public class NativeType
extends Type {
    private MultiLanguageAttrValue nativeType;

    public NativeType(SourcePosition sourcePosition, String displayName, MultiLanguageAttrValue nativeType) {
        super(sourcePosition, displayName);
        this.nativeType = Preconditions.checkNotNull(nativeType);
    }

    public NativeType(Node fromNode, MultiLanguageAttrValue nativeType) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), nativeType);
    }

    public NativeType(Node fromNode, String type) {
        this(fromNode, new MultiLanguageAttrValue(type));
    }

    public String getNativeType(OutputLanguage outputLanguage) {
        return this.nativeType.get(outputLanguage);
    }

    @Override
    public boolean onlyAllowedInParam() {
        return false;
    }

    @Override
    public boolean takesDefaultParam() {
        return true;
    }

    @Override
    public boolean takesRegexParam() {
        return true;
    }

    @Override
    public boolean takesConstructorParam() {
        return true;
    }

    @Override
    public Expression parseObjectConstant(String paramName, ObjectConstant objectConstant, AlertSink alertSink) {
        return objectConstant.withType(this);
    }

    @Override
    public <T> T acceptTypeVisitor(TypeVisitor<T> visitor) {
        return visitor.visitNativeType(this);
    }

    @Override
    public String toString() {
        return "NativeType";
    }

    @Override
    public boolean matches(Type that) {
        return that instanceof NativeType;
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof NativeType && this.equals((NativeType)that);
    }

    public boolean equals(NativeType that) {
        return this.equalsType(that) && Objects.equal(this.nativeType, that.nativeType);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.typeHashCode(), this.nativeType);
    }
}

