/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Arrays;
import java.util.BitSet;

public class CharPredicateCache {
    private static final int BLOCK_SIZE_EXP = 11;
    private static final int BITSET_SIZE = 4096;
    private static final int ALLOCATE_IN_ADVANCE_SIZE = 127;
    private static final int BIT_INDEX_MASK = 2047;
    private static final int BMP_BITSET_COUNT = 32;
    private static final int MAX_CODEPOINT = 196607;
    private BitSet[] bitSets = new BitSet[32];

    private boolean cacheable(int codepoint) {
        return codepoint >= 0 && codepoint <= 196607;
    }

    private int setIndex(int codepoint) {
        return codepoint >>> 11;
    }

    private int bitIndex(int codepoint) {
        return (codepoint & 0x7FF) << 1;
    }

    public Result getCached(int codepoint) {
        if (!this.cacheable(codepoint)) {
            return Result.NOT_CACHEABLE;
        }
        int setIndex = this.setIndex(codepoint);
        if (setIndex >= this.bitSets.length || this.bitSets[setIndex] == null) {
            return Result.NOT_FOUND;
        }
        int bitIndex = this.bitIndex(codepoint);
        if (this.bitSets[setIndex].get(bitIndex)) {
            return Result.TRUE;
        }
        if (this.bitSets[setIndex].get(bitIndex + 1)) {
            return Result.FALSE;
        }
        return Result.NOT_FOUND;
    }

    public void set(int codepoint, boolean result) {
        if (!this.cacheable(codepoint)) {
            throw new IllegalArgumentException("Codepoint " + codepoint + " not cacheable");
        }
        int setIndex = this.setIndex(codepoint);
        if (setIndex >= this.bitSets.length) {
            int maxSetIndex = this.setIndex(196607);
            this.bitSets = Arrays.copyOf(this.bitSets, maxSetIndex + 1);
        }
        int bitIndex = this.bitIndex(codepoint);
        BitSet bitSet = this.bitSets[setIndex];
        if (bitSet == null) {
            int allocateSize = Math.min(bitIndex + 127, 4096);
            bitSet = this.bitSets[setIndex] = new BitSet(allocateSize);
        }
        bitSet.set(result ? bitIndex : bitIndex + 1);
        bitSet.clear(result ? bitIndex + 1 : bitIndex);
    }

    public static enum Result {
        TRUE,
        FALSE,
        NOT_FOUND,
        NOT_CACHEABLE;

    }
}

