/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.MessageStoreFactory;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.message.store.MessageStore;

public class MessageStoreDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(MessageStoreDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message Store Deployment from file : " + fileName + " : Started"));
        }
        try {
            MessageStore ms = MessageStoreFactory.createMessageStore(artifactConfig, properties);
            if (ms != null) {
                ms.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message Store named '" + ms.getName() + "' has been built from the file " + fileName));
                }
                ms.init(this.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the Message Store : " + ms.getName()));
                }
                this.getSynapseConfiguration().addMessageStore(ms.getName(), ms);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message Store Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("Message Store named '" + ms.getName() + "' has been deployed from file : " + fileName));
                return ms.getName();
            }
            this.handleSynapseArtifactDeploymentError("Message Store Deployment from the file : " + fileName + " : Failed. The artifact described in the file  is not a Message Store");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Message Store Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message Store update from file : " + fileName + " has started"));
        }
        try {
            MessageStore ms = MessageStoreFactory.createMessageStore(artifactConfig, properties);
            if (ms == null) {
                this.handleSynapseArtifactDeploymentError("Message Store update failed. The artifact defined in the file: " + fileName + " is not valid");
                return null;
            }
            ms.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("MessageStore: " + ms.getName() + " has been built from the file: " + fileName));
            }
            ms.init(this.getSynapseEnvironment());
            MessageStore existingMs = this.getSynapseConfiguration().getMessageStore(existingArtifactName);
            this.getSynapseConfiguration().removeMessageStore(existingArtifactName);
            this.getSynapseConfiguration().addMessageStore(ms.getName(), ms);
            log.info((Object)("MessageStore: " + existingArtifactName + " has been undeployed"));
            log.info((Object)("MessageStore: " + ms.getName() + " has been updated from the file: " + fileName));
            this.waitForCompletion();
            existingMs.destroy();
            return ms.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the MessageStore from the file: " + fileName);
            return null;
        }
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("MessageStore Undeployment of the MessageStore named : " + artifactName + " : Started"));
        }
        try {
            MessageStore ms = this.getSynapseConfiguration().getMessageStore(artifactName);
            if (ms != null) {
                this.getSynapseConfiguration().removeMessageStore(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying the MessageStore named : " + artifactName));
                }
                ms.destroy();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MessageStore Undeployment of the endpoint named : " + artifactName + " : Completed"));
                }
                log.info((Object)("MessageStore named '" + ms.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("MessageStore " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("MessageStore Undeployement of MessageStore named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the MessageStore with name : " + artifactName + " : Started"));
        }
        try {
            MessageStore ms = this.getSynapseConfiguration().getMessageStore(artifactName);
            OMElement msElem = MessageStoreSerializer.serializeMessageStore(null, ms);
            if (ms.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "message-stores" + File.separator + ms.getFileName();
                this.writeToFile(msElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the MessageStore with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("MessageStore named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the MessageStore named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the MessageStore named '" + artifactName + "' has failed", e);
        }
    }
}

