/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.format.hessian;

import java.io.IOException;
import java.io.OutputStream;

public final class HessianUtils {
    private HessianUtils() {
    }

    public static void writeFault(String code, String message, String detail, OutputStream os) throws IOException {
        HessianUtils.startReply(os);
        os.write(102);
        HessianUtils.writeString("code", os);
        HessianUtils.writeString(code, os);
        HessianUtils.writeString("message", os);
        HessianUtils.writeString(message, os);
        if (detail != null) {
            HessianUtils.writeString("detail", os);
            HessianUtils.writeString(detail, os);
        }
        os.write(122);
        HessianUtils.completeReply(os);
    }

    private static void startReply(OutputStream os) throws IOException {
        os.write(114);
        os.write(1);
        os.write(0);
    }

    private static void completeReply(OutputStream os) throws IOException {
        os.write(122);
    }

    private static void writeString(String value, OutputStream os) throws IOException {
        if (value == null) {
            os.write(78);
        } else {
            int length = value.length();
            int offset = 0;
            while (length > 32768) {
                int sublen = 32768;
                char tail = value.charAt(offset + sublen - 1);
                if ('\ud800' <= tail && tail <= '\udbff') {
                    --sublen;
                }
                os.write(115);
                os.write(sublen >> 8);
                os.write(sublen);
                HessianUtils.printString(value, offset, sublen, os);
                length -= sublen;
                offset += sublen;
            }
            os.write(83);
            os.write(length >> 8);
            os.write(length);
            HessianUtils.printString(value, offset, length, os);
        }
    }

    private static void printString(String v, int offset, int length, OutputStream os) throws IOException {
        for (int i = 0; i < length; ++i) {
            char ch = v.charAt(i + offset);
            if (ch < '\u0080') {
                os.write(ch);
                continue;
            }
            if (ch < '\u0800') {
                os.write(192 + (ch >> 6 & 0x1F));
                os.write(128 + (ch & 0x3F));
                continue;
            }
            os.write(224 + (ch >> 12 & 0xF));
            os.write(128 + (ch >> 6 & 0x3F));
            os.write(128 + (ch & 0x3F));
        }
    }
}

