/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jaskell;

import com.sun.script.jaskell.JaskellScriptEngineFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jfun.jaskell.DefaultResolver;
import jfun.jaskell.Jaskell;
import jfun.jaskell.JaskellException;
import jfun.jaskell.Resolver;
import jfun.jaskell.Tuple;
import jfun.jaskell.ast.Expr;
import jfun.jaskell.ast.FunDef;
import jfun.jaskell.function.Function;
import jfun.parsec.ParserException;
import jfun.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaskellScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private Jaskell runtime;
    private volatile ScriptEngineFactory factory;
    private static final String MODULE_ID = "jaskell_engine";
    private static final String MODULE_NAME = "Jaskell Script Engine";
    private static final String GLOBALS_TUPLE = "globals-tuple";
    private static final /* synthetic */ Class class$jfun$jaskell$Jaskell;
    private static final /* synthetic */ Class class$java$lang$Object;

    public JaskellScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    JaskellScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.runtime = Jaskell.defaultInstance((ClassLoader)this.getClassLoader());
        this.runtime = this.runtime.importStandardClasses().importPrelude(true);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), this.context);
    }

    @Override
    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        return this.evalExpr(this.compileCode(script, ctx), ctx);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            JaskellScriptEngine jaskellScriptEngine = this;
            synchronized (jaskellScriptEngine) {
                if (this.factory == null) {
                    this.factory = new JaskellScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new JaskellCompiledScript(this.compileCode(script, this.context), null);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("method name is null");
        }
        Object tmp = this.getCurrentRuntime(this.context).eval((CharSequence)name);
        if (!(tmp instanceof Function)) {
            throw new NoSuchMethodException();
        }
        Function f = (Function)tmp;
        Object result = args == null || args.length == 0 ? f.f((Object)List.nil) : f.apply(args);
        return result;
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("script object is null");
        }
        if (name == null) {
            throw new NullPointerException("method name is null");
        }
        return this.invokeMethodImpl(thiz, name, args, class$java$lang$Object == null ? (class$java$lang$Object = JaskellScriptEngine.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public <T> T getInterface(Class<T> clasz) {
        return this.makeInterface(null, clasz);
    }

    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(thiz, clasz);
    }

    private Jaskell getCurrentRuntime(ScriptContext ctx) {
        return this.runtime.setResolver((Resolver)new ScriptContextResolver(ctx, null));
    }

    private Object invokeMethodImpl(Object thiz, String name, Object[] args, Class returnType) throws ScriptException, NoSuchMethodException {
        Object result;
        Jaskell jaskell = this.getCurrentRuntime(this.context);
        Object tmp = jaskell.eval((CharSequence)new StringBuffer().append("\\obj->obj.").append(name).toString());
        if (!(tmp instanceof Function)) {
            throw new NoSuchMethodException();
        }
        Function f = (Function)tmp;
        tmp = f.f(thiz);
        if (!(tmp instanceof Function)) {
            throw new NoSuchMethodException();
        }
        f = (Function)tmp;
        if (thiz instanceof Tuple) {
            result = args == null || args.length == 0 ? f.f((Object)List.nil) : f.apply(args);
        } else {
            if (args == null) {
                args = EMPTY_ARGS;
            }
            result = f.f((Object)args);
        }
        if (returnType != (class$java$lang$Object == null ? (class$java$lang$Object = JaskellScriptEngine.class$("java.lang.Object")) : class$java$lang$Object)) {
            result = Jaskell.castToJava((Class)returnType, (Object)result, (Object)"conversion");
        }
        return result;
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        final Object thiz = obj;
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return JaskellScriptEngine.access$300(JaskellScriptEngine.this, thiz, m.getName(), args, m.getReturnType());
            }
        });
    }

    private ClassLoader getClassLoader() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = ctxtLoader.loadClass("jfun.jaskell.Jaskell");
            if (c == (class$jfun$jaskell$Jaskell == null ? (class$jfun$jaskell$Jaskell = JaskellScriptEngine.class$("jfun.jaskell.Jaskell")) : class$jfun$jaskell$Jaskell)) {
                return ctxtLoader;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return (class$jfun$jaskell$Jaskell == null ? (class$jfun$jaskell$Jaskell = JaskellScriptEngine.class$("jfun.jaskell.Jaskell")) : class$jfun$jaskell$Jaskell).getClassLoader();
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expr compileCode(String code, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        try {
            Object oldTuple;
            Jaskell jaskell = this.getCurrentRuntime(ctx);
            Object parsed = Jaskell.parseExprOrLib((Object)MODULE_ID, (String)MODULE_NAME, (CharSequence)code);
            if (parsed instanceof Expr) {
                return Jaskell.compileExpr((Expr)((Expr)parsed));
            }
            Tuple tuple = jaskell.evalLib(Jaskell.compileLib((FunDef[])((FunDef[])parsed)));
            if (tuple.containsKey((Object)"jaskell")) {
                tuple = tuple.remove((Object)"jaskell");
            }
            if ((oldTuple = ctx.getAttribute(GLOBALS_TUPLE, 100)) instanceof Tuple) {
                tuple = Tuple.includesTuple((Tuple)((Tuple)oldTuple), (Tuple)tuple);
            }
            ScriptContext scriptContext = ctx;
            synchronized (scriptContext) {
                ctx.setAttribute(GLOBALS_TUPLE, tuple, 100);
            }
            return null;
        }
        catch (ParserException pexp) {
            throw new ScriptException((Exception)((Object)pexp));
        }
        catch (JaskellException jexp) {
            throw new ScriptException((Exception)((Object)jexp));
        }
    }

    private Object evalExpr(Expr expr, ScriptContext ctx) throws ScriptException {
        if (expr == null) {
            return null;
        }
        ctx.setAttribute("context", ctx, 100);
        Object tmp = ctx.getAttribute(GLOBALS_TUPLE, 100);
        try {
            Tuple tuple = tmp instanceof Tuple ? (Tuple)tmp : null;
            Jaskell jaskell = this.getCurrentRuntime(ctx);
            jaskell = jaskell.importTuple(null, tuple);
            return jaskell.eval(expr);
        }
        catch (JaskellException jexp) {
            throw new ScriptException((Exception)((Object)jexp));
        }
    }

    static Object access$000(JaskellScriptEngine x0, Expr x1, ScriptContext x2) throws ScriptException {
        return x0.evalExpr(x1, x2);
    }

    static Object access$300(JaskellScriptEngine x0, Object x1, String x2, Object[] x3, Class x4) throws ScriptException, NoSuchMethodException {
        return x0.invokeMethodImpl(x1, x2, x3, x4);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    private static class ScriptContextResolver
    extends DefaultResolver {
        private ScriptContext ctx;

        private ScriptContextResolver(ScriptContext ctx) {
            this.ctx = ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object resolveVar(String name, Object def) {
            ScriptContext scriptContext = this.ctx;
            synchronized (scriptContext) {
                int scope = this.ctx.getAttributesScope(name);
                if (scope != -1) {
                    return this.ctx.getAttribute(name);
                }
            }
            return super.resolveVar(name, def);
        }

        ScriptContextResolver(ScriptContext x0, 1 x1) {
            this(x0);
        }
    }

    private class JaskellCompiledScript
    extends CompiledScript {
        Expr expr;

        private JaskellCompiledScript(Expr expr) {
            this.expr = expr;
        }

        private JaskellCompiledScript() {
            this(null);
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            if (this.expr != null) {
                return JaskellScriptEngine.access$000(JaskellScriptEngine.this, this.expr, ctx);
            }
            return null;
        }

        public ScriptEngine getEngine() {
            return JaskellScriptEngine.this;
        }

        JaskellCompiledScript(Expr x1, 1 x2) {
            this(x1);
        }
    }
}

