/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Protocol {
    soap11,
    soap12,
    rest,
    unknown;

    private static final Log log;
    private static Map<String, Protocol> protocolMappings;
    private static final String SOAP11_WSDL_BINDING = "http://schemas.xmlsoap.org/wsdl/soap";
    private static final String SOAP12_WSDL_BINDING = "http://schemas.xmlsoap.org/wsdl/soap12";

    public static Protocol getProtocolForBinding(String url) {
        Protocol proto;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Configuring message protocol for binding [" + url + "]"));
        }
        if ((proto = protocolMappings.get(url)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found protocol mapping: " + (Object)((Object)proto)));
            }
            return proto;
        }
        if (debug) {
            log.debug((Object)("Protocol was not found for:" + url));
        }
        return null;
    }

    static {
        log = LogFactory.getLog(Protocol.class);
        protocolMappings = new HashMap<String, Protocol>();
        protocolMappings.put(SOAP11_WSDL_BINDING, soap11);
        protocolMappings.put("http://schemas.xmlsoap.org/wsdl/soap/http", soap11);
        protocolMappings.put("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", soap11);
        protocolMappings.put("http://www.w3.org/2010/soapjms/", soap11);
        protocolMappings.put("http://www.w3.org/2010/soapjms/?mtom=true", soap11);
        protocolMappings.put(SOAP12_WSDL_BINDING, soap12);
        protocolMappings.put("http://www.w3.org/2003/05/soap/bindings/HTTP/", soap12);
        protocolMappings.put("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", soap12);
        protocolMappings.put("http://www.w3.org/2004/08/wsdl/http", rest);
        HashMap<String, Protocol> updates = new HashMap<String, Protocol>();
        for (String key : protocolMappings.keySet()) {
            if (key.endsWith("/")) continue;
            updates.put(key + "/", protocolMappings.get(key));
        }
        protocolMappings.putAll(updates);
    }
}

