/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.dispatch.AbstractDispatcher;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public class HttpSessionDispatcher
extends AbstractDispatcher {
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";
    public static final String HOSTS = "hosts";

    @Override
    public SessionInformation getSession(MessageContext synCtx) {
        String hostName = this.extractHost(synCtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Extracted Host Name : " + hostName));
        }
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Endpoint Address : " + axis2MessageContext.getTo().getAddress()));
        }
        Map headerMap = this.getTransportHeaderMap(synCtx);
        String contentType = (String)headerMap.get("Content-Type");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Content Type : " + contentType));
        }
        if (hostName == null) {
            return SALSessions.getInstance().getSession(this.extractSessionID(synCtx, COOKIE));
        }
        List<String> sessionList = this.extractSessionIDs(synCtx, COOKIE);
        if (sessionList != null) {
            for (String sessionID : sessionList) {
                SessionInformation sessionInfoObj = SALSessions.getInstance().getSession(sessionID);
                if (sessionInfoObj == null || sessionInfoObj.getMember() == null) continue;
                Map subDomainNames = (Map)sessionInfoObj.getMember().getProperties().get(HOSTS);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Member Domain : " + (subDomainNames != null ? (String)subDomainNames.get(hostName) : null) + " : Session ID " + sessionID));
                }
                if (subDomainNames == null || subDomainNames.get(hostName) == null) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found a matching sessionInfo Object for the " + hostName));
                }
                return sessionInfoObj;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Did not find a session info obj.");
        }
        return null;
    }

    @Override
    public void updateSession(MessageContext synCtx) {
        String sessionId = this.extractSessionID(synCtx, SET_COOKIE);
        if (sessionId != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found the HTTP header 'Set-Cookie: " + sessionId + "' for updating the session"));
                this.log.debug((Object)("Using the session id '" + sessionId + "' extracted from the Set-Cookie header "));
            }
            SALSessions.getInstance().updateSession(synCtx, sessionId);
        }
    }

    @Override
    public void unbind(MessageContext synCtx) {
        SALSessions.getInstance().removeSession(this.extractSessionID(synCtx, COOKIE));
    }

    @Override
    public boolean isServerInitiatedSession() {
        return true;
    }

    @Override
    public void removeSessionID(MessageContext syCtx) {
        this.removeSessionID(syCtx, COOKIE);
    }

    protected List<String> extractSessionIDs(MessageContext synCtx, String key) {
        ArrayList<String> sessionList = new ArrayList<String>();
        if (key != null) {
            Map headerMap = this.getTransportHeaderMap(synCtx);
            if (headerMap != null) {
                Object cookieObj;
                Object hostObj = headerMap.get("Host");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("A request received with the Host Name : " + hostObj));
                }
                if ((cookieObj = headerMap.get(key)) instanceof String) {
                    String[] sessionIds;
                    String cookie = (String)cookieObj;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Cookies String : " + cookie));
                    }
                    if ((sessionIds = cookie.split(";")) == null || sessionIds.length == 0) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Cannot find a session id for the cookie : " + cookie));
                        }
                        return null;
                    }
                    for (String sessionId : sessionIds) {
                        if (sessionId == null || !sessionId.contains("JSESSIONID")) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Extracted SessionID : " + sessionId));
                        }
                        sessionList.add(sessionId.trim());
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Couldn't find the " + key + " header to find the session"));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Couldn't find the TRANSPORT_HEADERS to find the session");
            }
        }
        return sessionList;
    }

    private String extractHost(MessageContext synCtx) {
        Object hostObj;
        Map headerMap = this.getTransportHeaderMap(synCtx);
        String hostName = null;
        if (headerMap != null && (hostName = (String)(hostObj = headerMap.get("Host"))).contains(":")) {
            hostName = hostName.substring(0, hostName.indexOf(":"));
        }
        return hostName;
    }

    private Map getTransportHeaderMap(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }
}

