/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.sysml.debug.DMLDebuggerException;

public class DMLDebuggerInterface {
    private Options options = new Options();

    public Options getOptions() {
        return this.options;
    }

    public void setOptions() {
        this.options.addOption("h", "help", false, "list debugger functions");
        this.options.addOption("r", "run", false, "start your DML script");
        this.options.addOption("q", "quit", false, "exit debug mode");
        this.options.addOption("c", "continue", false, "continue running your DML script");
        this.options.addOption("s", "step", false, "next line, stepping into function calls");
        this.options.addOption("si", "stepi", false, "next runtime instruction rather than DML source lines (for advanced users)");
        OptionBuilder.withLongOpt((String)"break");
        OptionBuilder.withArgName((String)"line-number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"set breakpoint at given line number");
        Option setBreakpoint = OptionBuilder.create((String)"b");
        this.options.addOption(setBreakpoint);
        OptionBuilder.withLongOpt((String)"delete");
        OptionBuilder.withArgName((String)"line-number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"delete breakpoint at given line number");
        Option disableBreakpoint = OptionBuilder.create((String)"d");
        this.options.addOption(disableBreakpoint);
        OptionBuilder.withLongOpt((String)"info");
        OptionBuilder.withArgName((String)"[break | frame]");
        OptionBuilder.hasOptionalArgs((int)1);
        OptionBuilder.withDescription((String)"show all breakpoints or frames (info <break | frame>)");
        Option infoOption = OptionBuilder.create((String)"i");
        this.options.addOption(infoOption);
        OptionBuilder.withLongOpt((String)"list");
        OptionBuilder.withArgName((String)"[next numlines] | [prev numlines] | [all]");
        OptionBuilder.hasOptionalArgs((int)2);
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withDescription((String)"display DML script source lines. Default: numlines = 10");
        Option displayScript = OptionBuilder.create((String)"l");
        this.options.addOption(displayScript);
        OptionBuilder.withLongOpt((String)"listi");
        OptionBuilder.withArgName((String)"[next numlines] | [prev numlines] | [all]");
        OptionBuilder.hasOptionalArgs((int)2);
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withDescription((String)"display corresponding instructions for DML script source lines. Default: numlines = 10  (for advanced users)");
        Option displayInst = OptionBuilder.create((String)"li");
        this.options.addOption(displayInst);
        OptionBuilder.withArgName((String)"varName value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withDescription((String)"set value of a scalar or specified cell of a matrix variable. (Eg: 'set alpha 0.1' or 'set A[1,2] 20')");
        Option setVar = OptionBuilder.create((String)"set");
        this.options.addOption(setVar);
        OptionBuilder.withLongOpt((String)"print");
        OptionBuilder.withArgName((String)"varName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"display contents of a scalar or matrix variable or rows/columns/cell of matrix. (Eg: 'p alpha' or 'p A' or 'p A[1,]')");
        Option displayMatrix = OptionBuilder.create((String)"p");
        this.options.addOption(displayMatrix);
        OptionBuilder.withArgName((String)"varName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"display the type (and metadata) of a variable. (Eg: 'whatis alpha' or 'whatis A')");
        Option displayTypeMatrix = OptionBuilder.create((String)"whatis");
        this.options.addOption(displayTypeMatrix);
    }

    public void setOption(Option opt) {
        this.options.addOption(opt);
    }

    public void writeToStandardOutput(String outputStr) {
        System.out.print(outputStr);
        System.out.flush();
    }

    public void writelnToStandardOutput(String outputStr) {
        System.out.println(outputStr);
        System.out.flush();
    }

    public void writelnToStandardError(String errStr) {
        System.err.println(errStr);
        System.err.flush();
    }

    public void getDebuggerCLI() {
        String helpString = "SystemMLdb commands:\nh,help                                                 list debugger functions\nr,run                                                  start your DML script\nq,quit                                                 exit debug mode\nc,continue                                             continue running your DML script\nl,list <[next numlines] | [prev numlines] | [all]>     display DML script source lines. Default: numlines = 10\nb,break <line-number>                                  set breakpoint at given line number\nd,delete <line-number>                                 delete breakpoint at given line number\ns,step                                                 next line, stepping into function calls\ni,info <break | frame>                                 show all breakpoints or frames (info <break | frame>)\np,print <varName>                                      display contents of a scalar or matrix variable or\n                                                       rows/columns/cell of matrix. (Eg: 'p alpha' or 'p A' or 'p A[1,]')\nset <varName value>                                    set value of a scalar or specified cell of a matrix variable. (Eg:\n                                                       'set alpha 0.1' or 'set A[1,2] 20')\nwhatis <varName>                                       display the type (and metadata) of a variable. (Eg: 'whatis alpha'\n                                                       or 'whatis A')\nli,listi <[next numlines] | [prev numlines] | [all]>   display corresponding instructions for DML script source lines.\n                                                       Default: numlines = 10  (for advanced users)\nsi,stepi                                               next runtime instruction rather than DML source lines (for advanced\n                                                       users)\n";
        this.writelnToStandardOutput(helpString);
    }

    public CommandLine getDebuggerCommand() throws DMLDebuggerException {
        CommandLine cmd = null;
        String[] args = null;
        this.writeToStandardOutput("(SystemMLdb) ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = br.readLine();
            if (line != null && !line.isEmpty()) {
                args = line.split(" ");
                if (args[0].startsWith("-")) {
                    this.writelnToStandardError("Error reading command line arguments. Try \"help\".");
                    return cmd;
                }
                args[0] = "-" + args[0];
            }
        }
        catch (IOException ae) {
            this.writelnToStandardError("Error reading command line arguments. Try \"help\".");
            return cmd;
        }
        GnuParser CLIparser = new GnuParser();
        try {
            cmd = CLIparser.parse(this.getOptions(), args);
        }
        catch (ParseException pe) {
            System.err.println("Undefined command (or command arguments). Try \"help\".");
        }
        return cmd;
    }
}

