/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.utils.Explain;

public class HopDagValidator {
    private static final Log LOG = LogFactory.getLog((String)HopDagValidator.class.getName());

    private HopDagValidator() {
    }

    public static void validateHopDag(ArrayList<Hop> roots, HopRewriteRule rule) {
        if (roots == null) {
            return;
        }
        try {
            Hop.resetVisitStatus(roots);
            ValidatorState state = new ValidatorState();
            for (Hop hop : roots) {
                HopDagValidator.rValidateHop(hop, state);
            }
        }
        catch (HopsException ex) {
            try {
                LOG.error((Object)("Invalid HOP DAG after rewrite " + rule.getClass().getName() + ": \n" + Explain.explainHops(roots)), (Throwable)ex);
            }
            catch (DMLRuntimeException dMLRuntimeException) {
                // empty catch block
            }
            throw ex;
        }
    }

    public static void validateHopDag(Hop root, HopRewriteRule rule) {
        if (root == null) {
            return;
        }
        try {
            root.resetVisitStatus();
            ValidatorState state = new ValidatorState();
            HopDagValidator.rValidateHop(root, state);
        }
        catch (HopsException ex) {
            try {
                LOG.error((Object)("Invalid HOP DAG after rewrite " + rule.getClass().getName() + ": \n" + Explain.explain(root)), (Throwable)ex);
            }
            catch (DMLRuntimeException dMLRuntimeException) {
                // empty catch block
            }
            throw ex;
        }
    }

    private static void rValidateHop(Hop hop, ValidatorState state) {
        boolean seen;
        long id = hop.getHopID();
        boolean bl = seen = !state.seen.add(id);
        if (seen != hop.isVisited()) {
            String parentIDs = hop.getParent().stream().map(h -> Long.toString(h.getHopID())).collect(Collectors.joining(", "));
            HopsException.check(false, hop, parentIDs, seen);
        }
        if (seen) {
            return;
        }
        for (Hop parent : hop.getParent()) {
            HopsException.check(parent.getInput().contains(hop), hop, "not properly linked to its parent pid=%d %s", parent.getHopID(), parent.getClass().getName());
        }
        ArrayList<Hop> input = hop.getInput();
        Expression.DataType dt = hop.getDataType();
        Expression.ValueType vt = hop.getValueType();
        for (Hop child : input) {
            HopsException.check(child.getParent().contains(hop), hop, "not properly linked to its child cid=%d %s", child.getHopID(), child.getClass().getName());
        }
        if (input.isEmpty()) {
            HopsException.check(hop instanceof DataOp || hop instanceof FunctionOp || hop instanceof LiteralOp, hop, "is not a dataop/functionop/literal but has no children", new Object[0]);
        }
        hop.checkArity();
        if (dt == Expression.DataType.MATRIX) {
            HopsException.check(vt == Expression.ValueType.DOUBLE || vt == Expression.ValueType.INT, hop, "has Matrix type but Value Type %s is not DOUBLE", new Object[]{vt});
        }
        for (Hop child : input) {
            HopDagValidator.rValidateHop(child, state);
        }
        hop.setVisited();
    }

    private static class ValidatorState {
        final Set<Long> seen = new HashSet<Long>();

        private ValidatorState() {
        }
    }
}

