/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Image_utils
extends Script {
    public Image_utils() {
        String string = "scripts/utils/image_utils.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix crop_grayscale(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/utils/image_utils.dml') as mlcontextns;out = mlcontextns::crop_grayscale(input, Hin, Win, Hout, Wout);";
        Script script = new Script(string);
        script.in("input", object).in("Hin", object2).in("Win", object3).in("Hout", object4).in("Wout", object5).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String crop_grayscale__docs() {
        String string = "crop_grayscale = function(matrix[double] input, int Hin, int Win, int Hout, int Wout) return (matrix[double] out) {\n\tstart_h = ceil((Hin - Hout) / 2)\n\tend_h = start_h + Hout - 1\n\tstart_w = ceil((Win - Wout) / 2)\n\tend_w = start_w + Wout - 1\n\tmask = matrix(0, rows=Hin, cols=Win)\n\ttemp_mask = matrix(1, rows=Hout, cols=Wout)\n\tmask[start_h:end_h, start_w:end_w] = temp_mask\n\tmask = matrix(mask, rows=1, cols=Hin*Win)\n\tout = removeEmpty(target=(input+1), margin=\"cols\", select=mask) - 1\n}\n";
        return string;
    }

    public String crop_grayscale__source() {
        String string = "crop_grayscale = function(matrix[double] input, int Hin, int Win, int Hout, int Wout) return (matrix[double] out) {\n\tstart_h = ceil((Hin - Hout) / 2)\n\tend_h = start_h + Hout - 1\n\tstart_w = ceil((Win - Wout) / 2)\n\tend_w = start_w + Wout - 1\n\tmask = matrix(0, rows=Hin, cols=Win)\n\ttemp_mask = matrix(1, rows=Hout, cols=Wout)\n\tmask[start_h:end_h, start_w:end_w] = temp_mask\n\tmask = matrix(mask, rows=1, cols=Hin*Win)\n\tout = removeEmpty(target=(input+1), margin=\"cols\", select=mask) - 1\n}\n";
        return string;
    }

    public Matrix crop_rgb(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/utils/image_utils.dml') as mlcontextns;out = mlcontextns::crop_rgb(input, Hin, Win, Hout, Wout);";
        Script script = new Script(string);
        script.in("input", object).in("Hin", object2).in("Win", object3).in("Hout", object4).in("Wout", object5).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String crop_rgb__docs() {
        String string = "crop_rgb = function(matrix[double] input, int Hin, int Win, int Hout, int Wout) return (matrix[double] out) {\n\tstart_h = ceil((Hin - Hout) / 2)\n\tend_h = start_h + Hout - 1\n\tstart_w = ceil((Win - Wout) / 2)\n\tend_w = start_w + Wout - 1\n\tmask = matrix(0, rows=Hin, cols=Win)\n\ttemp_mask = matrix(1, rows=Hout, cols=Wout)\n\tmask[start_h:end_h, start_w:end_w] = temp_mask\n\tmask = matrix(mask, rows=1, cols=Hin*Win)\n\tmask = cbind(mask, mask, mask)\n\tout = removeEmpty(target=(input+1), margin=\"cols\", select=mask) - 1\n}\n";
        return string;
    }

    public String crop_rgb__source() {
        String string = "crop_rgb = function(matrix[double] input, int Hin, int Win, int Hout, int Wout) return (matrix[double] out) {\n\tstart_h = ceil((Hin - Hout) / 2)\n\tend_h = start_h + Hout - 1\n\tstart_w = ceil((Win - Wout) / 2)\n\tend_w = start_w + Wout - 1\n\tmask = matrix(0, rows=Hin, cols=Win)\n\ttemp_mask = matrix(1, rows=Hout, cols=Wout)\n\tmask[start_h:end_h, start_w:end_w] = temp_mask\n\tmask = matrix(mask, rows=1, cols=Hin*Win)\n\tmask = cbind(mask, mask, mask)\n\tout = removeEmpty(target=(input+1), margin=\"cols\", select=mask) - 1\n}\n";
        return string;
    }
}

