/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils.lite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.math3.random.Well1024a;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.ThrowableInformation;

public class BuildLite {
    public static final String DEFAULT_LITE_JAR_LOCATION = "systemml-lite.jar";
    public static final String LITE_JAR_IDENTIFIER_FILE = "META-INF/systemml-lite.txt";
    private static String liteJarLocation = "systemml-lite.jar";
    public static List<String> additionalResources = new ArrayList<String>();
    public static SortedMap<String, SortedSet<String>> additionalJarToFileMappingsForDependencySets;
    public static List<String> additionalPackages;
    public static List<String> packagesToExclude;
    private static final String BASE_SRC_DIR = "src/main";
    public static SortedMap<String, SortedSet<String>> jarsAndClasses;
    public static SortedMap<String, Long> jarSizes;
    protected static Logger log;
    private static boolean includeAllCommonsMath3;

    public static void createLiteJar() throws Exception {
        BuildLite.createLiteJar(null, true);
    }

    public static void createLiteJar(boolean allCommonsMath3) throws Exception {
        BuildLite.createLiteJar(null, allCommonsMath3);
    }

    public static void createLiteJar(String jarFileDestination, boolean allCommonsMath3) throws Exception {
        if (jarFileDestination != null) {
            liteJarLocation = jarFileDestination;
        }
        includeAllCommonsMath3 = allCommonsMath3;
        BuildLite.scanJavaFilesForClassesToLoad();
        List<Class<?>> loadedClasses = BuildLite.getLoadedClasses();
        BuildLite.displayLoadedClasses(loadedClasses);
        BuildLite.excludePackages(loadedClasses);
        BuildLite.displayLoadedClasses(loadedClasses);
        BuildLite.groupLoadedClassesByJarAndClass(loadedClasses);
        List<String> log4jClassPathNames = BuildLite.getLog4jClassPathNames();
        BuildLite.displayLog4JClassPathNames(log4jClassPathNames);
        List<String> commonsMath3ClassPathNames = null;
        if (includeAllCommonsMath3) {
            commonsMath3ClassPathNames = BuildLite.getCommonsMath3ClassPathNames();
            BuildLite.displayCommonsMath3ClassPathNames(commonsMath3ClassPathNames);
        }
        BuildLite.displayJarsAndClasses();
        Set<String> consolidatedClassPathNames = BuildLite.consolidateClassPathNames(loadedClasses, log4jClassPathNames, commonsMath3ClassPathNames);
        BuildLite.createJarFromConsolidatedClassPathNames(consolidatedClassPathNames);
        BuildLite.createDependencySets();
        BuildLite.displayJarSizes();
        BuildLite.liteJarStats();
    }

    private static void excludePackages(List<Class<?>> loadedClasses) {
        System.out.println("\nExcluding selected packages");
        int count = 0;
        for (int i = 0; i < loadedClasses.size(); ++i) {
            Class<?> clazz = loadedClasses.get(i);
            String className = clazz.getName();
            for (String packageToExclude : packagesToExclude) {
                if (!className.startsWith(packageToExclude)) continue;
                System.out.println(" #" + ++count + ": Excluding " + className);
                loadedClasses.remove(i);
                --i;
            }
        }
    }

    private static void liteJarStats() {
        File f = new File(liteJarLocation);
        if (f.exists()) {
            Long jarSize = f.length();
            String jarSizeDisplay = FileUtils.byteCountToDisplaySize((long)jarSize);
            System.out.println("\nFinished creating " + liteJarLocation + " (" + jarSizeDisplay + " [" + NumberFormat.getInstance().format(jarSize) + " bytes])");
        } else {
            System.out.println(liteJarLocation + " could not be found");
        }
    }

    private static Set<String> consolidateClassPathNames(List<Class<?>> loadedClasses, List<String> log4jClassPathNames, List<String> commonsMath3ClassPathNames) {
        TreeSet<String> allClassPathNames = new TreeSet<String>(log4jClassPathNames);
        if (includeAllCommonsMath3) {
            System.out.println("\nConsolidating loaded class names, log4j class names, and commons-math3 class names");
            allClassPathNames.addAll(commonsMath3ClassPathNames);
        } else {
            System.out.println("\nConsolidating loaded class names and log4j class names");
        }
        for (Class<?> clazz : loadedClasses) {
            String loadedClassPathName = clazz.getName();
            loadedClassPathName = loadedClassPathName.replace(".", "/");
            loadedClassPathName = loadedClassPathName + ".class";
            allClassPathNames.add(loadedClassPathName);
        }
        return allClassPathNames;
    }

    private static void createJarFromConsolidatedClassPathNames(Set<String> consolidateClassPathNames) throws IOException {
        System.out.println("\nCreating " + liteJarLocation + " file");
        ClassLoader cl = BuildLite.class.getClassLoader();
        Manifest mf = new Manifest();
        Attributes attr = mf.getMainAttributes();
        attr.putValue("" + Attributes.Name.MANIFEST_VERSION, "1.0");
        File file = new File(liteJarLocation);
        try (FileOutputStream fos = new FileOutputStream(file);
             JarOutputStream jos = new JarOutputStream((OutputStream)fos, mf);){
            int numFilesWritten = 0;
            for (String classPathName : consolidateClassPathNames) {
                BuildLite.writeMessage(classPathName, ++numFilesWritten);
                InputStream is = cl.getResourceAsStream(classPathName);
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                JarEntry je = new JarEntry(classPathName);
                jos.putNextEntry(je);
                jos.write(bytes);
            }
            BuildLite.writeIdentifierFileToLiteJar(jos, ++numFilesWritten);
            BuildLite.writeAdditionalResourcesToJar(jos, numFilesWritten);
        }
    }

    private static void writeIdentifierFileToLiteJar(JarOutputStream jos, int numFilesWritten) throws IOException {
        BuildLite.writeMessage(LITE_JAR_IDENTIFIER_FILE, numFilesWritten);
        JarEntry je = new JarEntry(LITE_JAR_IDENTIFIER_FILE);
        jos.putNextEntry(je);
        String created = "Created " + new Date();
        String userName = System.getProperty("user.name");
        if (userName != null) {
            created = created + " by " + userName;
        }
        jos.write(created.getBytes());
    }

    private static void writeAdditionalResourcesToJar(JarOutputStream jos, int numFilesWritten) throws IOException {
        for (String resource : additionalResources) {
            BuildLite.writeMessage(resource, ++numFilesWritten);
            JarEntry je = new JarEntry(resource);
            jos.putNextEntry(je);
            ClassLoader cl = BuildLite.class.getClassLoader();
            InputStream is = cl.getResourceAsStream(resource);
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            jos.write(bytes);
        }
    }

    private static void writeMessage(String resource, int numFilesWritten) {
        System.out.println(" #" + numFilesWritten + ": Writing " + resource + " to " + liteJarLocation);
    }

    private static List<String> getLog4jClassPathNames() throws IOException, ClassNotFoundException {
        return BuildLite.getAllClassesInJar(ThrowableInformation.class);
    }

    private static List<String> getCommonsMath3ClassPathNames() throws IOException, ClassNotFoundException {
        return BuildLite.getAllClassesInJar(Well1024a.class);
    }

    private static List<String> getAllClassesInJar(Class<?> classInJarFile) throws IOException, ClassNotFoundException {
        ArrayList<String> classPathNames = new ArrayList<String>();
        String jarLocation = classInJarFile.getProtectionDomain().getCodeSource().getLocation().getPath();
        File f = new File(jarLocation);
        try (FileInputStream fis = new FileInputStream(f);
             JarArchiveInputStream jais = new JarArchiveInputStream((InputStream)fis);){
            JarArchiveEntry jae;
            while ((jae = jais.getNextJarEntry()) != null) {
                String name = jae.getName();
                if (!name.endsWith(".class")) continue;
                classPathNames.add(name);
            }
        }
        String jarName = jarLocation.substring(jarLocation.lastIndexOf("/") + 1);
        BuildLite.addClassPathNamesToJarsAndClasses(jarName, classPathNames);
        return classPathNames;
    }

    private static void addClassPathNamesToJarsAndClasses(String jar, List<String> classPathNames) {
        for (String classPathName : classPathNames) {
            String className = classPathName.substring(0, classPathName.length() - 6);
            className = className.replace("/", ".");
            BuildLite.addJarAndClass(jar, className);
        }
    }

    private static void displayLog4JClassPathNames(List<String> log4jClassPathNames) {
        int numClasses = 0;
        System.out.println("\nAll log4j class files:");
        for (String classPathName : log4jClassPathNames) {
            System.out.println(" #" + ++numClasses + ": " + classPathName);
        }
    }

    private static void displayCommonsMath3ClassPathNames(List<String> commonsMath3ClassPathNames) {
        int numClasses = 0;
        System.out.println("\nAll commons-math3 class files:");
        for (String classPathName : commonsMath3ClassPathNames) {
            System.out.println(" #" + ++numClasses + ": " + classPathName);
        }
    }

    private static List<Class<?>> getLoadedClasses() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> clClazz;
        ClassLoader cl = BuildLite.class.getClassLoader();
        for (clClazz = cl.getClass(); clClazz != ClassLoader.class; clClazz = clClazz.getSuperclass()) {
        }
        Field f = clClazz.getDeclaredField("classes");
        f.setAccessible(true);
        Vector classes = (Vector)f.get(cl);
        ArrayList list = new ArrayList(classes);
        return list;
    }

    private static void groupLoadedClassesByJarAndClass(List<Class<?>> loadedClasses) {
        for (Class<?> clazz : loadedClasses) {
            String pathToClass = BuildLite.getPathToClass(clazz);
            if (pathToClass == null) {
                BuildLite.addJarAndClass("?", clazz.getName());
                continue;
            }
            if (pathToClass.endsWith(".jar")) {
                String jarName = pathToClass.substring(pathToClass.lastIndexOf("/") + 1);
                BuildLite.addJarAndClass(jarName, clazz.getName());
                if (jarSizes.containsKey(jarName)) continue;
                String jarPath = pathToClass;
                File jarFile = new File(jarPath);
                long fileLength = jarFile.length();
                jarSizes.put(jarName, fileLength);
                continue;
            }
            if (pathToClass.contains("systemml")) {
                BuildLite.addJarAndClass("SystemML", clazz.getName());
                continue;
            }
            BuildLite.addJarAndClass("Other", clazz.getName());
        }
    }

    private static void addJarAndClass(String jarName, String className) {
        if (jarsAndClasses.containsKey(jarName)) {
            SortedSet classNames = (SortedSet)jarsAndClasses.get(jarName);
            classNames.add(className);
        } else {
            TreeSet<String> classNames = new TreeSet<String>();
            classNames.add(className);
            jarsAndClasses.put(jarName, classNames);
        }
    }

    private static void displayLoadedClasses(List<Class<?>> loadedClasses) {
        int numClasses = 0;
        System.out.println("\nLoaded classes:");
        for (Class<?> clazz : loadedClasses) {
            System.out.println(" #" + ++numClasses + ": " + clazz + " (" + BuildLite.getPathToClass(clazz) + ")");
        }
    }

    private static String getPathToClass(Class<?> clazz) {
        try {
            return clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private static void displayJarsAndClasses() throws IOException {
        ClassLoader cl = BuildLite.class.getClassLoader();
        System.out.println("\nRequired Classes Grouped by Jar:");
        Set<String> jarNames = jarsAndClasses.keySet();
        int numClasses = 0;
        for (String jarName : jarNames) {
            SortedSet classNames = (SortedSet)jarsAndClasses.get(jarName);
            StringBuilder sb = new StringBuilder();
            int totalBytesUncompressed = 0;
            for (String className : classNames) {
                String classNamePath = className.replace(".", "/") + ".class";
                InputStream is = cl.getResourceAsStream(classNamePath);
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                int numBytes = bytes.length;
                sb.append(" #" + ++numClasses + " " + className + " [" + NumberFormat.getInstance().format(numBytes) + " bytes])\n");
                totalBytesUncompressed += numBytes;
            }
            System.out.println("Jar: " + jarName + " [" + NumberFormat.getInstance().format(totalBytesUncompressed) + " bytes uncompressed]");
            System.out.println(sb.toString());
        }
    }

    private static void scanJavaFilesForClassesToLoad() throws IOException, ClassNotFoundException {
        System.out.println("\nScanning java files for additional classes to load");
        int totalMatches = 0;
        TreeSet<String> uniqueMatches = new TreeSet<String>();
        File base = new File(BASE_SRC_DIR);
        List javaFiles = (List)FileUtils.listFiles((File)base, (String[])new String[]{"java"}, (boolean)true);
        for (File javaFile : javaFiles) {
            String content = FileUtils.readFileToString((File)javaFile);
            for (String additionalPackage : additionalPackages) {
                String s = "import " + additionalPackage + "(.*?);";
                Pattern p = Pattern.compile(s);
                Matcher m = p.matcher(content);
                while (m.find()) {
                    ++totalMatches;
                    String match = m.group(1);
                    String matchClass = additionalPackage + match;
                    uniqueMatches.add(matchClass);
                }
            }
        }
        System.out.println("Total matches found from scan: " + totalMatches);
        int uniqueMatchesSize = uniqueMatches.size();
        System.out.println("Unique matches found from scan: " + uniqueMatchesSize);
        int numMatches = 0;
        for (String matchClass : uniqueMatches) {
            Class<?> clazz = Class.forName(matchClass);
            String pathToClass = BuildLite.getPathToClass(clazz);
            System.out.println(" #" + ++numMatches + ": Loaded " + clazz.getName() + " from " + pathToClass);
        }
    }

    private static void displayJarSizes() {
        System.out.println("\nIndividual Jar Dependencies (for Comparison):");
        Set<String> jarNames = jarSizes.keySet();
        for (String jarName : jarNames) {
            System.out.println(jarName);
        }
        System.out.println();
        Long totalSize = 0L;
        int count = 0;
        for (String jarName : jarNames) {
            Long jarSize = (Long)jarSizes.get(jarName);
            String jarSizeDisplay = FileUtils.byteCountToDisplaySize((long)jarSize);
            System.out.println(" #" + ++count + ": " + jarName + " (" + jarSizeDisplay + " [" + NumberFormat.getInstance().format(jarSize) + " bytes])");
            totalSize = totalSize + jarSize;
        }
        String totalSizeDisplay = FileUtils.byteCountToDisplaySize((long)totalSize);
        System.out.println("Total Size of Jar Dependencies: " + totalSizeDisplay + " [" + NumberFormat.getInstance().format(totalSize) + " bytes]");
    }

    private static void createDependencySets() throws IOException {
        String s;
        System.out.println("\nCreating maven dependency sets");
        StringBuilder sb = new StringBuilder();
        sb.append("\t<dependencySets>\n");
        Set<String> jarNames = jarsAndClasses.keySet();
        for (String jarName : jarNames) {
            s = BuildLite.generateDependencySet(jarName, (SortedSet)jarsAndClasses.get(jarName));
            sb.append(s);
        }
        sb.append(BuildLite.generateSystemMLDependencySet());
        sb.append("\t</dependencySets>\n");
        System.out.println(sb.toString());
        String liteXml = "src/assembly/lite.xml";
        File f = new File("src/assembly/lite.xml");
        if (f.exists()) {
            System.out.println("Found 'src/assembly/lite.xml', so updating dependencySets in the file.");
            s = FileUtils.readFileToString((File)f);
            int start = s.indexOf("\t<dependencySets>");
            int end = s.indexOf("</dependencySets>") + "</dependencySets>".length() + 1;
            String before = s.substring(0, start);
            String after = s.substring(end);
            String newS = before + sb.toString() + after;
            FileUtils.writeStringToFile((File)f, (String)newS);
        }
    }

    private static String generateDependencySet(String jarName, SortedSet<String> classNames) {
        StringBuilder sb = new StringBuilder();
        String jarNameNoVersion = null;
        if ("SystemML".equalsIgnoreCase(jarName)) {
            jarNameNoVersion = "systemml";
            return "";
        }
        jarNameNoVersion = jarName.substring(0, jarName.lastIndexOf("-"));
        sb.append("\t\t<dependencySet>\n");
        sb.append("\t\t\t<includes>\n");
        sb.append("\t\t\t\t<include>*:" + jarNameNoVersion + "</include>\n");
        sb.append("\t\t\t</includes>\n");
        sb.append("\t\t\t<unpackOptions>\n");
        sb.append("\t\t\t\t<includes>\n");
        Set<String> jarsWithAdditionalFileMappings = additionalJarToFileMappingsForDependencySets.keySet();
        if (jarsWithAdditionalFileMappings.contains(jarNameNoVersion)) {
            SortedSet additionalResourceFiles = (SortedSet)additionalJarToFileMappingsForDependencySets.get(jarNameNoVersion);
            for (String resourceFile : additionalResourceFiles) {
                sb.append("\t\t\t\t\t<include>" + resourceFile + "</include>\n");
            }
        }
        if (jarName.startsWith("log4j")) {
            sb.append("\t\t\t\t\t<include>**/*.class</include>\n");
        } else if (includeAllCommonsMath3 && jarName.startsWith("commons-math3")) {
            sb.append("\t\t\t\t\t<include>**/*.class</include>\n");
        } else {
            for (String className : classNames) {
                String classFileName = className.replace(".", "/") + ".class";
                sb.append("\t\t\t\t\t<include>" + classFileName + "</include>\n");
            }
        }
        sb.append("\t\t\t\t</includes>\n");
        sb.append("\t\t\t</unpackOptions>\n");
        sb.append("\t\t\t<scope>compile</scope>\n");
        sb.append("\t\t\t<unpack>true</unpack>\n");
        sb.append("\t\t</dependencySet>\n");
        sb.append("\n");
        return sb.toString();
    }

    private static String generateSystemMLDependencySet() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t<dependencySet>\n");
        sb.append("\t\t\t<includes>\n");
        sb.append("\t\t\t\t<include>*:systemml*</include>\n");
        sb.append("\t\t\t</includes>\n");
        sb.append("\t\t\t<unpackOptions>\n");
        sb.append("\t\t\t\t<excludes>\n");
        sb.append("\t\t\t\t\t<exclude>META-INF/DEPENDENCIES</exclude>\n");
        sb.append("\t\t\t\t\t<exclude>META-INF/maven/**</exclude>\n");
        sb.append("\t\t\t\t\t<exclude>kernels/**</exclude>\n");
        sb.append("\t\t\t\t\t<exclude>lib/**</exclude>\n");
        sb.append("\t\t\t\t</excludes>\n");
        sb.append("\t\t\t</unpackOptions>\n");
        sb.append("\t\t\t<outputDirectory>.</outputDirectory>\n");
        sb.append("\t\t\t<scope>compile</scope>\n");
        sb.append("\t\t\t<unpack>true</unpack>\n");
        sb.append("\t\t</dependencySet>\n");
        return sb.toString();
    }

    static {
        additionalResources.add("META-INF/services/org.apache.hadoop.fs.FileSystem");
        additionalResources.add("org/apache/hadoop/util/ShutdownHookManager$2.class");
        additionalResources.add("org/apache/hadoop/log/metrics/EventCounter.class");
        additionalResources.add("org/apache/hadoop/util/GenericOptionsParser.class");
        additionalResources.add("org/apache/hadoop/security/token/Token.class");
        additionalResources.add("org/apache/hadoop/security/token/TokenIdentifier.class");
        additionalResources.add("org/apache/hadoop/security/Groups$CachedGroups.class");
        additionalResources.add("org/apache/commons/cli/OptionValidator.class");
        additionalResources.add("org/apache/commons/cli/Util.class");
        additionalResources.add("common-version-info.properties");
        additionalJarToFileMappingsForDependencySets = new TreeMap<String, SortedSet<String>>();
        TreeSet<String> hadoopCommonResources = new TreeSet<String>();
        hadoopCommonResources.add("META-INF/services/org.apache.hadoop.fs.FileSystem");
        hadoopCommonResources.add("org/apache/hadoop/util/ShutdownHookManager$2.class");
        hadoopCommonResources.add("org/apache/hadoop/log/metrics/EventCounter.class");
        hadoopCommonResources.add("org/apache/hadoop/util/GenericOptionsParser.class");
        hadoopCommonResources.add("org/apache/hadoop/security/token/Token.class");
        hadoopCommonResources.add("org/apache/hadoop/security/token/TokenIdentifier.class");
        hadoopCommonResources.add("org/apache/hadoop/security/Groups$CachedGroups.class");
        hadoopCommonResources.add("common-version-info.properties");
        additionalJarToFileMappingsForDependencySets.put("hadoop-common", hadoopCommonResources);
        TreeSet<String> commonsCliResources = new TreeSet<String>();
        commonsCliResources.add("org/apache/commons/cli/OptionValidator.class");
        commonsCliResources.add("org/apache/commons/cli/Util.class");
        additionalJarToFileMappingsForDependencySets.put("commons-cli", commonsCliResources);
        additionalPackages = new ArrayList<String>();
        additionalPackages.add("org.apache.commons");
        packagesToExclude = new ArrayList<String>();
        packagesToExclude.add("com.sun.proxy");
        packagesToExclude.add("org.junit");
        packagesToExclude.add("org.apache.spark");
        packagesToExclude.add("org.apache.sysml.test");
        packagesToExclude.add("scala");
        jarsAndClasses = new TreeMap<String, SortedSet<String>>();
        jarSizes = new TreeMap<String, Long>();
        log = Logger.getLogger(BuildLite.class);
        includeAllCommonsMath3 = true;
    }
}

