/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerAppStartedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;

public class NonAggregatingLogHandler
extends AbstractService
implements LogHandler {
    private static final Log LOG = LogFactory.getLog(NonAggregatingLogHandler.class);
    private final Dispatcher dispatcher;
    private final DeletionService delService;
    private final Map<ApplicationId, String> appOwners;
    private final LocalDirsHandlerService dirsHandler;
    private long deleteDelaySeconds;
    private ScheduledThreadPoolExecutor sched;

    public NonAggregatingLogHandler(Dispatcher dispatcher, DeletionService delService, LocalDirsHandlerService dirsHandler) {
        super(NonAggregatingLogHandler.class.getName());
        this.dispatcher = dispatcher;
        this.delService = delService;
        this.dirsHandler = dirsHandler;
        this.appOwners = new ConcurrentHashMap<ApplicationId, String>();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.deleteDelaySeconds = conf.getLong("yarn.nodemanager.log.retain-seconds", 10800L);
        this.sched = this.createScheduledThreadPoolExecutor(conf);
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.sched != null) {
            this.sched.shutdown();
            boolean isShutdown = false;
            try {
                isShutdown = this.sched.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.sched.shutdownNow();
                isShutdown = true;
            }
            if (!isShutdown) {
                this.sched.shutdownNow();
            }
        }
        super.serviceStop();
    }

    FileContext getLocalFileContext(Configuration conf) {
        try {
            return FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access local fs");
        }
    }

    @Override
    public void handle(LogHandlerEvent event) {
        switch ((LogHandlerEventType)event.getType()) {
            case APPLICATION_STARTED: {
                LogHandlerAppStartedEvent appStartedEvent = (LogHandlerAppStartedEvent)event;
                this.appOwners.put(appStartedEvent.getApplicationId(), appStartedEvent.getUser());
                this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(appStartedEvent.getApplicationId(), ApplicationEventType.APPLICATION_LOG_HANDLING_INITED));
                break;
            }
            case CONTAINER_FINISHED: {
                break;
            }
            case APPLICATION_FINISHED: {
                LogHandlerAppFinishedEvent appFinishedEvent = (LogHandlerAppFinishedEvent)event;
                LOG.info((Object)("Scheduling Log Deletion for application: " + appFinishedEvent.getApplicationId() + ", with delay of " + this.deleteDelaySeconds + " seconds"));
                LogDeleterRunnable logDeleter = new LogDeleterRunnable(this.appOwners.remove(appFinishedEvent.getApplicationId()), appFinishedEvent.getApplicationId());
                try {
                    this.sched.schedule(logDeleter, this.deleteDelaySeconds, TimeUnit.SECONDS);
                }
                catch (RejectedExecutionException e) {
                    logDeleter.run();
                }
                break;
            }
        }
    }

    ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor(Configuration conf) {
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("LogDeleter #%d").build();
        this.sched = new ScheduledThreadPoolExecutor(conf.getInt("yarn.nodemanager.log.deletion-threads-count", 4), tf);
        return this.sched;
    }

    class LogDeleterRunnable
    implements Runnable {
        private String user;
        private ApplicationId applicationId;

        public LogDeleterRunnable(String user, ApplicationId applicationId) {
            this.user = user;
            this.applicationId = applicationId;
        }

        @Override
        public void run() {
            ArrayList<Path> localAppLogDirs = new ArrayList<Path>();
            FileContext lfs = NonAggregatingLogHandler.this.getLocalFileContext(NonAggregatingLogHandler.this.getConfig());
            for (String rootLogDir : NonAggregatingLogHandler.this.dirsHandler.getLogDirsForCleanup()) {
                Path logDir = new Path(rootLogDir, this.applicationId.toString());
                try {
                    lfs.getFileStatus(logDir);
                    localAppLogDirs.add(logDir);
                }
                catch (UnsupportedFileSystemException ue) {
                    LOG.warn((Object)("Unsupported file system used for log dir " + logDir), (Throwable)ue);
                }
                catch (IOException ie) {}
            }
            NonAggregatingLogHandler.this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(this.applicationId, ApplicationEventType.APPLICATION_LOG_HANDLING_FINISHED));
            if (localAppLogDirs.size() > 0) {
                NonAggregatingLogHandler.this.delService.delete(this.user, null, localAppLogDirs.toArray(new Path[localAppLogDirs.size()]));
            }
        }

        public String toString() {
            return "LogDeleter for AppId " + this.applicationId.toString() + ", owned by " + this.user;
        }
    }
}

