/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class ProcessIdFileReader {
    private static final Log LOG = LogFactory.getLog(ProcessIdFileReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessId(Path path) throws IOException {
        String processId;
        block13: {
            if (path == null) {
                throw new IOException("Trying to access process id from a null path");
            }
            LOG.debug((Object)("Accessing pid from pid file " + path));
            processId = null;
            InputStreamReader fileReader = null;
            BufferedReader bufReader = null;
            try {
                String line;
                File file = new File(path.toString());
                if (!file.exists()) break block13;
                fileReader = new FileReader(file);
                bufReader = new BufferedReader(fileReader);
                while ((line = bufReader.readLine()) != null) {
                    String temp = line.trim();
                    if (temp.isEmpty()) continue;
                    if (Shell.WINDOWS) {
                        try {
                            ConverterUtils.toContainerId((String)temp);
                            processId = temp;
                            break;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    try {
                        Long pid = Long.valueOf(temp);
                        if (pid <= 0L) continue;
                        processId = temp;
                    }
                    catch (Exception e) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (bufReader != null) {
                    bufReader.close();
                }
            }
        }
        LOG.debug((Object)("Got pid " + (processId != null ? processId : "null") + " from path " + path));
        return processId;
    }
}

