/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class AppendM
extends Lop {
    public static final String OPCODE = "mappend";
    private boolean _cbind = true;
    private CacheType _cacheType = null;

    public AppendM(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, boolean cbind, boolean partitioned, LopProperties.ExecType et) {
        super(Lop.Type.Append, dt, vt);
        this.init(input1, input2, input3, dt, vt, et);
        this._cbind = cbind;
        this._cacheType = partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT;
    }

    public void init(Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        this.addInput(input3);
        input3.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = AppendM";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(input_index3), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append("\u00b0");
            sb.append((Object)this._cacheType);
        }
        sb.append("\u00b0");
        sb.append(this._cbind);
        return sb.toString();
    }

    @Override
    public boolean usesDistributedCache() {
        return true;
    }

    @Override
    public int[] distributedCacheInputIndex() {
        return new int[]{2};
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART;

    }
}

