/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;

public class AssignmentStatement
extends Statement {
    private ArrayList<DataIdentifier> _targetList = new ArrayList();
    private Expression _source;
    private boolean _isAccum;

    @Override
    public Statement rewriteStatement(String prefix) {
        DataIdentifier newTarget = (DataIdentifier)this._targetList.get(0).rewriteExpression(prefix);
        Expression newSource = this._source.rewriteExpression(prefix);
        AssignmentStatement retVal = new AssignmentStatement(newTarget, newSource, this);
        return retVal;
    }

    public AssignmentStatement(DataIdentifier di, Expression exp) {
        this._targetList.add(di);
        this._source = exp;
    }

    public AssignmentStatement(DataIdentifier di, Expression exp, ParseInfo parseInfo) {
        this(di, exp);
        this.setParseInfo(parseInfo);
    }

    public AssignmentStatement(ParserRuleContext ctx, DataIdentifier di, Expression exp) {
        this(di, exp);
        this.setCtxValues(ctx);
    }

    public AssignmentStatement(ParserRuleContext ctx, DataIdentifier di, Expression exp, String filename) {
        this(ctx, di, exp);
        this.setFilename(filename);
    }

    public DataIdentifier getTarget() {
        return this._targetList.get(0);
    }

    public ArrayList<DataIdentifier> getTargetList() {
        return this._targetList;
    }

    public void setTarget(DataIdentifier di) {
        this._targetList.set(0, di);
    }

    public Expression getSource() {
        return this._source;
    }

    public void setSource(Expression s) {
        this._source = s;
    }

    public boolean isAccumulator() {
        return this._isAccum;
    }

    public void setAccumulator(boolean flag) {
        this._isAccum = flag;
    }

    @Override
    public boolean controlStatement() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            DMLBreakpointManager.insertBreakpoint(this._source.getBeginLine());
            return true;
        }
        return this._source instanceof FunctionCallIdentifier;
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._source.variablesRead());
        for (DataIdentifier target : this._targetList) {
            if (!(target instanceof IndexedIdentifier) && !this._isAccum) continue;
            result.addVariables(target.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (DataIdentifier target : this._targetList) {
            if (target == null) continue;
            result.addVariable(target.getName(), target);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._targetList.size(); ++i) {
            DataIdentifier di = this._targetList.get(i);
            sb.append(di);
        }
        sb.append(this._isAccum ? " += " : " = ");
        if (this._source instanceof StringIdentifier) {
            sb.append("\"");
            sb.append(this._source.toString());
            sb.append("\"");
        } else {
            sb.append(this._source.toString());
        }
        sb.append(";");
        return sb.toString();
    }
}

