/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.DnnOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.MultiThreadedHop;
import org.apache.sysml.hops.NaryOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.codegen.SpoofCompiler;
import org.apache.sysml.hops.ipa.InterProceduralAnalysis;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriter;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.Dag;
import org.apache.sysml.parser.AssignmentStatement;
import org.apache.sysml.parser.BinaryExpression;
import org.apache.sysml.parser.BooleanExpression;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.BuiltinFunctionExpression;
import org.apache.sysml.parser.ConditionalPredicate;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.IterablePredicate;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.OutputStatement;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.ParameterizedBuiltinFunctionExpression;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.PrintStatement;
import org.apache.sysml.parser.RelationalExpression;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlockCP;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.instructions.Instruction;

public class DMLTranslator {
    private static final Log LOG = LogFactory.getLog((String)DMLTranslator.class.getName());
    private DMLProgram _dmlProg = null;

    public DMLTranslator(DMLProgram dmlp) {
        this._dmlProg = dmlp;
        OptimizerUtils.resetDefaultSize();
        Recompiler.reinitRecompiler();
    }

    public void validateParseTree(DMLProgram dmlp) {
        this.validateParseTree(dmlp, true);
    }

    public void validateParseTree(DMLProgram dmlp, boolean inclFuns) {
        StatementBlock sb;
        int i;
        boolean fWriteRead = this.prepareReadAfterWrite(dmlp, new HashMap<String, DataIdentifier>());
        if (inclFuns) {
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock fblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    HashMap<String, ConstIdentifier> constVars = new HashMap<String, ConstIdentifier>();
                    VariableSet vs = new VariableSet();
                    FunctionStatement fstmt = (FunctionStatement)fblock.getStatement(0);
                    for (DataIdentifier currVar : fstmt.getInputParams()) {
                        if (currVar.getDataType() == Expression.DataType.SCALAR) {
                            currVar.setDimensions(0L, 0L);
                        }
                        vs.addVariable(currVar.getName(), currVar);
                    }
                    fblock.validate(dmlp, vs, constVars, false);
                }
            }
        }
        VariableSet vs = new VariableSet();
        HashMap<String, ConstIdentifier> constVars = new HashMap<String, ConstIdentifier>();
        for (i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            sb = dmlp.getStatementBlock(i);
            vs = sb.validate(dmlp, vs, constVars, fWriteRead);
            constVars = sb.getConstOut();
        }
        if (fWriteRead) {
            this.prepareReadAfterWrite(dmlp, new HashMap<String, DataIdentifier>());
            vs = new VariableSet();
            constVars = new HashMap();
            for (i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
                sb = dmlp.getStatementBlock(i);
                vs = sb.validate(dmlp, vs, constVars, fWriteRead);
                constVars = sb.getConstOut();
            }
        }
    }

    public void liveVariableAnalysis(DMLProgram dmlp) {
        this.liveVariableAnalysis(dmlp, true);
    }

    public void liveVariableAnalysis(DMLProgram dmlp, boolean inclFuns) {
        if (inclFuns) {
            FunctionStatementBlock fsb;
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    fsb = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                    fstmt.setBody(StatementBlock.mergeFunctionCalls(fstmt.getBody(), dmlp));
                    VariableSet activeIn = new VariableSet();
                    for (DataIdentifier id : fstmt.getInputParams()) {
                        activeIn.addVariable(id.getName(), id);
                    }
                    fsb.initializeforwardLV(activeIn);
                }
            }
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    fsb = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    VariableSet currentLiveOut = new VariableSet();
                    VariableSet currentLiveIn = new VariableSet();
                    FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                    for (DataIdentifier id : fstmt.getInputParams()) {
                        currentLiveIn.addVariable(id.getName(), id);
                    }
                    for (DataIdentifier id : fstmt.getOutputParams()) {
                        currentLiveOut.addVariable(id.getName(), id);
                    }
                    fsb._liveOut = currentLiveOut;
                    fsb.analyze(currentLiveIn, currentLiveOut);
                }
            }
        }
        VariableSet currentLiveOut = new VariableSet();
        VariableSet activeIn = new VariableSet();
        dmlp.setStatementBlocks(StatementBlock.mergeFunctionCalls(dmlp.getStatementBlocks(), dmlp));
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock sb = dmlp.getStatementBlock(i);
            activeIn = sb.initializeforwardLV(activeIn);
        }
        if (dmlp.getNumStatementBlocks() > 0) {
            StatementBlock lastSb = dmlp.getStatementBlock(dmlp.getNumStatementBlocks() - 1);
            lastSb._liveOut = new VariableSet();
            for (int i = dmlp.getNumStatementBlocks() - 1; i >= 0; --i) {
                StatementBlock sb = dmlp.getStatementBlock(i);
                currentLiveOut = sb.analyze(currentLiveOut);
            }
        }
    }

    public void constructHops(DMLProgram dmlp) {
        this.constructHops(dmlp, true);
    }

    public void constructHops(DMLProgram dmlp, boolean inclFuns) {
        if (inclFuns) {
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock current = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    this.constructHops(current);
                }
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            this.constructHops(current);
        }
    }

    public void rewriteHopsDAG(DMLProgram dmlp) {
        ProgramRewriter rewriter = new ProgramRewriter(true, false);
        rewriter.rewriteProgramHopDAGs(dmlp, false);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        rewriter.rewriteProgramHopDAGs(dmlp, true);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        if (OptimizerUtils.ALLOW_INTER_PROCEDURAL_ANALYSIS) {
            InterProceduralAnalysis ipa = new InterProceduralAnalysis(dmlp);
            ipa.analyzeProgram(OptimizerUtils.IPA_NUM_REPETITIONS);
            DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        }
        ProgramRewriter rewriter2 = new ProgramRewriter(false, true);
        rewriter2.rewriteProgramHopDAGs(dmlp);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        this.refreshMemEstimates(dmlp);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        DMLConfig dmlconf = ConfigurationManager.getDMLConfig();
        if (ConfigurationManager.isCodegenEnabled()) {
            SpoofCompiler.PLAN_CACHE_POLICY = SpoofCompiler.PlanCachePolicy.get(dmlconf.getBooleanValue("sysml.codegen.plancache"), dmlconf.getIntValue("sysml.codegen.literals") == 2);
            SpoofCompiler.setConfiguredPlanSelector();
            SpoofCompiler.setExecTypeSpecificJavaCompiler();
            if (SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.HOPS) {
                this.codgenHopsDAG(dmlp);
            }
        }
    }

    public void codgenHopsDAG(DMLProgram dmlp) {
        SpoofCompiler.generateCode(dmlp);
    }

    public void codgenHopsDAG(Program rtprog) {
        SpoofCompiler.generateCode(rtprog);
    }

    public void codgenHopsDAG(ProgramBlock pb) {
        SpoofCompiler.generateCodeFromProgramBlock(pb);
    }

    public void constructLops(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (FunctionStatementBlock fsb : dmlp.getFunctionStatementBlocks(namespaceKey).values()) {
                this.constructLops(fsb);
            }
        }
        for (StatementBlock sb : dmlp.getStatementBlocks()) {
            this.constructLops(sb);
        }
    }

    public boolean constructLops(StatementBlock sb) {
        boolean ret = false;
        if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement whileStmt = (WhileStatement)wsb.getStatement(0);
            ArrayList<StatementBlock> body = whileStmt.getBody();
            for (StatementBlock stmtBlock : body) {
                ret |= this.constructLops(stmtBlock);
            }
            Lop l = wsb.getPredicateHops().constructLops();
            wsb.setPredicateLops(l);
            ret |= wsb.updatePredicateRecompilationFlag();
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement ifStmt = (IfStatement)isb.getStatement(0);
            ArrayList<StatementBlock> ifBody = ifStmt.getIfBody();
            ArrayList<StatementBlock> elseBody = ifStmt.getElseBody();
            for (StatementBlock stmtBlock : ifBody) {
                ret |= this.constructLops(stmtBlock);
            }
            for (StatementBlock stmtBlock : elseBody) {
                ret |= this.constructLops(stmtBlock);
            }
            Lop l = isb.getPredicateHops().constructLops();
            isb.setPredicateLops(l);
            ret |= isb.updatePredicateRecompilationFlag();
        } else if (sb instanceof ForStatementBlock) {
            Lop llobs;
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fs = (ForStatement)sb.getStatement(0);
            ArrayList<StatementBlock> body = fs.getBody();
            for (StatementBlock stmtBlock : body) {
                ret |= this.constructLops(stmtBlock);
            }
            if (fsb.getFromHops() != null) {
                llobs = fsb.getFromHops().constructLops();
                fsb.setFromLops(llobs);
            }
            if (fsb.getToHops() != null) {
                llobs = fsb.getToHops().constructLops();
                fsb.setToLops(llobs);
            }
            if (fsb.getIncrementHops() != null) {
                llobs = fsb.getIncrementHops().constructLops();
                fsb.setIncrementLops(llobs);
            }
            ret |= fsb.updatePredicateRecompilationFlags();
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement functStmt = (FunctionStatement)sb.getStatement(0);
            ArrayList<StatementBlock> body = functStmt.getBody();
            for (StatementBlock stmtBlock : body) {
                ret |= this.constructLops(stmtBlock);
            }
            if (fsb.isRecompileOnce()) {
                fsb.setRecompileOnce(ret);
            }
        } else {
            if (sb.getHops() == null) {
                sb.setHops(new ArrayList<Hop>());
            }
            ArrayList<Lop> lops = new ArrayList<Lop>();
            for (Hop hop : sb.getHops()) {
                lops.add(hop.constructLops());
            }
            sb.setLops(lops);
            ret |= sb.updateRecompilationFlag();
        }
        return ret;
    }

    public Program getRuntimeProgram(DMLProgram prog, DMLConfig config) throws IOException, LanguageException, DMLRuntimeException, LopsException, HopsException {
        Program rtprog = new Program();
        for (String namespace : prog.getNamespaces().keySet()) {
            for (String fname : prog.getFunctionStatementBlocks(namespace).keySet()) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlocks(namespace).get(fname);
                FunctionProgramBlock rtpb = (FunctionProgramBlock)this.createRuntimeProgramBlock(rtprog, fsb, config);
                rtprog.addFunctionProgramBlock(namespace, fname, rtpb);
                rtpb.setRecompileOnce(fsb.isRecompileOnce());
            }
        }
        for (StatementBlock sb : prog.getStatementBlocks()) {
            ProgramBlock rtpb = this.createRuntimeProgramBlock(rtprog, sb, config);
            rtprog.addProgramBlock(rtpb);
        }
        if (ConfigurationManager.isCodegenEnabled() && SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.RUNTIME) {
            this.codgenHopsDAG(rtprog);
        }
        return rtprog;
    }

    public ProgramBlock createRuntimeProgramBlock(Program prog, StatementBlock sb, DMLConfig config) {
        Dag<Lop> dag = null;
        Dag<Lop> pred_dag = null;
        ArrayList<Instruction> pred_instruct = null;
        Object retPB = null;
        if (sb instanceof WhileStatementBlock) {
            pred_dag = new Dag<Lop>();
            ((WhileStatementBlock)sb).getPredicateLops().addToDag(pred_dag);
            pred_instruct = new ArrayList<Instruction>();
            ArrayList<Instruction> pInst = pred_dag.getJobs(null, config);
            for (Instruction i : pInst) {
                pred_instruct.add(i);
            }
            WhileProgramBlock rtpb = new WhileProgramBlock(prog, pred_instruct);
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            for (StatementBlock sblock : wstmt.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else if (sb instanceof IfStatementBlock) {
            ProgramBlock childBlock;
            pred_dag = new Dag();
            ((IfStatementBlock)sb).getPredicateLops().addToDag(pred_dag);
            pred_instruct = new ArrayList();
            ArrayList<Instruction> pInst = pred_dag.getJobs(null, config);
            for (Instruction i : pInst) {
                pred_instruct.add(i);
            }
            IfProgramBlock rtpb = new IfProgramBlock(prog, pred_instruct);
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock sblock : istmt.getIfBody()) {
                childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlockIfBody(childBlock);
            }
            for (StatementBlock sblock : istmt.getElseBody()) {
                childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlockElseBody(childBlock);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            Dag<Lop> fromDag = new Dag<Lop>();
            Dag<Lop> toDag = new Dag<Lop>();
            Dag<Lop> incrementDag = new Dag<Lop>();
            if (fsb.getFromHops() != null) {
                fsb.getFromLops().addToDag(fromDag);
            }
            if (fsb.getToHops() != null) {
                fsb.getToLops().addToDag(toDag);
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementLops().addToDag(incrementDag);
            }
            ArrayList<Instruction> fromInstructions = fromDag.getJobs(null, config);
            ArrayList<Instruction> toInstructions = toDag.getJobs(null, config);
            ArrayList<Instruction> incrementInstructions = incrementDag.getJobs(null, config);
            ForProgramBlock rtpb = null;
            IterablePredicate iterPred = fsb.getIterPredicate();
            if (sb instanceof ParForStatementBlock && ConfigurationManager.isParallelParFor()) {
                rtpb = new ParForProgramBlock(prog, iterPred.getIterVar().getName(), iterPred.getParForParams(), ((ParForStatementBlock)sb).getResultVariables());
                ParForProgramBlock pfrtpb = (ParForProgramBlock)rtpb;
                pfrtpb.setStatementBlock((ParForStatementBlock)sb);
            } else {
                rtpb = new ForProgramBlock(prog, iterPred.getIterVar().getName());
            }
            rtpb.setFromInstructions(fromInstructions);
            rtpb.setToInstructions(toInstructions);
            rtpb.setIncrementInstructions(incrementInstructions);
            ForStatement fs = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sblock : fs.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            FunctionProgramBlock rtpb = null;
            if (fstmt instanceof ExternalFunctionStatement) {
                String execType = ((ExternalFunctionStatement)fstmt).getOtherParams().get("exectype");
                boolean isCP = execType.equals("mem");
                StringBuilder buff = new StringBuilder();
                buff.append(config.getTextValue("sysml.scratch"));
                buff.append("/");
                buff.append("_p");
                buff.append(DMLScript.getUUID());
                buff.append("/");
                buff.append("_t0");
                buff.append("/");
                buff.append("PackageSupport");
                buff.append("/");
                String basedir = buff.toString();
                rtpb = isCP ? new ExternalFunctionProgramBlockCP(prog, fstmt.getInputParams(), fstmt.getOutputParams(), ((ExternalFunctionStatement)fstmt).getOtherParams(), basedir) : new ExternalFunctionProgramBlock(prog, fstmt.getInputParams(), fstmt.getOutputParams(), ((ExternalFunctionStatement)fstmt).getOtherParams(), basedir);
                if (!fstmt.getBody().isEmpty()) {
                    throw new LopsException(fstmt.printErrorLocation() + "ExternalFunctionStatementBlock should have no statement blocks in body");
                }
            } else {
                rtpb = new FunctionProgramBlock(prog, fstmt.getInputParams(), fstmt.getOutputParams());
                for (StatementBlock sblock : fstmt.getBody()) {
                    ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                    rtpb.addProgramBlock(childBlock);
                }
            }
            if (fsb.getLops() != null && !fsb.getLops().isEmpty()) {
                throw new LopsException(fsb.printBlockErrorLocation() + "FunctionStatementBlock should have no Lops");
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else {
            ProgramBlock rtpb = new ProgramBlock(prog);
            dag = new Dag<Lop>();
            if (sb.getLops() != null && !sb.getLops().isEmpty()) {
                for (Lop l : sb.getLops()) {
                    l.addToDag(dag);
                }
                ArrayList<Instruction> instruct = dag.getJobs(sb, config);
                rtpb.addInstructions(instruct);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        }
        return retPB;
    }

    public void printLops(DMLProgram dmlp) {
        if (LOG.isDebugEnabled()) {
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    this.printLops(fsblock);
                }
            }
            for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
                StatementBlock current = dmlp.getStatementBlock(i);
                this.printLops(current);
            }
        }
    }

    public void printLops(StatementBlock current) {
        if (LOG.isDebugEnabled()) {
            Lop predicateLops;
            Hop predicateHops;
            ArrayList<Lop> lopsDAG = current.getLops();
            LOG.debug((Object)"\n********************** LOPS DAG FOR BLOCK *******************");
            if (current instanceof FunctionStatementBlock) {
                if (current.getNumStatements() > 1) {
                    LOG.debug((Object)"Function statement block has more than 1 stmt");
                }
                FunctionStatement fstmt = (FunctionStatement)current.getStatement(0);
                for (StatementBlock child : fstmt.getBody()) {
                    this.printLops(child);
                }
            }
            if (current instanceof WhileStatementBlock) {
                WhileStatementBlock wstb = (WhileStatementBlock)current;
                predicateHops = ((WhileStatementBlock)current).getPredicateHops();
                LOG.debug((Object)"\n********************** PREDICATE LOPS *******************");
                predicateLops = predicateHops.getLops();
                if (predicateLops == null) {
                    predicateLops = predicateHops.constructLops();
                }
                predicateLops.printMe();
                if (wstb.getNumStatements() > 1) {
                    throw new HopsException(wstb.printBlockErrorLocation() + "WhileStatementBlock has more than 1 statement");
                }
                WhileStatement ws = (WhileStatement)wstb.getStatement(0);
                for (StatementBlock sb : ws.getBody()) {
                    this.printLops(sb);
                }
            }
            if (current instanceof IfStatementBlock) {
                IfStatementBlock istb = (IfStatementBlock)current;
                predicateHops = ((IfStatementBlock)current).getPredicateHops();
                LOG.debug((Object)"\n********************** PREDICATE LOPS *******************");
                predicateLops = predicateHops.getLops();
                if (predicateLops == null) {
                    predicateLops = predicateHops.constructLops();
                }
                predicateLops.printMe();
                if (istb.getNumStatements() > 1) {
                    throw new HopsException(istb.printBlockErrorLocation() + "IfStatmentBlock has more than 1 statement");
                }
                IfStatement is = (IfStatement)istb.getStatement(0);
                LOG.debug((Object)"\n**** LOPS DAG FOR IF BODY ****");
                for (StatementBlock sb : is.getIfBody()) {
                    this.printLops(sb);
                }
                if (!is.getElseBody().isEmpty()) {
                    LOG.debug((Object)"\n**** LOPS DAG FOR IF BODY ****");
                    for (StatementBlock sb : is.getElseBody()) {
                        this.printLops(sb);
                    }
                }
            }
            if (current instanceof ForStatementBlock) {
                Lop llops;
                ForStatementBlock fsb = (ForStatementBlock)current;
                LOG.debug((Object)"\n********************** PREDICATE LOPS *******************");
                if (fsb.getFromHops() != null) {
                    LOG.debug((Object)"FROM:");
                    llops = fsb.getFromLops();
                    if (llops == null) {
                        llops = fsb.getFromHops().constructLops();
                    }
                    llops.printMe();
                }
                if (fsb.getToHops() != null) {
                    LOG.debug((Object)"TO:");
                    llops = fsb.getToLops();
                    if (llops == null) {
                        llops = fsb.getToHops().constructLops();
                    }
                    llops.printMe();
                }
                if (fsb.getIncrementHops() != null) {
                    LOG.debug((Object)"INCREMENT:");
                    llops = fsb.getIncrementLops();
                    if (llops == null) {
                        llops = fsb.getIncrementHops().constructLops();
                    }
                    llops.printMe();
                }
                if (fsb.getNumStatements() > 1) {
                    throw new HopsException(fsb.printBlockErrorLocation() + "ForStatementBlock has more than 1 statement");
                }
                ForStatement ws = (ForStatement)fsb.getStatement(0);
                for (StatementBlock sb : ws.getBody()) {
                    this.printLops(sb);
                }
            }
            if (lopsDAG != null && !lopsDAG.isEmpty()) {
                Iterator<Lop> iter = lopsDAG.iterator();
                while (iter.hasNext()) {
                    LOG.debug((Object)"\n********************** OUTPUT LOPS *******************");
                    iter.next().printMe();
                }
            }
        }
    }

    public void refreshMemEstimates(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                this.refreshMemEstimates(fsblock);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            this.refreshMemEstimates(current);
        }
    }

    public void refreshMemEstimates(StatementBlock current) {
        block14: {
            Statement ws;
            block16: {
                block15: {
                    block13: {
                        ArrayList<Hop> hopsDAG;
                        MemoTable memo = new MemoTable();
                        if (HopRewriteUtils.isLastLevelStatementBlock(current) && (hopsDAG = current.getHops()) != null && !hopsDAG.isEmpty()) {
                            for (Hop hop : hopsDAG) {
                                hop.refreshMemEstimates(memo);
                            }
                        }
                        if (!(current instanceof FunctionStatementBlock)) break block13;
                        FunctionStatement fstmt = (FunctionStatement)current.getStatement(0);
                        for (StatementBlock sb : fstmt.getBody()) {
                            this.refreshMemEstimates(sb);
                        }
                        break block14;
                    }
                    if (!(current instanceof WhileStatementBlock)) break block15;
                    WhileStatementBlock wstb = (WhileStatementBlock)current;
                    wstb.getPredicateHops().refreshMemEstimates(new MemoTable());
                    if (wstb.getNumStatements() > 1) {
                        LOG.debug((Object)"While statement block has more than 1 stmt");
                    }
                    ws = (WhileStatement)wstb.getStatement(0);
                    for (StatementBlock sb : ((WhileStatement)ws).getBody()) {
                        this.refreshMemEstimates(sb);
                    }
                    break block14;
                }
                if (!(current instanceof IfStatementBlock)) break block16;
                IfStatementBlock istb = (IfStatementBlock)current;
                istb.getPredicateHops().refreshMemEstimates(new MemoTable());
                if (istb.getNumStatements() > 1) {
                    LOG.debug((Object)"If statement block has more than 1 stmt");
                }
                IfStatement is = (IfStatement)istb.getStatement(0);
                for (StatementBlock sb : is.getIfBody()) {
                    this.refreshMemEstimates(sb);
                }
                for (StatementBlock sb : is.getElseBody()) {
                    this.refreshMemEstimates(sb);
                }
                break block14;
            }
            if (!(current instanceof ForStatementBlock)) break block14;
            ForStatementBlock fsb = (ForStatementBlock)current;
            if (fsb.getFromHops() != null) {
                fsb.getFromHops().refreshMemEstimates(new MemoTable());
            }
            if (fsb.getToHops() != null) {
                fsb.getToHops().refreshMemEstimates(new MemoTable());
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementHops().refreshMemEstimates(new MemoTable());
            }
            if (fsb.getNumStatements() > 1) {
                LOG.debug((Object)"For statement block has more than 1 stmt");
            }
            ws = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sb : ((ForStatement)ws).getBody()) {
                this.refreshMemEstimates(sb);
            }
        }
    }

    public static void resetHopsDAGVisitStatus(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                DMLTranslator.resetHopsDAGVisitStatus(fsblock);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            DMLTranslator.resetHopsDAGVisitStatus(current);
        }
    }

    public static void resetHopsDAGVisitStatus(StatementBlock current) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        ArrayList<Hop> hopsDAG;
                        if (HopRewriteUtils.isLastLevelStatementBlock(current) && (hopsDAG = current.getHops()) != null && !hopsDAG.isEmpty()) {
                            Hop.resetVisitStatus(hopsDAG);
                        }
                        if (!(current instanceof FunctionStatementBlock)) break block10;
                        FunctionStatement fstmt = (FunctionStatement)current.getStatement(0);
                        for (StatementBlock sb : fstmt.getBody()) {
                            DMLTranslator.resetHopsDAGVisitStatus(sb);
                        }
                        break block11;
                    }
                    if (!(current instanceof WhileStatementBlock)) break block12;
                    WhileStatementBlock wstb = (WhileStatementBlock)current;
                    wstb.getPredicateHops().resetVisitStatus();
                    WhileStatement ws = (WhileStatement)wstb.getStatement(0);
                    for (StatementBlock sb : ws.getBody()) {
                        DMLTranslator.resetHopsDAGVisitStatus(sb);
                    }
                    break block11;
                }
                if (!(current instanceof IfStatementBlock)) break block13;
                IfStatementBlock istb = (IfStatementBlock)current;
                istb.getPredicateHops().resetVisitStatus();
                IfStatement is = (IfStatement)istb.getStatement(0);
                for (StatementBlock sb : is.getIfBody()) {
                    DMLTranslator.resetHopsDAGVisitStatus(sb);
                }
                for (StatementBlock sb : is.getElseBody()) {
                    DMLTranslator.resetHopsDAGVisitStatus(sb);
                }
                break block11;
            }
            if (!(current instanceof ForStatementBlock)) break block11;
            ForStatementBlock fsb = (ForStatementBlock)current;
            if (fsb.getFromHops() != null) {
                fsb.getFromHops().resetVisitStatus();
            }
            if (fsb.getToHops() != null) {
                fsb.getToHops().resetVisitStatus();
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementHops().resetVisitStatus();
            }
            if (fsb.getNumStatements() > 1) {
                LOG.debug((Object)"For statment block has more than 1 stmt");
            }
            ForStatement ws = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sb : ws.getBody()) {
                DMLTranslator.resetHopsDAGVisitStatus(sb);
            }
        }
    }

    public void resetLopsDAGVisitStatus(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                this.resetLopsDAGVisitStatus(fsblock);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            this.resetLopsDAGVisitStatus(current);
        }
    }

    public void resetLopsDAGVisitStatus(StatementBlock current) {
        Statement ws;
        StatementBlock fsb;
        ArrayList<Hop> hopsDAG = current.getHops();
        if (hopsDAG != null && !hopsDAG.isEmpty()) {
            for (Hop currentHop : hopsDAG) {
                currentHop.getLops().resetVisitStatus();
            }
        }
        if (current instanceof FunctionStatementBlock) {
            fsb = (FunctionStatementBlock)current;
            FunctionStatement fs = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sb : fs.getBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
        if (current instanceof WhileStatementBlock) {
            WhileStatementBlock wstb = (WhileStatementBlock)current;
            wstb.getPredicateLops().resetVisitStatus();
            if (wstb.getNumStatements() > 1) {
                LOG.debug((Object)"While statement block has more than 1 stmt");
            }
            ws = (WhileStatement)wstb.getStatement(0);
            for (StatementBlock sb : ((WhileStatement)ws).getBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
        if (current instanceof IfStatementBlock) {
            IfStatementBlock istb = (IfStatementBlock)current;
            istb.getPredicateLops().resetVisitStatus();
            if (istb.getNumStatements() > 1) {
                LOG.debug((Object)"If statement block has more than 1 stmt");
            }
            IfStatement is = (IfStatement)istb.getStatement(0);
            for (StatementBlock sb : is.getIfBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
            for (StatementBlock sb : is.getElseBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
        if (current instanceof ForStatementBlock) {
            fsb = (ForStatementBlock)current;
            if (((ForStatementBlock)fsb).getFromLops() != null) {
                ((ForStatementBlock)fsb).getFromLops().resetVisitStatus();
            }
            if (((ForStatementBlock)fsb).getToLops() != null) {
                ((ForStatementBlock)fsb).getToLops().resetVisitStatus();
            }
            if (((ForStatementBlock)fsb).getIncrementLops() != null) {
                ((ForStatementBlock)fsb).getIncrementLops().resetVisitStatus();
            }
            if (fsb.getNumStatements() > 1) {
                LOG.debug((Object)"For statement block has more than 1 stmt");
            }
            ws = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sb : ((ForStatement)ws).getBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
    }

    public void constructHops(StatementBlock sb) {
        DataIdentifier target;
        MultiAssignmentStatement mas;
        AssignmentStatement as;
        Statement current;
        int i;
        if (sb instanceof WhileStatementBlock) {
            this.constructHopsForWhileControlBlock((WhileStatementBlock)sb);
            return;
        }
        if (sb instanceof IfStatementBlock) {
            this.constructHopsForIfControlBlock((IfStatementBlock)sb);
            return;
        }
        if (sb instanceof ForStatementBlock) {
            this.constructHopsForForControlBlock((ForStatementBlock)sb);
            return;
        }
        if (sb instanceof FunctionStatementBlock) {
            this.constructHopsForFunctionControlBlock((FunctionStatementBlock)sb);
            return;
        }
        HashMap<String, Hop> ids = new HashMap<String, Hop>();
        ArrayList<Hop> output = new ArrayList<Hop>();
        VariableSet liveIn = sb.liveIn();
        VariableSet liveOut = sb.liveOut();
        VariableSet updated = sb._updated;
        VariableSet gen = sb._gen;
        VariableSet updatedLiveOut = new VariableSet();
        HashMap<String, Integer> liveOutToTemp = new HashMap<String, Integer>();
        for (i = 0; i < sb.getNumStatements(); ++i) {
            Object target2;
            current = sb.getStatement(i);
            if (current instanceof AssignmentStatement && (target2 = (as = (AssignmentStatement)current).getTarget()) != null && liveOut.containsVariable(((DataIdentifier)target2).getName())) {
                liveOutToTemp.put(((DataIdentifier)target2).getName(), i);
            }
            if (!(current instanceof MultiAssignmentStatement)) continue;
            mas = (MultiAssignmentStatement)current;
            target2 = mas.getTargetList().iterator();
            while (target2.hasNext()) {
                target = (DataIdentifier)target2.next();
                if (!liveOut.containsVariable(target.getName())) continue;
                liveOutToTemp.put(target.getName(), i);
            }
        }
        if (!liveIn.getVariables().values().isEmpty()) {
            for (String varName : liveIn.getVariables().keySet()) {
                if (!updated.containsVariable(varName) && !gen.containsVariable(varName)) continue;
                DataIdentifier var = liveIn.getVariables().get(varName);
                long actualDim1 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim1() : var.getDim1();
                long actualDim2 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim2() : var.getDim2();
                DataOp read = new DataOp(var.getName(), var.getDataType(), var.getValueType(), Hop.DataOpTypes.TRANSIENTREAD, null, actualDim1, actualDim2, var.getNnz(), var.getRowsInBlock(), var.getColumnsInBlock());
                read.setParseInfo(var);
                ids.put(varName, read);
            }
        }
        for (i = 0; i < sb.getNumStatements(); ++i) {
            Hop fcall;
            Hop ae;
            current = sb.getStatement(i);
            if (current instanceof OutputStatement) {
                OutputStatement os = (OutputStatement)current;
                DataExpression source = os.getSource();
                target = os.getIdentifier();
                if (target instanceof IndexedIdentifier) {
                    throw new LanguageException(source.printErrorLocation() + ": Unsupported indexing expression in write statement. Please, assign the right indexing result to a variable and write this variable.");
                }
                ae = (DataOp)this.processExpression(source, target, ids);
                String formatName = os.getExprParam("format").toString();
                ((DataOp)ae).setInputFormatType(Expression.convertFormatType(formatName));
                if (ae.getDataType() == Expression.DataType.SCALAR) {
                    ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), -1, -1);
                } else {
                    switch (((DataOp)ae).getInputFormatType()) {
                        case TEXT: 
                        case MM: 
                        case CSV: {
                            ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), -1, -1);
                            break;
                        }
                        case BINARY: {
                            ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                            break;
                        }
                        default: {
                            throw new LanguageException("Unrecognized file format: " + (Object)((Object)((DataOp)ae).getInputFormatType()));
                        }
                    }
                }
                output.add(ae);
            }
            if (current instanceof PrintStatement) {
                DataIdentifier target3 = DMLTranslator.createTarget();
                target3.setDataType(Expression.DataType.SCALAR);
                target3.setValueType(Expression.ValueType.STRING);
                target3.setParseInfo(current);
                PrintStatement ps = (PrintStatement)current;
                PrintStatement.PRINTTYPE ptype = ps.getType();
                try {
                    Hop ae2;
                    Expression source;
                    Hop.OpOp1 op;
                    if (ptype == PrintStatement.PRINTTYPE.PRINT) {
                        op = Hop.OpOp1.PRINT;
                        source = ps.getExpressions().get(0);
                        ae2 = this.processExpression(source, target3, ids);
                        UnaryOp printHop = new UnaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), op, ae2);
                        printHop.setParseInfo(current);
                        output.add(printHop);
                    } else if (ptype == PrintStatement.PRINTTYPE.ASSERT) {
                        op = Hop.OpOp1.ASSERT;
                        source = ps.getExpressions().get(0);
                        ae2 = this.processExpression(source, target3, ids);
                        UnaryOp printHop = new UnaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), op, ae2);
                        printHop.setParseInfo(current);
                        output.add(printHop);
                    } else if (ptype == PrintStatement.PRINTTYPE.STOP) {
                        op = Hop.OpOp1.STOP;
                        source = ps.getExpressions().get(0);
                        ae2 = this.processExpression(source, target3, ids);
                        UnaryOp stopHop = new UnaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), op, ae2);
                        stopHop.setParseInfo(current);
                        output.add(stopHop);
                        sb.setSplitDag(true);
                    } else if (ptype == PrintStatement.PRINTTYPE.PRINTF) {
                        List<Expression> expressions = ps.getExpressions();
                        Hop[] inHops = new Hop[expressions.size()];
                        for (int j = 0; j < expressions.size(); ++j) {
                            Hop inHop;
                            inHops[j] = inHop = this.processExpression(expressions.get(j), target3, ids);
                        }
                        target3.setValueType(Expression.ValueType.STRING);
                        NaryOp printfHop = new NaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), Hop.OpOpN.PRINTF, inHops);
                        output.add(printfHop);
                    }
                }
                catch (HopsException e2) {
                    throw new LanguageException(e2);
                }
            }
            if (current instanceof AssignmentStatement) {
                as = (AssignmentStatement)current;
                DataIdentifier target4 = as.getTarget();
                Expression source = as.getSource();
                if (!(source instanceof FunctionCallIdentifier)) {
                    Integer statementId;
                    if (!(target4 instanceof IndexedIdentifier)) {
                        ae = this.processExpression(source, target4, ids);
                        if (((AssignmentStatement)current).isAccumulator()) {
                            DataIdentifier accum = liveIn.getVariable(target4.getName());
                            if (accum == null) {
                                throw new LanguageException("Invalid accumulator assignment to non-existing variable " + target4.getName() + ".");
                            }
                            ae = HopRewriteUtils.createBinary(ids.get(target4.getName()), ae, Hop.OpOp2.PLUS);
                            target4.setProperties(accum.getOutput());
                        } else {
                            target4.setProperties(source.getOutput());
                        }
                        ids.put(target4.getName(), ae);
                        Integer statementId2 = (Integer)liveOutToTemp.get(target4.getName());
                        if (statementId2 == null || statementId2 != i) continue;
                        DataOp transientwrite = new DataOp(target4.getName(), target4.getDataType(), target4.getValueType(), ae, Hop.DataOpTypes.TRANSIENTWRITE, null);
                        transientwrite.setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), ae.getRowsInBlock(), ae.getColsInBlock());
                        transientwrite.setParseInfo(target4);
                        updatedLiveOut.addVariable(target4.getName(), target4);
                        output.add(transientwrite);
                        continue;
                    }
                    ae = this.processLeftIndexedExpression(source, (IndexedIdentifier)target4, ids);
                    ids.put(target4.getName(), ae);
                    long origDim1 = ((IndexedIdentifier)target4).getOrigDim1();
                    long origDim2 = ((IndexedIdentifier)target4).getOrigDim2();
                    target4.setProperties(source.getOutput());
                    ((IndexedIdentifier)target4).setOriginalDimensions(origDim1, origDim2);
                    if (target4.getDataType() != Expression.DataType.MATRIX) {
                        target4.setDataType(Expression.DataType.MATRIX);
                        target4.setValueType(Expression.ValueType.DOUBLE);
                        target4.setBlockDimensions(ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize());
                    }
                    if ((statementId = (Integer)liveOutToTemp.get(target4.getName())) == null || statementId != i) continue;
                    DataOp transientwrite = new DataOp(target4.getName(), target4.getDataType(), target4.getValueType(), ae, Hop.DataOpTypes.TRANSIENTWRITE, null);
                    transientwrite.setOutputParams(origDim1, origDim2, ae.getNnz(), ae.getUpdateType(), ae.getRowsInBlock(), ae.getColsInBlock());
                    transientwrite.setParseInfo(target4);
                    updatedLiveOut.addVariable(target4.getName(), target4);
                    output.add(transientwrite);
                    continue;
                }
                FunctionCallIdentifier fci = (FunctionCallIdentifier)source;
                FunctionStatementBlock fsb = this._dmlProg.getFunctionStatementBlock(fci.getNamespace(), fci.getName());
                if (fsb == null) {
                    throw new LanguageException(source.printErrorLocation() + "function " + fci.getName() + " is undefined in namespace " + fci.getNamespace());
                }
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                String fkey = DMLProgram.constructFunctionKey(fci.getNamespace(), fci.getName());
                if (target4 instanceof IndexedIdentifier) {
                    throw new LanguageException("Unsupported function call to '" + fkey + "' in left indexing expression. Please, assign the function output to a variable.");
                }
                List<String> inputNames = new ArrayList<String>(fci.getParamExprs().stream().map(e -> e.getName()).collect(Collectors.toList()));
                ArrayList<Hop> finputs = new ArrayList<Hop>(fci.getParamExprs().stream().map(e -> this.processExpression(e.getExpr(), null, ids)).collect(Collectors.toList()));
                this.appendDefaultArguments(fstmt, inputNames, finputs, ids);
                if (inputNames.stream().allMatch(n -> n == null)) {
                    inputNames = fstmt._inputParams.stream().map(d -> d.getName()).collect(Collectors.toList());
                }
                String[] inputNames2 = inputNames.toArray(new String[0]);
                FunctionOp.FunctionType ftype = fsb.getFunctionOpType();
                FunctionOp fcall2 = target4 == null ? new FunctionOp(ftype, fci.getNamespace(), fci.getName(), inputNames2, finputs, new String[0], false) : new FunctionOp(ftype, fci.getNamespace(), fci.getName(), inputNames2, finputs, new String[]{target4.getName()}, false);
                fcall2.setParseInfo(fci);
                output.add(fcall2);
                continue;
            }
            if (!(current instanceof MultiAssignmentStatement)) continue;
            mas = (MultiAssignmentStatement)current;
            Expression source = mas.getSource();
            if (source instanceof FunctionCallIdentifier) {
                FunctionCallIdentifier fci = (FunctionCallIdentifier)source;
                FunctionStatementBlock fsb = this._dmlProg.getFunctionStatementBlock(fci.getNamespace(), fci.getName());
                if (fsb == null) {
                    throw new LanguageException(source.printErrorLocation() + "function " + fci.getName() + " is undefined in namespace " + fci.getNamespace());
                }
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                List<String> inputNames = new ArrayList<String>(fci.getParamExprs().stream().map(e -> e.getName()).collect(Collectors.toList()));
                ArrayList<Hop> finputs = new ArrayList<Hop>(fci.getParamExprs().stream().map(e -> this.processExpression(e.getExpr(), null, ids)).collect(Collectors.toList()));
                if (inputNames.stream().allMatch(n -> n == null)) {
                    inputNames = fstmt._inputParams.stream().map(d -> d.getName()).collect(Collectors.toList());
                }
                this.appendDefaultArguments(fstmt, inputNames, finputs, ids);
                String[] foutputs = (String[])mas.getTargetList().stream().map(d -> d.getName()).toArray(String[]::new);
                FunctionOp.FunctionType ftype = fsb.getFunctionOpType();
                FunctionOp fcall3 = new FunctionOp(ftype, fci.getNamespace(), fci.getName(), inputNames.toArray(new String[0]), finputs, foutputs, false);
                fcall3.setParseInfo(fci);
                output.add(fcall3);
                continue;
            }
            if (source instanceof BuiltinFunctionExpression && ((BuiltinFunctionExpression)source).multipleReturns()) {
                fcall = this.processMultipleReturnBuiltinFunctionExpression((BuiltinFunctionExpression)source, mas.getTargetList(), ids);
                output.add(fcall);
                continue;
            }
            if (source instanceof ParameterizedBuiltinFunctionExpression && ((ParameterizedBuiltinFunctionExpression)source).multipleReturns()) {
                fcall = this.processMultipleReturnParameterizedBuiltinFunctionExpression((ParameterizedBuiltinFunctionExpression)source, mas.getTargetList(), ids);
                output.add(fcall);
                continue;
            }
            throw new LanguageException("Class \"" + source.getClass() + "\" is not supported in Multiple Assignment statements");
        }
        sb.updateLiveVariablesOut(updatedLiveOut);
        sb.setHops(output);
    }

    private void appendDefaultArguments(FunctionStatement fstmt, List<String> inputNames, List<Hop> inputs, HashMap<String, Hop> ids) {
        if (fstmt.getInputParams().size() == inputs.size()) {
            return;
        }
        HashSet<String> probeNames = new HashSet<String>(inputNames);
        for (DataIdentifier di : fstmt.getInputParams()) {
            if (probeNames.contains(di.getName())) continue;
            Expression exp = fstmt.getInputDefault(di.getName());
            if (exp == null) {
                throw new LanguageException("Missing default expression for unspecified function argument '" + di.getName() + "' in call to function '" + fstmt.getName() + "'.");
            }
            inputNames.add(di.getName());
            inputs.add(this.processExpression(exp, null, ids));
        }
    }

    public void constructHopsForIfControlBlock(IfStatementBlock sb) {
        IfStatement ifsb = (IfStatement)sb.getStatement(0);
        ArrayList<StatementBlock> ifBody = ifsb.getIfBody();
        ArrayList<StatementBlock> elseBody = ifsb.getElseBody();
        this.constructHopsForConditionalPredicate(sb);
        for (StatementBlock current : ifBody) {
            this.constructHops(current);
        }
        for (StatementBlock current : elseBody) {
            this.constructHops(current);
        }
    }

    public void constructHopsForForControlBlock(ForStatementBlock sb) {
        ForStatement fs = (ForStatement)sb.getStatement(0);
        ArrayList<StatementBlock> body = fs.getBody();
        this.constructHopsForIterablePredicate(sb);
        for (StatementBlock current : body) {
            this.constructHops(current);
        }
    }

    public void constructHopsForFunctionControlBlock(FunctionStatementBlock fsb) {
        ArrayList<StatementBlock> body = ((FunctionStatement)fsb.getStatement(0)).getBody();
        for (StatementBlock current : body) {
            this.constructHops(current);
        }
    }

    public void constructHopsForWhileControlBlock(WhileStatementBlock sb) {
        ArrayList<StatementBlock> body = ((WhileStatement)sb.getStatement(0)).getBody();
        this.constructHopsForConditionalPredicate(sb);
        for (StatementBlock current : body) {
            this.constructHops(current);
        }
    }

    public void constructHopsForConditionalPredicate(StatementBlock passedSB) {
        Statement ws;
        HashMap<String, Hop> _ids = new HashMap<String, Hop>();
        ConditionalPredicate cp = null;
        if (passedSB instanceof WhileStatementBlock) {
            ws = (WhileStatement)((WhileStatementBlock)passedSB).getStatement(0);
            cp = ((WhileStatement)ws).getConditionalPredicate();
        } else if (passedSB instanceof IfStatementBlock) {
            ws = (IfStatement)((IfStatementBlock)passedSB).getStatement(0);
            cp = ((IfStatement)ws).getConditionalPredicate();
        } else {
            throw new ParseException("ConditionalPredicate expected only for while or if statements.");
        }
        VariableSet varsRead = cp.variablesRead();
        for (String varName : varsRead.getVariables().keySet()) {
            DataIdentifier var = passedSB.liveIn().getVariables().get(varName);
            DataOp read = null;
            if (var == null) {
                throw new ParseException("variable " + varName + " not live variable for conditional predicate");
            }
            long actualDim1 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim1() : var.getDim1();
            long actualDim2 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim2() : var.getDim2();
            read = new DataOp(var.getName(), var.getDataType(), var.getValueType(), Hop.DataOpTypes.TRANSIENTREAD, null, actualDim1, actualDim2, var.getNnz(), var.getRowsInBlock(), var.getColumnsInBlock());
            read.setParseInfo(var);
            _ids.put(varName, read);
        }
        DataIdentifier target = new DataIdentifier(Expression.getTempName());
        target.setDataType(Expression.DataType.SCALAR);
        target.setValueType(Expression.ValueType.BOOLEAN);
        target.setParseInfo(passedSB);
        Hop predicateHops = null;
        Expression predicate = cp.getPredicate();
        if (predicate instanceof RelationalExpression) {
            predicateHops = this.processRelationalExpression((RelationalExpression)cp.getPredicate(), target, _ids);
        } else if (predicate instanceof BooleanExpression) {
            predicateHops = this.processBooleanExpression((BooleanExpression)cp.getPredicate(), target, _ids);
        } else if (predicate instanceof DataIdentifier) {
            predicateHops = this.processExpression(cp.getPredicate(), null, _ids);
        } else if (predicate instanceof ConstIdentifier) {
            if (predicate instanceof IntIdentifier && ((IntIdentifier)predicate).getValue() == 0L || predicate instanceof DoubleIdentifier && ((DoubleIdentifier)predicate).getValue() == 0.0) {
                cp.setPredicate(new BooleanIdentifier(false, predicate));
            } else if (predicate instanceof IntIdentifier && ((IntIdentifier)predicate).getValue() == 1L || predicate instanceof DoubleIdentifier && ((DoubleIdentifier)predicate).getValue() == 1.0) {
                cp.setPredicate(new BooleanIdentifier(true, predicate));
            } else if (predicate instanceof IntIdentifier || predicate instanceof DoubleIdentifier) {
                cp.setPredicate(new BooleanIdentifier(true, predicate));
                LOG.warn((Object)(predicate.printWarningLocation() + "Numerical value '" + predicate.toString() + "' (!= 0/1) is converted to boolean TRUE by DML"));
            } else if (predicate instanceof StringIdentifier) {
                throw new ParseException(predicate.printErrorLocation() + "String value '" + predicate.toString() + "' is not allowed for iterable predicate");
            }
            predicateHops = this.processExpression(cp.getPredicate(), null, _ids);
        }
        predicateHops = HopRewriteUtils.createDataOp("__pred", predicateHops, Hop.DataOpTypes.TRANSIENTWRITE);
        if (passedSB instanceof WhileStatementBlock) {
            ((WhileStatementBlock)passedSB).setPredicateHops(predicateHops);
        } else if (passedSB instanceof IfStatementBlock) {
            ((IfStatementBlock)passedSB).setPredicateHops(predicateHops);
        }
    }

    public void constructHopsForIterablePredicate(ForStatementBlock fsb) {
        HashMap<String, Hop> _ids = new HashMap<String, Hop>();
        ForStatement fs = (ForStatement)fsb.getStatement(0);
        IterablePredicate ip = fs.getIterablePredicate();
        for (int i = 0; i < 3; ++i) {
            Hop predicateHops;
            VariableSet varsRead;
            Expression expr = i == 0 ? ip.getFromExpr() : (i == 1 ? ip.getToExpr() : (ip.getIncrementExpr() != null ? ip.getIncrementExpr() : null));
            VariableSet variableSet = varsRead = expr != null ? expr.variablesRead() : null;
            if (varsRead != null) {
                for (String varName : varsRead.getVariables().keySet()) {
                    DataIdentifier var = fsb.liveIn().getVariable(varName);
                    DataOp read = null;
                    if (var == null) {
                        throw new ParseException("variable '" + varName + "' is not available for iterable predicate");
                    }
                    long actualDim1 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim1() : var.getDim1();
                    long actualDim2 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim2() : var.getDim2();
                    read = new DataOp(var.getName(), var.getDataType(), var.getValueType(), Hop.DataOpTypes.TRANSIENTREAD, null, actualDim1, actualDim2, var.getNnz(), var.getRowsInBlock(), var.getColumnsInBlock());
                    read.setParseInfo(var);
                    _ids.put(varName, read);
                }
            }
            if ((predicateHops = this.processTempIntExpression(expr, _ids)) != null) {
                predicateHops = HopRewriteUtils.createDataOp("__pred", predicateHops, Hop.DataOpTypes.TRANSIENTWRITE);
            }
            if (i == 0) {
                fsb.setFromHops(predicateHops);
                continue;
            }
            if (i == 1) {
                fsb.setToHops(predicateHops);
                continue;
            }
            if (ip.getIncrementExpr() == null) continue;
            fsb.setIncrementHops(predicateHops);
        }
    }

    private Hop processExpression(Expression source, DataIdentifier target, HashMap<String, Hop> hops) {
        try {
            if (source instanceof BinaryExpression) {
                return this.processBinaryExpression((BinaryExpression)source, target, hops);
            }
            if (source instanceof RelationalExpression) {
                return this.processRelationalExpression((RelationalExpression)source, target, hops);
            }
            if (source instanceof BooleanExpression) {
                return this.processBooleanExpression((BooleanExpression)source, target, hops);
            }
            if (source instanceof BuiltinFunctionExpression) {
                return this.processBuiltinFunctionExpression((BuiltinFunctionExpression)source, target, hops);
            }
            if (source instanceof ParameterizedBuiltinFunctionExpression) {
                return this.processParameterizedBuiltinFunctionExpression((ParameterizedBuiltinFunctionExpression)source, target, hops);
            }
            if (source instanceof DataExpression) {
                Hop ae = this.processDataExpression((DataExpression)source, target, hops);
                if (ae instanceof DataOp) {
                    String formatName = ((DataExpression)source).getVarParam("format").toString();
                    ((DataOp)ae).setInputFormatType(Expression.convertFormatType(formatName));
                }
                return ae;
            }
            if (source instanceof IndexedIdentifier) {
                return this.processIndexingExpression((IndexedIdentifier)source, target, hops);
            }
            if (source instanceof IntIdentifier) {
                IntIdentifier sourceInt = (IntIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceInt.getValue());
                litop.setParseInfo(sourceInt);
                this.setIdentifierParams(litop, sourceInt);
                return litop;
            }
            if (source instanceof DoubleIdentifier) {
                DoubleIdentifier sourceDouble = (DoubleIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceDouble.getValue());
                litop.setParseInfo(sourceDouble);
                this.setIdentifierParams(litop, sourceDouble);
                return litop;
            }
            if (source instanceof BooleanIdentifier) {
                BooleanIdentifier sourceBoolean = (BooleanIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceBoolean.getValue());
                litop.setParseInfo(sourceBoolean);
                this.setIdentifierParams(litop, sourceBoolean);
                return litop;
            }
            if (source instanceof StringIdentifier) {
                StringIdentifier sourceString = (StringIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceString.getValue());
                litop.setParseInfo(sourceString);
                this.setIdentifierParams(litop, sourceString);
                return litop;
            }
            if (source instanceof DataIdentifier) {
                return hops.get(((DataIdentifier)source).getName());
            }
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
        return null;
    }

    private static DataIdentifier createTarget(Expression source) {
        Identifier id = source.getOutput();
        if (id instanceof DataIdentifier && !(id instanceof DataExpression)) {
            return (DataIdentifier)id;
        }
        DataIdentifier target = new DataIdentifier(Expression.getTempName());
        target.setProperties(id);
        return target;
    }

    private static DataIdentifier createTarget() {
        return new DataIdentifier(Expression.getTempName());
    }

    private Hop processTempIntExpression(Expression source, HashMap<String, Hop> hops) {
        if (source == null) {
            return null;
        }
        DataIdentifier tmpOut = DMLTranslator.createTarget();
        tmpOut.setDataType(Expression.DataType.SCALAR);
        tmpOut.setValueType(Expression.ValueType.INT);
        source.setOutput(tmpOut);
        return this.processExpression(source, tmpOut, hops);
    }

    private Hop processLeftIndexedExpression(Expression source, IndexedIdentifier target, HashMap<String, Hop> hops) {
        Hop rowLowerHops = null;
        Hop rowUpperHops = null;
        Hop colLowerHops = null;
        Hop colUpperHops = null;
        rowLowerHops = target.getRowLowerBound() != null ? this.processExpression(target.getRowLowerBound(), null, hops) : new LiteralOp(1L);
        if (target.getRowUpperBound() != null) {
            rowUpperHops = this.processExpression(target.getRowUpperBound(), null, hops);
        } else if (target.getDim1() != -1L) {
            rowUpperHops = new LiteralOp(target.getOrigDim1());
        } else {
            rowUpperHops = new UnaryOp(target.getName(), Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, hops.get(target.getName()));
            rowUpperHops.setParseInfo(target);
        }
        colLowerHops = target.getColLowerBound() != null ? this.processExpression(target.getColLowerBound(), null, hops) : new LiteralOp(1L);
        colUpperHops = target.getColUpperBound() != null ? this.processExpression(target.getColUpperBound(), null, hops) : (target.getDim2() != -1L ? new LiteralOp(target.getOrigDim2()) : new UnaryOp(target.getName(), Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, hops.get(target.getName())));
        Hop sourceOp = this.processExpression(source, target, hops);
        Hop targetOp = hops.get(target.getName());
        if (targetOp == null) {
            throw new ParseException(target.printErrorLocation() + " must define matrix " + target.getName() + " before indexing operations are allowed ");
        }
        if (sourceOp.getDataType().isMatrix() && source.getOutput().getDataType().isScalar()) {
            sourceOp.setDataType(Expression.DataType.SCALAR);
        }
        LeftIndexingOp leftIndexOp = new LeftIndexingOp(target.getName(), target.getDataType(), Expression.ValueType.DOUBLE, targetOp, sourceOp, rowLowerHops, rowUpperHops, colLowerHops, colUpperHops, target.getRowLowerEqualsUpper(), target.getColLowerEqualsUpper());
        this.setIdentifierParams(leftIndexOp, target);
        leftIndexOp.setParseInfo(target);
        leftIndexOp.setDim1(target.getOrigDim1());
        leftIndexOp.setDim2(target.getOrigDim2());
        return leftIndexOp;
    }

    private Hop processIndexingExpression(IndexedIdentifier source, DataIdentifier target, HashMap<String, Hop> hops) {
        Hop rowLowerHops = null;
        Hop rowUpperHops = null;
        Hop colLowerHops = null;
        Hop colUpperHops = null;
        rowLowerHops = source.getRowLowerBound() != null ? this.processExpression(source.getRowLowerBound(), null, hops) : new LiteralOp(1L);
        if (source.getRowUpperBound() != null) {
            rowUpperHops = this.processExpression(source.getRowUpperBound(), null, hops);
        } else if (source.getOrigDim1() != -1L) {
            rowUpperHops = new LiteralOp(source.getOrigDim1());
        } else {
            rowUpperHops = new UnaryOp(source.getName(), Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, hops.get(source.getName()));
            rowUpperHops.setParseInfo(source);
        }
        colLowerHops = source.getColLowerBound() != null ? this.processExpression(source.getColLowerBound(), null, hops) : new LiteralOp(1L);
        colUpperHops = source.getColUpperBound() != null ? this.processExpression(source.getColUpperBound(), null, hops) : (source.getOrigDim2() != -1L ? new LiteralOp(source.getOrigDim2()) : new UnaryOp(source.getName(), Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, hops.get(source.getName())));
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        target.setNnz(-1L);
        IndexingOp indexOp = new IndexingOp(target.getName(), target.getDataType(), target.getValueType(), hops.get(source.getName()), rowLowerHops, rowUpperHops, colLowerHops, colUpperHops, source.getRowLowerEqualsUpper(), source.getColLowerEqualsUpper());
        indexOp.setParseInfo(target);
        this.setIdentifierParams(indexOp, target);
        return indexOp;
    }

    private Hop processBinaryExpression(BinaryExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        Hop left = this.processExpression(source.getLeft(), null, hops);
        Hop right = this.processExpression(source.getRight(), null, hops);
        if (left == null || right == null) {
            left = this.processExpression(source.getLeft(), null, hops);
            right = this.processExpression(source.getRight(), null, hops);
        }
        MultiThreadedHop currBop = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        target.setValueType(source.getOutput().getValueType());
        if (source.getOpCode() == Expression.BinaryOp.PLUS) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.PLUS, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.MINUS) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.MINUS, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.MULT) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.MULT, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.DIV) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.DIV, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.MODULUS) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.MODULUS, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.INTDIV) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.INTDIV, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.MATMULT) {
            currBop = new AggBinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.MULT, Hop.AggOp.SUM, left, right);
        } else if (source.getOpCode() == Expression.BinaryOp.POW) {
            currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.POW, left, right);
        } else {
            throw new ParseException("Unsupported parsing of binary expression: " + (Object)((Object)source.getOpCode()));
        }
        this.setIdentifierParams(currBop, source.getOutput());
        currBop.setParseInfo(source);
        return currBop;
    }

    private Hop processRelationalExpression(RelationalExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        Hop left = this.processExpression(source.getLeft(), null, hops);
        Hop right = this.processExpression(source.getRight(), null, hops);
        BinaryOp currBop = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
            if (left.getDataType() == Expression.DataType.MATRIX || right.getDataType() == Expression.DataType.MATRIX) {
                target.setDataType(Expression.DataType.MATRIX);
                target.setValueType(Expression.ValueType.DOUBLE);
            } else {
                target.setDataType(Expression.DataType.SCALAR);
                target.setValueType(Expression.ValueType.BOOLEAN);
            }
        }
        Hop.OpOp2 op = null;
        if (source.getOpCode() == Expression.RelationalOp.LESS) {
            op = Hop.OpOp2.LESS;
        } else if (source.getOpCode() == Expression.RelationalOp.LESSEQUAL) {
            op = Hop.OpOp2.LESSEQUAL;
        } else if (source.getOpCode() == Expression.RelationalOp.GREATER) {
            op = Hop.OpOp2.GREATER;
        } else if (source.getOpCode() == Expression.RelationalOp.GREATEREQUAL) {
            op = Hop.OpOp2.GREATEREQUAL;
        } else if (source.getOpCode() == Expression.RelationalOp.EQUAL) {
            op = Hop.OpOp2.EQUAL;
        } else if (source.getOpCode() == Expression.RelationalOp.NOTEQUAL) {
            op = Hop.OpOp2.NOTEQUAL;
        }
        currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), op, left, right);
        currBop.setParseInfo(source);
        return currBop;
    }

    private Hop processBooleanExpression(BooleanExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        boolean constLeft = source.getLeft().getOutput() instanceof ConstIdentifier;
        boolean constRight = false;
        if (source.getRight() != null) {
            constRight = source.getRight().getOutput() instanceof ConstIdentifier;
        }
        if (constLeft || constRight) {
            throw new RuntimeException(source.printErrorLocation() + "Boolean expression with constant unsupported");
        }
        Hop left = this.processExpression(source.getLeft(), null, hops);
        Hop right = null;
        if (source.getRight() != null) {
            right = this.processExpression(source.getRight(), null, hops);
        }
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        if (target.getDataType().isScalar()) {
            target.setValueType(Expression.ValueType.BOOLEAN);
        }
        if (source.getRight() == null) {
            UnaryOp currUop = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.NOT, left);
            currUop.setParseInfo(source);
            return currUop;
        }
        BinaryOp currBop = null;
        Hop.OpOp2 op = null;
        if (source.getOpCode() == Expression.BooleanOp.LOGICALAND) {
            op = Hop.OpOp2.AND;
        } else if (source.getOpCode() == Expression.BooleanOp.LOGICALOR) {
            op = Hop.OpOp2.OR;
        } else {
            throw new RuntimeException(source.printErrorLocation() + "Unknown boolean operation " + (Object)((Object)source.getOpCode()));
        }
        currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), op, left, right);
        currBop.setParseInfo(source);
        return currBop;
    }

    private static Hop constructDfHop(String name, Expression.DataType dt, Expression.ValueType vt, Expression.ParameterizedBuiltinFunctionOp op, LinkedHashMap<String, Hop> paramHops) {
        LiteralOp distLop = null;
        switch (op) {
            case QNORM: 
            case PNORM: {
                distLop = new LiteralOp("normal");
                break;
            }
            case QT: 
            case PT: {
                distLop = new LiteralOp("t");
                break;
            }
            case QF: 
            case PF: {
                distLop = new LiteralOp("f");
                break;
            }
            case QCHISQ: 
            case PCHISQ: {
                distLop = new LiteralOp("chisq");
                break;
            }
            case QEXP: 
            case PEXP: {
                distLop = new LiteralOp("exp");
                break;
            }
            case CDF: 
            case INVCDF: {
                break;
            }
            default: {
                throw new HopsException("Invalid operation: " + (Object)((Object)op));
            }
        }
        if (distLop != null) {
            paramHops.put("dist", distLop);
        }
        return new ParameterizedBuiltinOp(name, dt, vt, ParameterizedBuiltinFunctionExpression.pbHopMap.get((Object)op), paramHops);
    }

    private Hop processMultipleReturnParameterizedBuiltinFunctionExpression(ParameterizedBuiltinFunctionExpression source, ArrayList<DataIdentifier> targetList, HashMap<String, Hop> hops) {
        FunctionOp.FunctionType ftype = FunctionOp.FunctionType.MULTIRETURN_BUILTIN;
        String nameSpace = "_internal";
        ArrayList<Hop> outputs = new ArrayList<Hop>();
        FunctionOp currBuiltinOp = null;
        switch (source.getOpCode()) {
            case TRANSFORMENCODE: {
                ArrayList<Hop> inputs = new ArrayList<Hop>();
                inputs.add(this.processExpression(source.getVarParam("target"), null, hops));
                inputs.add(this.processExpression(source.getVarParam("spec"), null, hops));
                String[] outputNames = new String[targetList.size()];
                outputNames[0] = targetList.get(0).getName();
                outputNames[1] = targetList.get(1).getName();
                outputs.add(new DataOp(outputNames[0], Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, (Hop)inputs.get(0), Hop.DataOpTypes.FUNCTIONOUTPUT, ((Hop)inputs.get(0)).getFilename()));
                outputs.add(new DataOp(outputNames[1], Expression.DataType.FRAME, Expression.ValueType.STRING, (Hop)inputs.get(0), Hop.DataOpTypes.FUNCTIONOUTPUT, ((Hop)inputs.get(0)).getFilename()));
                currBuiltinOp = new FunctionOp(ftype, nameSpace, source.getOpCode().toString(), null, inputs, outputNames, outputs);
                break;
            }
            default: {
                throw new ParseException("Invaid Opcode in DMLTranslator:processMultipleReturnParameterizedBuiltinFunctionExpression(): " + (Object)((Object)source.getOpCode()));
            }
        }
        for (int i = 0; i < source.getOutputs().length; ++i) {
            this.setIdentifierParams(outputs.get(i), source.getOutputs()[i]);
            outputs.get(i).setParseInfo(source);
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop processParameterizedBuiltinFunctionExpression(ParameterizedBuiltinFunctionExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        LinkedHashMap<String, Hop> paramHops = new LinkedHashMap<String, Hop>();
        Hop pHop = null;
        for (String paramName : source.getVarParams().keySet()) {
            pHop = this.processExpression(source.getVarParam(paramName), null, hops);
            paramHops.put(paramName, pHop);
        }
        Hop currBuiltinOp = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        switch (source.getOpCode()) {
            case QNORM: 
            case PNORM: 
            case QT: 
            case PT: 
            case QF: 
            case PF: 
            case QCHISQ: 
            case PCHISQ: 
            case QEXP: 
            case PEXP: 
            case CDF: 
            case INVCDF: {
                currBuiltinOp = DMLTranslator.constructDfHop(target.getName(), target.getDataType(), target.getValueType(), source.getOpCode(), paramHops);
                break;
            }
            case GROUPEDAGG: 
            case RMEMPTY: 
            case REPLACE: 
            case LOWER_TRI: 
            case UPPER_TRI: 
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMCOLMAP: 
            case TRANSFORMMETA: 
            case PARAMSERV: {
                currBuiltinOp = new ParameterizedBuiltinOp(target.getName(), target.getDataType(), target.getValueType(), Hop.ParamBuiltinOp.valueOf(source.getOpCode().name()), paramHops);
                break;
            }
            case ORDER: {
                ArrayList<Hop> inputs = new ArrayList<Hop>();
                inputs.add((Hop)paramHops.get("target"));
                inputs.add(paramHops.get("by"));
                inputs.add(paramHops.get("decreasing"));
                inputs.add(paramHops.get("index.return"));
                currBuiltinOp = new ReorgOp(target.getName(), target.getDataType(), target.getValueType(), Hop.ReOrgOp.SORT, inputs);
                break;
            }
            case TOSTRING: {
                currBuiltinOp = !((Hop)paramHops.get("target")).getDataType().isScalar() ? new ParameterizedBuiltinOp(target.getName(), target.getDataType(), target.getValueType(), Hop.ParamBuiltinOp.TOSTRING, paramHops) : HopRewriteUtils.createBinary(paramHops.get("target"), new LiteralOp(""), Hop.OpOp2.PLUS);
                break;
            }
            case LIST: {
                currBuiltinOp = new ParameterizedBuiltinOp(target.getName(), target.getDataType(), target.getValueType(), Hop.ParamBuiltinOp.LIST, paramHops);
                break;
            }
            default: {
                throw new ParseException(source.printErrorLocation() + "processParameterizedBuiltinFunctionExpression() -- Unknown operation: " + (Object)((Object)source.getOpCode()));
            }
        }
        this.setIdentifierParams(currBuiltinOp, source.getOutput());
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop processDataExpression(DataExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        HashMap<String, Hop> paramHops = new HashMap<String, Hop>();
        Hop pHop = null;
        for (String paramName : source.getVarParams().keySet()) {
            pHop = this.processExpression(source.getVarParam(paramName), null, hops);
            paramHops.put(paramName, pHop);
        }
        Hop currBuiltinOp = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        switch (source.getOpCode()) {
            case READ: {
                currBuiltinOp = new DataOp(target.getName(), target.getDataType(), target.getValueType(), Hop.DataOpTypes.PERSISTENTREAD, paramHops);
                ((DataOp)currBuiltinOp).setFileName(((StringIdentifier)source.getVarParam("iofilename")).getValue());
                break;
            }
            case WRITE: {
                currBuiltinOp = new DataOp(target.getName(), target.getDataType(), target.getValueType(), Hop.DataOpTypes.PERSISTENTWRITE, hops.get(target.getName()), paramHops);
                break;
            }
            case RAND: {
                Hop.DataGenMethod method = ((Hop)paramHops.get("min")).getValueType() == Expression.ValueType.STRING ? Hop.DataGenMethod.SINIT : Hop.DataGenMethod.RAND;
                currBuiltinOp = new DataGenOp(method, target, paramHops);
                break;
            }
            case MATRIX: {
                ArrayList<Hop> tmp = new ArrayList<Hop>();
                tmp.add(0, (Hop)paramHops.get("data"));
                tmp.add(1, paramHops.get("rows"));
                tmp.add(2, paramHops.get("cols"));
                tmp.add(3, paramHops.get("byrow"));
                currBuiltinOp = new ReorgOp(target.getName(), target.getDataType(), target.getValueType(), Hop.ReOrgOp.RESHAPE, tmp);
                break;
            }
            default: {
                throw new ParseException(source.printErrorLocation() + "processDataExpression():: Unknown operation:  " + (Object)((Object)source.getOpCode()));
            }
        }
        this.setIdentifierParams(currBuiltinOp, source.getOutput());
        if (source.getOpCode() == Expression.DataOp.READ) {
            ((DataOp)currBuiltinOp).setInputBlockSizes(target.getRowsInBlock(), target.getColumnsInBlock());
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop processMultipleReturnBuiltinFunctionExpression(BuiltinFunctionExpression source, ArrayList<DataIdentifier> targetList, HashMap<String, Hop> hops) {
        ArrayList<Hop> inputs = new ArrayList<Hop>();
        inputs.add(this.processExpression(source.getFirstExpr(), null, hops));
        Expression[] expr = source.getAllExpr();
        if (expr != null && expr.length > 1) {
            for (int i = 1; i < expr.length; ++i) {
                inputs.add(this.processExpression(expr[i], null, hops));
            }
        }
        FunctionOp.FunctionType ftype = FunctionOp.FunctionType.MULTIRETURN_BUILTIN;
        String nameSpace = "_internal";
        ArrayList<Hop> outputs = new ArrayList<Hop>();
        FunctionOp currBuiltinOp = null;
        switch (source.getOpCode()) {
            case QR: 
            case LU: 
            case EIGEN: 
            case LSTM: 
            case LSTM_BACKWARD: 
            case BATCH_NORM2D: 
            case BATCH_NORM2D_BACKWARD: 
            case SVD: {
                FunctionOp fcall;
                String[] outputNames = new String[targetList.size()];
                for (int i = 0; i < targetList.size(); ++i) {
                    outputNames[i] = targetList.get(i).getName();
                    DataOp output = new DataOp(outputNames[i], Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, inputs.get(0), Hop.DataOpTypes.FUNCTIONOUTPUT, inputs.get(0).getFilename());
                    outputs.add(output);
                }
                currBuiltinOp = fcall = new FunctionOp(ftype, nameSpace, source.getOpCode().toString(), null, inputs, outputNames, outputs);
                break;
            }
            default: {
                throw new ParseException("Invaid Opcode in DMLTranslator:processMultipleReturnBuiltinFunctionExpression(): " + (Object)((Object)source.getOpCode()));
            }
        }
        for (int i = 0; i < source.getOutputs().length; ++i) {
            this.setIdentifierParams(outputs.get(i), source.getOutputs()[i]);
            outputs.get(i).setParseInfo(source);
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Hop processBuiltinFunctionExpression(BuiltinFunctionExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        boolean isConvolution;
        Hop expr = this.processExpression(source.getFirstExpr(), null, hops);
        Hop expr2 = null;
        if (source.getSecondExpr() != null) {
            expr2 = this.processExpression(source.getSecondExpr(), null, hops);
        }
        Hop expr3 = null;
        if (source.getThirdExpr() != null) {
            expr3 = this.processExpression(source.getThirdExpr(), null, hops);
        }
        Hop currBuiltinOp = null;
        target = target == null ? DMLTranslator.createTarget(source) : target;
        block0 : switch (source.getOpCode()) {
            case EVAL: {
                currBuiltinOp = new NaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOpN.EVAL, this.processAllExpressions(source.getAllExpr(), hops));
                break;
            }
            case COLSUM: 
            case COLMAX: 
            case COLMIN: 
            case COLMEAN: 
            case COLPROD: 
            case COLVAR: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.AggOp.valueOf(source.getOpCode().name().substring(3)), Hop.Direction.Col, expr);
                break;
            }
            case COLSD: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.AggOp.VAR, Hop.Direction.Col, expr);
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOp1.SQRT, currBuiltinOp);
                break;
            }
            case ROWSUM: 
            case ROWMIN: 
            case ROWMAX: 
            case ROWMEAN: 
            case ROWPROD: 
            case ROWVAR: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.AggOp.valueOf(source.getOpCode().name().substring(3)), Hop.Direction.Row, expr);
                break;
            }
            case ROWINDEXMAX: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.AggOp.MAXINDEX, Hop.Direction.Row, expr);
                break;
            }
            case ROWINDEXMIN: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.AggOp.MININDEX, Hop.Direction.Row, expr);
                break;
            }
            case ROWSD: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.AggOp.VAR, Hop.Direction.Row, expr);
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOp1.SQRT, currBuiltinOp);
                break;
            }
            case NROW: {
                currBuiltinOp = expr.getDim1() == -1L ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.NROW, expr) : new LiteralOp(expr.getDim1());
                break;
            }
            case NCOL: {
                currBuiltinOp = expr.getDim2() == -1L ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.NCOL, expr) : new LiteralOp(expr.getDim2());
                break;
            }
            case LENGTH: {
                currBuiltinOp = expr.getDim1() == -1L || expr.getDim2() == -1L ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.LENGTH, expr) : new LiteralOp(expr.getDim1() * expr.getDim2());
                break;
            }
            case LIST: {
                currBuiltinOp = new NaryOp(target.getName(), Expression.DataType.LIST, Expression.ValueType.UNKNOWN, Hop.OpOpN.LIST, this.processAllExpressions(source.getAllExpr(), hops));
                break;
            }
            case EXISTS: {
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.OpOp1.EXISTS, expr);
                break;
            }
            case SUM: 
            case PROD: 
            case VAR: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.AggOp.valueOf(source.getOpCode().name()), Hop.Direction.RowCol, expr);
                break;
            }
            case MEAN: {
                if (expr2 == null) {
                    currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.AggOp.MEAN, Hop.Direction.RowCol, expr);
                    break;
                }
                LiteralOp orderHop = new LiteralOp(0L);
                currBuiltinOp = new TernaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.OpOp3.MOMENT, expr, expr2, orderHop);
                break;
            }
            case SD: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.AggOp.VAR, Hop.Direction.RowCol, expr);
                HopRewriteUtils.setOutputParametersForScalar(currBuiltinOp);
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.OpOp1.SQRT, currBuiltinOp);
                break;
            }
            case MIN: 
            case MAX: {
                currBuiltinOp = expr2 == null ? new AggUnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.AggOp.valueOf(source.getOpCode().name()), Hop.Direction.RowCol, expr) : (source.getAllExpr().length == 2 ? new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.valueOf(source.getOpCode().name()), expr, expr2) : new NaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOpN.valueOf(source.getOpCode().name()), this.processAllExpressions(source.getAllExpr(), hops)));
                break;
            }
            case PPRED: {
                Hop.OpOp2 operation;
                String sop = ((StringIdentifier)source.getThirdExpr()).getValue();
                sop = sop.replace("\"", "");
                if (sop.equalsIgnoreCase(">=")) {
                    operation = Hop.OpOp2.GREATEREQUAL;
                } else if (sop.equalsIgnoreCase(">")) {
                    operation = Hop.OpOp2.GREATER;
                } else if (sop.equalsIgnoreCase("<=")) {
                    operation = Hop.OpOp2.LESSEQUAL;
                } else if (sop.equalsIgnoreCase("<")) {
                    operation = Hop.OpOp2.LESS;
                } else if (sop.equalsIgnoreCase("==")) {
                    operation = Hop.OpOp2.EQUAL;
                } else {
                    if (!sop.equalsIgnoreCase("!=")) throw new ParseException(source.printErrorLocation() + "Unknown argument (" + sop + ") for PPRED.");
                    operation = Hop.OpOp2.NOTEQUAL;
                }
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), operation, expr, expr2);
                break;
            }
            case TRACE: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.AggOp.TRACE, Hop.Direction.RowCol, expr);
                break;
            }
            case TRANS: 
            case DIAG: 
            case REV: {
                currBuiltinOp = new ReorgOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.ReOrgOp.valueOf(source.getOpCode().name()), expr);
                break;
            }
            case CBIND: 
            case RBIND: {
                Hop.OpOp2 appendOp1 = source.getOpCode() == Expression.BuiltinFunctionOp.CBIND ? Hop.OpOp2.CBIND : Hop.OpOp2.RBIND;
                Hop.OpOpN appendOp2 = source.getOpCode() == Expression.BuiltinFunctionOp.CBIND ? Hop.OpOpN.CBIND : Hop.OpOpN.RBIND;
                currBuiltinOp = source.getAllExpr().length == 2 ? new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), appendOp1, expr, expr2) : new NaryOp(target.getName(), target.getDataType(), target.getValueType(), appendOp2, this.processAllExpressions(source.getAllExpr(), hops));
                break;
            }
            case TABLE: {
                int numTableArgs = source._args.length;
                switch (numTableArgs) {
                    case 2: 
                    case 4: {
                        LiteralOp weightHop = new LiteralOp(1.0);
                        weightHop.setDim1(0L);
                        weightHop.setDim2(0L);
                        weightHop.setNnz(-1L);
                        weightHop.setRowsInBlock(0);
                        weightHop.setColsInBlock(0);
                        if (numTableArgs == 2) {
                            currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp3.CTABLE, expr, expr2, weightHop);
                            break block0;
                        }
                        Hop outDim1 = this.processExpression(source._args[2], null, hops);
                        Hop outDim2 = this.processExpression(source._args[3], null, hops);
                        currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp3.CTABLE, expr, expr2, weightHop, outDim1, outDim2);
                        break block0;
                    }
                    case 3: 
                    case 5: {
                        if (numTableArgs == 3) {
                            currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp3.CTABLE, expr, expr2, expr3);
                            break block0;
                        }
                        Hop outDim1 = this.processExpression(source._args[3], null, hops);
                        Hop outDim2 = this.processExpression(source._args[4], null, hops);
                        currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp3.CTABLE, expr, expr2, expr3, outDim1, outDim2);
                        break block0;
                    }
                }
                throw new ParseException("Invalid number of arguments " + numTableArgs + " to table() function.");
            }
            case CAST_AS_SCALAR: {
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.SCALAR, target.getValueType(), Hop.OpOp1.CAST_AS_SCALAR, expr);
                break;
            }
            case CAST_AS_MATRIX: {
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOp1.CAST_AS_MATRIX, expr);
                break;
            }
            case CAST_AS_FRAME: {
                currBuiltinOp = new UnaryOp(target.getName(), Expression.DataType.FRAME, target.getValueType(), Hop.OpOp1.CAST_AS_FRAME, expr);
                break;
            }
            case CAST_AS_DOUBLE: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Expression.ValueType.DOUBLE, Hop.OpOp1.CAST_AS_DOUBLE, expr);
                break;
            }
            case CAST_AS_INT: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Expression.ValueType.INT, Hop.OpOp1.CAST_AS_INT, expr);
                break;
            }
            case CAST_AS_BOOLEAN: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Expression.ValueType.BOOLEAN, Hop.OpOp1.CAST_AS_BOOLEAN, expr);
                break;
            }
            case XOR: 
            case BITWAND: 
            case BITWOR: 
            case BITWXOR: 
            case BITWSHIFTL: 
            case BITWSHIFTR: {
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.valueOf(source.getOpCode().name()), expr, expr2);
                break;
            }
            case ABS: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ACOS: 
            case ATAN: 
            case SINH: 
            case COSH: 
            case TANH: 
            case SIGN: 
            case SQRT: 
            case EXP: 
            case ROUND: 
            case CEIL: 
            case FLOOR: 
            case CUMSUM: 
            case CUMPROD: 
            case CUMSUMPROD: 
            case CUMMIN: 
            case CUMMAX: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.valueOf(source.getOpCode().name()), expr);
                break;
            }
            case LOG: {
                Hop.OpOp2 mathOp3;
                if (expr2 == null) {
                    Hop.OpOp1 mathOp2;
                    switch (source.getOpCode()) {
                        case LOG: {
                            mathOp2 = Hop.OpOp1.LOG;
                            break;
                        }
                        default: {
                            throw new ParseException(source.printErrorLocation() + "processBuiltinFunctionExpression():: Could not find Operation type for builtin function: " + (Object)((Object)source.getOpCode()));
                        }
                    }
                    currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), mathOp2, expr);
                    break;
                }
                switch (source.getOpCode()) {
                    case LOG: {
                        mathOp3 = Hop.OpOp2.LOG;
                        break;
                    }
                    default: {
                        throw new ParseException(source.printErrorLocation() + "processBuiltinFunctionExpression():: Could not find Operation type for builtin function: " + (Object)((Object)source.getOpCode()));
                    }
                }
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), mathOp3, expr, expr2);
                break;
            }
            case MOMENT: 
            case COV: 
            case QUANTILE: 
            case INTERQUANTILE: {
                currBuiltinOp = expr3 == null ? new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.valueOf(source.getOpCode().name()), expr, expr2) : new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp3.valueOf(source.getOpCode().name()), expr, expr2, expr3);
                break;
            }
            case IQM: 
            case MEDIAN: {
                currBuiltinOp = expr2 == null ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.valueOf(source.getOpCode().name()), expr) : new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.valueOf(source.getOpCode().name()), expr, expr2);
                break;
            }
            case IFELSE: {
                currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp3.IFELSE, expr, expr2, expr3);
                break;
            }
            case SEQ: {
                HashMap<String, Hop> randParams = new HashMap<String, Hop>();
                randParams.put("from", expr);
                randParams.put("to", expr2);
                randParams.put("incr", expr3 != null ? expr3 : new LiteralOp(1L));
                currBuiltinOp = new DataGenOp(Hop.DataGenMethod.SEQ, target, randParams);
                break;
            }
            case SAMPLE: {
                Expression[] in = source.getAllExpr();
                HashMap<String, Hop> tmpparams = new HashMap<String, Hop>();
                tmpparams.put("max", expr);
                tmpparams.put("rows", expr2);
                tmpparams.put("cols", new LiteralOp(1L));
                if (in.length == 4) {
                    tmpparams.put("pdf", expr3);
                    Hop seed = this.processExpression(in[3], null, hops);
                    tmpparams.put("seed", seed);
                } else if (in.length == 3) {
                    if (expr3.getValueType() == Expression.ValueType.BOOLEAN) {
                        tmpparams.put("pdf", expr3);
                        tmpparams.put("seed", new LiteralOp(-1L));
                    } else {
                        if (expr3.getValueType() != Expression.ValueType.INT) throw new HopsException("Invalid input type " + (Object)((Object)expr3.getValueType()) + " in sample().");
                        tmpparams.put("pdf", new LiteralOp(false));
                        tmpparams.put("seed", expr3);
                    }
                } else if (in.length == 2) {
                    tmpparams.put("pdf", new LiteralOp(false));
                    tmpparams.put("seed", new LiteralOp(-1L));
                }
                currBuiltinOp = new DataGenOp(Hop.DataGenMethod.SAMPLE, target, tmpparams);
                break;
            }
            case SOLVE: {
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp2.SOLVE, expr, expr2);
                break;
            }
            case INVERSE: 
            case CHOLESKY: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Hop.OpOp1.valueOf(source.getOpCode().name()), expr);
                break;
            }
            case OUTER: {
                if (!(expr3 instanceof LiteralOp)) {
                    throw new HopsException("Operator for outer builtin function must be a constant: " + expr3);
                }
                Hop.OpOp2 op = Hop.getOpOp2ForOuterVectorOperation(((LiteralOp)expr3).getStringValue());
                if (op == null) {
                    throw new HopsException("Unsupported outer vector binary operation: " + ((LiteralOp)expr3).getStringValue());
                }
                currBuiltinOp = new BinaryOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), op, expr, expr2);
                ((BinaryOp)currBuiltinOp).setOuterVectorOperation(true);
                currBuiltinOp.refreshSizeInformation();
                break;
            }
            case BIASADD: 
            case BIASMULT: {
                ArrayList<Hop> inHops1 = new ArrayList<Hop>();
                inHops1.add(expr);
                inHops1.add(expr2);
                currBuiltinOp = new DnnOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOpDnn.valueOf(source.getOpCode().name()), inHops1);
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case AVG_POOL: 
            case MAX_POOL: {
                currBuiltinOp = new DnnOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOpDnn.valueOf(source.getOpCode().name()), this.getALHopsForPoolingForwardIM2COL(expr, source, 1, hops));
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case AVG_POOL_BACKWARD: 
            case MAX_POOL_BACKWARD: {
                currBuiltinOp = new DnnOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOpDnn.valueOf(source.getOpCode().name()), this.getALHopsForConvOpPoolingCOL2IM(expr, source, 1, hops));
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case CONV2D: 
            case CONV2D_BACKWARD_FILTER: 
            case CONV2D_BACKWARD_DATA: {
                currBuiltinOp = new DnnOp(target.getName(), Expression.DataType.MATRIX, target.getValueType(), Hop.OpOpDnn.valueOf(source.getOpCode().name()), this.getALHopsForConvOp(expr, source, 1, hops));
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            default: {
                throw new ParseException("Unsupported builtin function type: " + (Object)((Object)source.getOpCode()));
            }
        }
        boolean bl = isConvolution = source.getOpCode() == Expression.BuiltinFunctionOp.CONV2D || source.getOpCode() == Expression.BuiltinFunctionOp.CONV2D_BACKWARD_DATA || source.getOpCode() == Expression.BuiltinFunctionOp.CONV2D_BACKWARD_FILTER || source.getOpCode() == Expression.BuiltinFunctionOp.MAX_POOL || source.getOpCode() == Expression.BuiltinFunctionOp.MAX_POOL_BACKWARD || source.getOpCode() == Expression.BuiltinFunctionOp.AVG_POOL || source.getOpCode() == Expression.BuiltinFunctionOp.AVG_POOL_BACKWARD;
        if (!isConvolution) {
            this.setIdentifierParams(currBuiltinOp, source.getOutput());
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop[] processAllExpressions(Expression[] expr, HashMap<String, Hop> hops) {
        Hop[] ret = new Hop[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            ret[i] = this.processExpression(expr[i], null, hops);
        }
        return ret;
    }

    private static void setBlockSizeAndRefreshSizeInfo(Hop in, Hop out) {
        out.setOutputBlocksizes(in.getRowsInBlock(), in.getColsInBlock());
        out.refreshSizeInformation();
        HopRewriteUtils.copyLineNumbers(in, out);
    }

    private ArrayList<Hop> getALHopsForConvOpPoolingCOL2IM(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        for (int i = skip; i < allExpr.length; ++i) {
            if (i == 11) {
                ret.add(this.processExpression(allExpr[7], null, hops));
                continue;
            }
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    private ArrayList<Hop> getALHopsForPoolingForwardIM2COL(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        if (skip != 1) {
            throw new ParseException("Unsupported skip");
        }
        Expression numChannels = allExpr[6];
        for (int i = skip; i < allExpr.length; ++i) {
            if (i == 10) {
                ret.add(this.processExpression(numChannels, null, hops));
                continue;
            }
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    private ArrayList<Hop> getALHopsForConvOpPoolingIM2COL(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        int numImgIndex = -1;
        if (skip == 1) {
            numImgIndex = 5;
        } else if (skip == 2) {
            numImgIndex = 6;
        } else {
            throw new ParseException("Unsupported skip");
        }
        for (int i = skip; i < allExpr.length; ++i) {
            if (i == numImgIndex) {
                Expression numImg = allExpr[numImgIndex];
                Expression numChannels = allExpr[numImgIndex + 1];
                BinaryExpression tmp = new BinaryExpression(Expression.BinaryOp.MULT, numImg);
                tmp.setLeft(numImg);
                tmp.setRight(numChannels);
                ret.add(this.processTempIntExpression(tmp, hops));
                ret.add(this.processExpression(new IntIdentifier(1L, (ParseInfo)numImg), null, hops));
                ++i;
                continue;
            }
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    private ArrayList<Hop> getALHopsForConvOp(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        for (int i = skip; i < allExpr.length; ++i) {
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    public void setIdentifierParams(Hop h, Identifier id) {
        if (id.getDim1() >= 0L) {
            h.setDim1(id.getDim1());
        }
        if (id.getDim2() >= 0L) {
            h.setDim2(id.getDim2());
        }
        if (id.getNnz() >= 0L) {
            h.setNnz(id.getNnz());
        }
        h.setRowsInBlock(id.getRowsInBlock());
        h.setColsInBlock(id.getColumnsInBlock());
    }

    private boolean prepareReadAfterWrite(DMLProgram prog, HashMap<String, DataIdentifier> pWrites) {
        boolean ret = false;
        for (StatementBlock sb : prog.getStatementBlocks()) {
            ret |= this.prepareReadAfterWrite(sb, pWrites);
        }
        return ret;
    }

    private boolean prepareReadAfterWrite(StatementBlock sb, HashMap<String, DataIdentifier> pWrites) {
        boolean ret = false;
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            for (StatementBlock csb : wstmt.getBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock csb : istmt.getIfBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
            for (StatementBlock csb : istmt.getElseBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else {
            for (Statement s : sb.getStatements()) {
                DataExpression dexpr;
                DataIdentifier di;
                String pfname;
                if (s instanceof OutputStatement) {
                    OutputStatement os = (OutputStatement)s;
                    pfname = os.getExprParam("iofilename").toString();
                    di = (DataIdentifier)os.getSource().getOutput();
                    pWrites.put(pfname, di);
                    continue;
                }
                if (!(s instanceof AssignmentStatement) || !(((AssignmentStatement)s).getSource() instanceof DataExpression) || !(dexpr = (DataExpression)((AssignmentStatement)s).getSource()).isRead() || !pWrites.containsKey(pfname = dexpr.getVarParam("iofilename").toString()) || pfname.trim().isEmpty()) continue;
                di = pWrites.get(pfname);
                Expression.FormatType ft = di.getFormatType() != null ? di.getFormatType() : Expression.FormatType.TEXT;
                dexpr.addVarParam("format", new StringIdentifier(ft.toString(), di));
                if (di.getDim1() >= 0L) {
                    dexpr.addVarParam("rows", new IntIdentifier(di.getDim1(), (ParseInfo)di));
                }
                if (di.getDim2() >= 0L) {
                    dexpr.addVarParam("cols", new IntIdentifier(di.getDim2(), (ParseInfo)di));
                }
                if (di.getValueType() != Expression.ValueType.UNKNOWN) {
                    dexpr.addVarParam("value_type", new StringIdentifier(di.getValueType().toString(), di));
                }
                if (di.getDataType() != Expression.DataType.UNKNOWN) {
                    dexpr.addVarParam("data_type", new StringIdentifier(di.getDataType().toString(), di));
                }
                ret = true;
            }
        }
        return ret;
    }
}

