/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class CPInstruction
extends Instruction {
    protected final CPType _cptype;
    protected final Operator _optr;
    protected final boolean _requiresLabelUpdate;
    public static final String MISC_TIMER_GET_SPARSE_MB = "aqrs";
    public static final String MISC_TIMER_GET_DENSE_MB = "aqrd";
    public static final String MISC_TIMER_ACQ_MODIFY_SPARSE_MB = "aqms";
    public static final String MISC_TIMER_ACQ_MODIFY_DENSE_MB = "aqmd";
    public static final String MISC_TIMER_RELEASE_INPUT_MB = "rlsi";
    public static final String MISC_TIMER_RELEASE_EVICTION = "rlsev";
    public static final String MISC_TIMER_RELEASE_BUFF_WRITE = "rlswr";
    public static final String MISC_TIMER_SPARSE_TO_DENSE = "s2d";
    public static final String MISC_TIMER_DENSE_TO_SPARSE = "d2s";
    public static final String MISC_TIMER_RECOMPUTE_NNZ = "rnnz";
    public static final String MISC_TIMER_CSR_LIX_COPY = "csrlix";
    public static final String MISC_TIMER_LIX_COPY = "lixcp";

    protected CPInstruction(CPType type, String opcode, String istr) {
        this(type, null, opcode, istr);
    }

    protected CPInstruction(CPType type, Operator op, String opcode, String istr) {
        this._cptype = type;
        this._optr = op;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    @Override
    public Instruction.IType getType() {
        return Instruction.IType.CONTROL_PROGRAM;
    }

    public CPType getCPInstructionType() {
        return this._cptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = RunMRJobs.updateLabels(tmp.toString(), ec.getVariables());
            tmp = CPInstructionParser.parseSingleInstruction(updInst);
        }
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1);

    public static enum CPType {
        AggregateUnary,
        AggregateBinary,
        AggregateTernary,
        Unary,
        Binary,
        Ternary,
        Quaternary,
        BuiltinNary,
        Ctable,
        MultiReturnParameterizedBuiltin,
        ParameterizedBuiltin,
        MultiReturnBuiltin,
        Builtin,
        Reorg,
        Variable,
        External,
        Append,
        Rand,
        QSort,
        QPick,
        MatrixIndexing,
        MMTSJ,
        PMMJ,
        MMChain,
        MatrixReshape,
        Partition,
        Compression,
        SpoofFused,
        StringInit,
        CentralMoment,
        Covariance,
        UaggOuterChain,
        Dnn;

    }
}

