/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.mlcontext.MLContext;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.api.mlcontext.ScriptExecutor;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.Statement;

public class GenerateClassesForMLContext {
    public static final String SOURCE = "scripts";
    public static final String DESTINATION = "target/classes";
    public static final String BASE_DEST_PACKAGE = "org.apache.sysml";
    public static final String CONVENIENCE_BASE_DEST_PACKAGE = "org.apache.sysml.api.mlcontext.convenience";
    public static final String PATH_TO_MLCONTEXT_CLASS = "org/apache/sysml/api/mlcontext/MLContext.class";
    public static final String PATH_TO_MLRESULTS_CLASS = "org/apache/sysml/api/mlcontext/MLResults.class";
    public static final String PATH_TO_SCRIPT_CLASS = "org/apache/sysml/api/mlcontext/Script.class";
    public static final String PATH_TO_SCRIPTTYPE_CLASS = "org/apache/sysml/api/mlcontext/ScriptType.class";
    public static final String PATH_TO_MATRIX_CLASS = "org/apache/sysml/api/mlcontext/Matrix.class";
    public static final String PATH_TO_FRAME_CLASS = "org/apache/sysml/api/mlcontext/Frame.class";
    public static String source = "scripts";
    public static String destination = "target/classes";
    public static boolean skipStagingDir = true;
    public static boolean skipPerfTestDir = true;
    public static boolean skipObsoleteDir = true;
    public static boolean skipCompareBackendsDir = true;

    public static void main(String[] args) throws Throwable {
        if (args.length == 2) {
            source = args[0];
            destination = args[1];
        } else if (args.length == 1) {
            source = args[0];
        }
        try {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.WARN);
            DMLScript.VALIDATOR_IGNORE_ISSUES = true;
            System.out.println("************************************");
            System.out.println("**** MLContext Class Generation ****");
            System.out.println("************************************");
            System.out.println("Source: " + source);
            System.out.println("Destination: " + destination);
            GenerateClassesForMLContext.makeCtClasses();
            GenerateClassesForMLContext.recurseDirectoriesForClassGeneration(source);
            String fullDirClassName = GenerateClassesForMLContext.recurseDirectoriesForConvenienceClassGeneration(source);
            GenerateClassesForMLContext.addConvenienceMethodsToMLContext(source, fullDirClassName);
        }
        finally {
            DMLScript.VALIDATOR_IGNORE_ISSUES = false;
        }
    }

    public static void makeCtClasses() {
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.makeClass((InputStream)new FileInputStream(new File(destination + File.separator + PATH_TO_MLCONTEXT_CLASS)));
            pool.makeClass((InputStream)new FileInputStream(new File(destination + File.separator + PATH_TO_MLRESULTS_CLASS)));
            pool.makeClass((InputStream)new FileInputStream(new File(destination + File.separator + PATH_TO_SCRIPT_CLASS)));
            pool.makeClass((InputStream)new FileInputStream(new File(destination + File.separator + PATH_TO_SCRIPTTYPE_CLASS)));
            pool.makeClass((InputStream)new FileInputStream(new File(destination + File.separator + PATH_TO_MATRIX_CLASS)));
            pool.makeClass((InputStream)new FileInputStream(new File(destination + File.separator + PATH_TO_FRAME_CLASS)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void addConvenienceMethodsToMLContext(String source, String fullDirClassName) {
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass ctMLContext = pool.get(MLContext.class.getName());
            CtClass dirClass = pool.get(fullDirClassName);
            String methodName = GenerateClassesForMLContext.convertFullClassNameToConvenienceMethodName(fullDirClassName);
            System.out.println("Adding " + methodName + "() to " + ctMLContext.getName());
            String methodBody = "{ " + fullDirClassName + " z = new " + fullDirClassName + "(); return z; }";
            CtMethod ctMethod = CtNewMethod.make((int)1, (CtClass)dirClass, (String)methodName, null, null, (String)methodBody, (CtClass)ctMLContext);
            ctMLContext.addMethod(ctMethod);
            GenerateClassesForMLContext.addPackageConvenienceMethodsToMLContext(source, ctMLContext);
            ctMLContext.writeFile(destination);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    public static void addPackageConvenienceMethodsToMLContext(String dirPath, CtClass ctMLContext) {
        try {
            File[] subdirs;
            if (!SOURCE.equalsIgnoreCase(dirPath)) {
                return;
            }
            File dir = new File(dirPath);
            for (File subdir : subdirs = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            })) {
                String subDirPath = dirPath + File.separator + subdir.getName();
                if (GenerateClassesForMLContext.skipDir(subdir, false)) continue;
                String fullSubDirClassName = GenerateClassesForMLContext.dirPathToFullDirClassName(subDirPath);
                ClassPool pool = ClassPool.getDefault();
                CtClass subDirClass = pool.get(fullSubDirClassName);
                String subDirName = subdir.getName();
                subDirName = subDirName.replaceAll("-", "_");
                subDirName = subDirName.toLowerCase();
                System.out.println("Adding " + subDirName + "() to " + ctMLContext.getName());
                String methodBody = "{ " + fullSubDirClassName + " z = new " + fullSubDirClassName + "(); return z; }";
                CtMethod ctMethod = CtNewMethod.make((int)1, (CtClass)subDirClass, (String)subDirName, null, null, (String)methodBody, (CtClass)ctMLContext);
                ctMLContext.addMethod(ctMethod);
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    public static String convertFullClassNameToConvenienceMethodName(String fullDirClassName) {
        String m = fullDirClassName;
        m = m.substring(m.lastIndexOf(".") + 1);
        m = m.toLowerCase();
        return m;
    }

    public static String recurseDirectoriesForConvenienceClassGeneration(String dirPath) {
        try {
            File[] scriptFiles;
            File[] subdirs;
            File dir = new File(dirPath);
            String fullDirClassName = GenerateClassesForMLContext.dirPathToFullDirClassName(dirPath);
            System.out.println("Generating Class: " + fullDirClassName);
            ClassPool pool = ClassPool.getDefault();
            CtClass ctDir = pool.makeClass(fullDirClassName);
            for (File subdir : subdirs = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            })) {
                String subDirPath = dirPath + File.separator + subdir.getName();
                if (GenerateClassesForMLContext.skipDir(subdir, false)) continue;
                String fullSubDirClassName = GenerateClassesForMLContext.recurseDirectoriesForConvenienceClassGeneration(subDirPath);
                CtClass subDirClass = pool.get(fullSubDirClassName);
                String subDirName = subdir.getName();
                subDirName = subDirName.replaceAll("-", "_");
                subDirName = subDirName.toLowerCase();
                System.out.println("Adding " + subDirName + "() to " + fullDirClassName);
                String methodBody = "{ " + fullSubDirClassName + " z = new " + fullSubDirClassName + "(); return z; }";
                CtMethod ctMethod = CtNewMethod.make((int)1, (CtClass)subDirClass, (String)subDirName, null, null, (String)methodBody, (CtClass)ctDir);
                ctDir.addMethod(ctMethod);
            }
            for (File scriptFile : scriptFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".dml") || name.toLowerCase().endsWith(".pydml");
                }
            })) {
                String scriptFilePath = scriptFile.getPath();
                String fullScriptClassName = "org.apache.sysml." + GenerateClassesForMLContext.scriptFilePathToFullClassNameNoBase(scriptFilePath);
                CtClass scriptClass = pool.get(fullScriptClassName);
                String methodName = GenerateClassesForMLContext.scriptFilePathToSimpleClassName(scriptFilePath);
                String methodBody = "{ " + fullScriptClassName + " z = new " + fullScriptClassName + "(); return z; }";
                CtMethod ctMethod = CtNewMethod.make((int)1, (CtClass)scriptClass, (String)methodName, null, null, (String)methodBody, (CtClass)ctDir);
                ctDir.addMethod(ctMethod);
            }
            ctDir.writeFile(destination);
            return fullDirClassName;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String dirPathToFullDirClassName(String dirPath) {
        if (!dirPath.contains(File.separator)) {
            String c = dirPath;
            c = c.replace("-", "_");
            c = c.substring(0, 1).toUpperCase() + c.substring(1);
            c = "org.apache.sysml.api.mlcontext.convenience." + c;
            return c;
        }
        String p = dirPath;
        p = p.substring(0, p.lastIndexOf(File.separator));
        p = p.replace("-", "_");
        p = p.replace(File.separator, ".");
        p = p.toLowerCase();
        String c = dirPath;
        c = c.substring(c.lastIndexOf(File.separator) + 1);
        c = c.replace("-", "_");
        c = c.substring(0, 1).toUpperCase() + c.substring(1);
        return "org.apache.sysml.api.mlcontext.convenience." + p + "." + c;
    }

    public static boolean skipDir(File dir, boolean displayMessage) {
        if ("staging".equalsIgnoreCase(dir.getName()) && skipStagingDir) {
            if (displayMessage) {
                System.out.println("Skipping staging directory: " + dir.getPath());
            }
            return true;
        }
        if ("perftest".equalsIgnoreCase(dir.getName()) && skipPerfTestDir) {
            if (displayMessage) {
                System.out.println("Skipping perftest directory: " + dir.getPath());
            }
            return true;
        }
        if ("obsolete".equalsIgnoreCase(dir.getName()) && skipObsoleteDir) {
            if (displayMessage) {
                System.out.println("Skipping obsolete directory: " + dir.getPath());
            }
            return true;
        }
        if ("compare_backends".equalsIgnoreCase(dir.getName()) && skipCompareBackendsDir) {
            if (displayMessage) {
                System.out.println("Skipping compare_backends directory: " + dir.getPath());
            }
            return true;
        }
        return false;
    }

    public static void recurseDirectoriesForClassGeneration(String dirPath) {
        File[] subdirs;
        File dir = new File(dirPath);
        GenerateClassesForMLContext.iterateScriptFilesInDirectory(dir);
        for (File subdir : subdirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            String subdirpath = dirPath + File.separator + subdir.getName();
            if (GenerateClassesForMLContext.skipDir(subdir, true)) continue;
            GenerateClassesForMLContext.recurseDirectoriesForClassGeneration(subdirpath);
        }
    }

    public static void iterateScriptFilesInDirectory(File dir) {
        File[] scriptFiles;
        for (File scriptFile : scriptFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".dml") || name.toLowerCase().endsWith(".pydml");
            }
        })) {
            String scriptFilePath = scriptFile.getPath();
            GenerateClassesForMLContext.createScriptClass(scriptFilePath);
        }
    }

    public static String scriptFilePathToPackageNoBase(String scriptFilePath) {
        String p = scriptFilePath;
        p = p.substring(0, p.lastIndexOf(File.separator));
        p = p.replace("-", "_");
        p = p.replace(File.separator, ".");
        p = p.toLowerCase();
        return p;
    }

    public static String scriptFilePathToSimpleClassName(String scriptFilePath) {
        String c = scriptFilePath;
        c = c.substring(c.lastIndexOf(File.separator) + 1);
        c = c.replace("-", "_");
        c = c.substring(0, 1).toUpperCase() + c.substring(1);
        c = c.substring(0, c.indexOf("."));
        return c;
    }

    public static String scriptFilePathToFullClassNameNoBase(String scriptFilePath) {
        String p = GenerateClassesForMLContext.scriptFilePathToPackageNoBase(scriptFilePath);
        String c = GenerateClassesForMLContext.scriptFilePathToSimpleClassName(scriptFilePath);
        return p + "." + c;
    }

    public static void createScriptClass(String scriptFilePath) {
        try {
            String fullScriptClassName = "org.apache.sysml." + GenerateClassesForMLContext.scriptFilePathToFullClassNameNoBase(scriptFilePath);
            System.out.println("Generating Class: " + fullScriptClassName);
            ClassPool pool = ClassPool.getDefault();
            CtClass ctNewScript = pool.makeClass(fullScriptClassName);
            CtClass ctScript = pool.get(Script.class.getName());
            ctNewScript.setSuperclass(ctScript);
            CtConstructor ctCon = new CtConstructor(null, ctNewScript);
            ctCon.setBody(GenerateClassesForMLContext.scriptConstructorBody(scriptFilePath));
            ctNewScript.addConstructor(ctCon);
            GenerateClassesForMLContext.addFunctionMethods(scriptFilePath, ctNewScript);
            ctNewScript.writeFile(destination);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }

    public static DMLProgram dmlProgramFromScriptFilePath(String scriptFilePath) {
        String scriptString = GenerateClassesForMLContext.fileToString(scriptFilePath);
        Script script = new Script(scriptString);
        ScriptExecutor se = new ScriptExecutor(){

            @Override
            public MLResults execute(Script script) {
                this.setup(script);
                this.parseScript();
                return null;
            }
        };
        se.execute(script);
        DMLProgram dmlProgram = se.getDmlProgram();
        return dmlProgram;
    }

    public static void addFunctionMethods(String scriptFilePath, CtClass ctNewScript) {
        try {
            DMLProgram dmlProgram = GenerateClassesForMLContext.dmlProgramFromScriptFilePath(scriptFilePath);
            if (dmlProgram == null) {
                System.out.println("Could not generate DML Program for: " + scriptFilePath);
                return;
            }
            HashMap<String, FunctionStatementBlock> defaultNsFsbsMap = dmlProgram.getFunctionStatementBlocks(".defaultNS");
            ArrayList fsbs = new ArrayList();
            fsbs.addAll(defaultNsFsbsMap.values());
            for (FunctionStatementBlock fsb : fsbs) {
                ArrayList<Statement> sts = fsb.getStatements();
                for (Statement st : sts) {
                    if (!(st instanceof FunctionStatement)) continue;
                    FunctionStatement fs = (FunctionStatement)st;
                    String dmlFunctionCall = GenerateClassesForMLContext.generateDmlFunctionCall(scriptFilePath, fs);
                    String functionCallMethod = GenerateClassesForMLContext.generateFunctionCallMethod(scriptFilePath, fs, dmlFunctionCall);
                    CtMethod m = CtNewMethod.make((String)functionCallMethod, (CtClass)ctNewScript);
                    ctNewScript.addMethod(m);
                    GenerateClassesForMLContext.addDescriptionFunctionCallMethod(fs, scriptFilePath, ctNewScript, false);
                    GenerateClassesForMLContext.addDescriptionFunctionCallMethod(fs, scriptFilePath, ctNewScript, true);
                }
            }
        }
        catch (LanguageException e) {
            System.out.println("Could not add function methods for " + ctNewScript.getName());
        }
        catch (CannotCompileException e) {
            System.out.println("Could not add function methods for " + ctNewScript.getName());
        }
        catch (RuntimeException e) {
            System.out.println("Could not add function methods for " + ctNewScript.getName());
        }
    }

    public static void addDescriptionFunctionCallMethod(FunctionStatement fs, String scriptFilePath, CtClass ctNewScript, boolean full) {
        try {
            int bl = fs.getBeginLine();
            int el = fs.getEndLine();
            File f = new File(scriptFilePath);
            List<String> lines = FileUtils.readLines(f);
            int end = el;
            if (!full) {
                for (int i = bl - 1; i < el; ++i) {
                    String line = lines.get(i);
                    if (!line.contains("*/")) continue;
                    end = i + 1;
                    break;
                }
            }
            List<String> sub = lines.subList(bl - 1, end);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sub.size(); ++i) {
                String line = sub.get(i);
                String escapeLine = StringEscapeUtils.escapeJava(line);
                sb.append(escapeLine);
                sb.append("\\n");
            }
            String functionString = sb.toString();
            String docFunctionCallMethod = GenerateClassesForMLContext.generateDescriptionFunctionCallMethod(fs, functionString, full);
            CtMethod m = CtNewMethod.make((String)docFunctionCallMethod, (CtClass)ctNewScript);
            ctNewScript.addMethod(m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    public static String generateDescriptionFunctionCallMethod(FunctionStatement fs, String functionString, boolean full) {
        StringBuilder sb = new StringBuilder();
        sb.append("public String ");
        sb.append(fs.getName());
        if (full) {
            sb.append("__source");
        } else {
            sb.append("__docs");
        }
        sb.append("() {\n");
        sb.append("String docString = \"" + functionString + "\";\n");
        sb.append("return docString;\n");
        sb.append("}\n");
        return sb.toString();
    }

    public static String getParamTypeAsString(DataIdentifier param) {
        Expression.DataType dt = param.getDataType();
        Expression.ValueType vt = param.getValueType();
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.INT) {
            return "long";
        }
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.DOUBLE) {
            return "double";
        }
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.BOOLEAN) {
            return "boolean";
        }
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.STRING) {
            return "String";
        }
        if (dt == Expression.DataType.MATRIX) {
            return "org.apache.sysml.api.mlcontext.Matrix";
        }
        if (dt == Expression.DataType.FRAME) {
            return "org.apache.sysml.api.mlcontext.Frame";
        }
        return null;
    }

    public static String getSimpleParamTypeAsString(DataIdentifier param) {
        Expression.DataType dt = param.getDataType();
        Expression.ValueType vt = param.getValueType();
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.INT) {
            return "long";
        }
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.DOUBLE) {
            return "double";
        }
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.BOOLEAN) {
            return "boolean";
        }
        if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.STRING) {
            return "String";
        }
        if (dt == Expression.DataType.MATRIX) {
            return "Matrix";
        }
        if (dt == Expression.DataType.FRAME) {
            return "Frame";
        }
        return null;
    }

    public static String getFullFunctionOutputClassName(String scriptFilePath, FunctionStatement fs) {
        String p = scriptFilePath;
        p = p.replace("-", "_");
        p = p.replace(File.separator, ".");
        p = p.toLowerCase();
        p = p.substring(0, p.lastIndexOf("."));
        String c = fs.getName();
        c = c.substring(0, 1).toUpperCase() + c.substring(1);
        c = c + "_output";
        String functionOutputClassName = "org.apache.sysml." + p + "." + c;
        return functionOutputClassName;
    }

    public static void createFunctionOutputClass(String scriptFilePath, FunctionStatement fs) {
        try {
            DataIdentifier oparam;
            int i;
            ArrayList<DataIdentifier> oparams = fs.getOutputParams();
            if (oparams.size() == 0 || oparams.size() == 1) {
                return;
            }
            String fullFunctionOutputClassName = GenerateClassesForMLContext.getFullFunctionOutputClassName(scriptFilePath, fs);
            System.out.println("Generating Class: " + fullFunctionOutputClassName);
            ClassPool pool = ClassPool.getDefault();
            CtClass ctFuncOut = pool.makeClass(fullFunctionOutputClassName);
            for (int i2 = 0; i2 < oparams.size(); ++i2) {
                DataIdentifier oparam2 = oparams.get(i2);
                String type = GenerateClassesForMLContext.getParamTypeAsString(oparam2);
                String name = oparam2.getName();
                String fstring = "public " + type + " " + name + ";";
                CtField field = CtField.make((String)fstring, (CtClass)ctFuncOut);
                ctFuncOut.addField(field);
            }
            String simpleFuncOutClassName = fullFunctionOutputClassName.substring(fullFunctionOutputClassName.lastIndexOf(".") + 1);
            StringBuilder con = new StringBuilder();
            con.append("public " + simpleFuncOutClassName + "(");
            for (i = 0; i < oparams.size(); ++i) {
                if (i > 0) {
                    con.append(", ");
                }
                oparam = oparams.get(i);
                String type = GenerateClassesForMLContext.getParamTypeAsString(oparam);
                String name = oparam.getName();
                con.append(type + " " + name);
            }
            con.append(") {\n");
            for (i = 0; i < oparams.size(); ++i) {
                oparam = oparams.get(i);
                String name = oparam.getName();
                con.append("this." + name + "=" + name + ";\n");
            }
            con.append("}\n");
            String cstring = con.toString();
            CtConstructor ctCon = CtNewConstructor.make((String)cstring, (CtClass)ctFuncOut);
            ctFuncOut.addConstructor(ctCon);
            StringBuilder s = new StringBuilder();
            s.append("public String toString(){\n");
            s.append("StringBuilder sb = new StringBuilder();\n");
            for (int i3 = 0; i3 < oparams.size(); ++i3) {
                DataIdentifier oparam3 = oparams.get(i3);
                String name = oparam3.getName();
                s.append("sb.append(\"" + name + " (" + GenerateClassesForMLContext.getSimpleParamTypeAsString(oparam3) + "): \" + " + name + " + \"\\n\");\n");
            }
            s.append("String str = sb.toString();\nreturn str;\n");
            s.append("}\n");
            String toStr = s.toString();
            CtMethod toStrMethod = CtNewMethod.make((String)toStr, (CtClass)ctFuncOut);
            ctFuncOut.addMethod(toStrMethod);
            ctFuncOut.writeFile(destination);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String generateFunctionCallMethod(String scriptFilePath, FunctionStatement fs, String dmlFunctionCall) {
        DataIdentifier outputParam;
        String name;
        DataIdentifier inputParam;
        int i;
        GenerateClassesForMLContext.createFunctionOutputClass(scriptFilePath, fs);
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        ArrayList<DataIdentifier> oparams = fs.getOutputParams();
        if (oparams.size() == 0) {
            sb.append("void");
        } else if (oparams.size() == 1) {
            DataIdentifier oparam = oparams.get(0);
            String type = GenerateClassesForMLContext.getParamTypeAsString(oparam);
            sb.append(type);
        } else {
            String fullFunctionOutputClassName = GenerateClassesForMLContext.getFullFunctionOutputClassName(scriptFilePath, fs);
            sb.append(fullFunctionOutputClassName);
        }
        sb.append(" ");
        sb.append(fs.getName());
        sb.append("(");
        ArrayList<DataIdentifier> inputParams = fs.getInputParams();
        for (i = 0; i < inputParams.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            inputParam = inputParams.get(i);
            sb.append("Object ");
            sb.append(inputParam.getName());
        }
        sb.append(") {\n");
        sb.append("String scriptString = \"" + dmlFunctionCall + "\";\n");
        sb.append("org.apache.sysml.api.mlcontext.Script script = new org.apache.sysml.api.mlcontext.Script(scriptString);\n");
        if (inputParams.size() > 0 || oparams.size() > 0) {
            sb.append("script");
        }
        for (i = 0; i < inputParams.size(); ++i) {
            inputParam = inputParams.get(i);
            name = inputParam.getName();
            sb.append(".in(\"" + name + "\", " + name + ")");
        }
        for (i = 0; i < oparams.size(); ++i) {
            outputParam = oparams.get(i);
            name = outputParam.getName();
            sb.append(".out(\"" + name + "\")");
        }
        if (inputParams.size() > 0 || oparams.size() > 0) {
            sb.append(";\n");
        }
        sb.append("org.apache.sysml.api.mlcontext.MLResults results = script.execute();\n");
        if (oparams.size() == 0) {
            sb.append("return;\n");
        } else if (oparams.size() == 1) {
            DataIdentifier o = oparams.get(0);
            Expression.DataType dt = o.getDataType();
            Expression.ValueType vt = o.getValueType();
            if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.INT) {
                sb.append("long res = results.getLong(\"" + o.getName() + "\");\nreturn res;\n");
            } else if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.DOUBLE) {
                sb.append("double res = results.getDouble(\"" + o.getName() + "\");\nreturn res;\n");
            } else if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.BOOLEAN) {
                sb.append("boolean res = results.getBoolean(\"" + o.getName() + "\");\nreturn res;\n");
            } else if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.STRING) {
                sb.append("String res = results.getString(\"" + o.getName() + "\");\nreturn res;\n");
            } else if (dt == Expression.DataType.MATRIX) {
                sb.append("org.apache.sysml.api.mlcontext.Matrix res = results.getMatrix(\"" + o.getName() + "\");\nreturn res;\n");
            } else if (dt == Expression.DataType.FRAME) {
                sb.append("org.apache.sysml.api.mlcontext.Frame res = results.getFrame(\"" + o.getName() + "\");\nreturn res;\n");
            }
        } else {
            for (i = 0; i < oparams.size(); ++i) {
                outputParam = oparams.get(i);
                name = outputParam.getName().toLowerCase();
                String type = GenerateClassesForMLContext.getParamTypeAsString(outputParam);
                Expression.DataType dt = outputParam.getDataType();
                Expression.ValueType vt = outputParam.getValueType();
                if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.INT) {
                    sb.append(type + " " + name + " = results.getLong(\"" + outputParam.getName() + "\");\n");
                    continue;
                }
                if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.DOUBLE) {
                    sb.append(type + " " + name + " = results.getDouble(\"" + outputParam.getName() + "\");\n");
                    continue;
                }
                if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.BOOLEAN) {
                    sb.append(type + " " + name + " = results.getBoolean(\"" + outputParam.getName() + "\");\n");
                    continue;
                }
                if (dt == Expression.DataType.SCALAR && vt == Expression.ValueType.STRING) {
                    sb.append(type + " " + name + " = results.getString(\"" + outputParam.getName() + "\");\n");
                    continue;
                }
                if (dt == Expression.DataType.MATRIX) {
                    sb.append(type + " " + name + " = results.getMatrix(\"" + outputParam.getName() + "\");\n");
                    continue;
                }
                if (dt != Expression.DataType.FRAME) continue;
                sb.append(type + " " + name + " = results.getFrame(\"" + outputParam.getName() + "\");\n");
            }
            String ffocn = GenerateClassesForMLContext.getFullFunctionOutputClassName(scriptFilePath, fs);
            sb.append(ffocn + " res = new " + ffocn + "(");
            for (int i2 = 0; i2 < oparams.size(); ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                DataIdentifier outputParam2 = oparams.get(i2);
                String name2 = outputParam2.getName().toLowerCase();
                sb.append(name2);
            }
            sb.append(");\nreturn res;\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static String generateFunctionCallMethodMLResults(String scriptFilePath, FunctionStatement fs, String dmlFunctionCall) {
        String name;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("public org.apache.sysml.api.mlcontext.MLResults ");
        sb.append(fs.getName());
        sb.append("(");
        ArrayList<DataIdentifier> inputParams = fs.getInputParams();
        for (int i2 = 0; i2 < inputParams.size(); ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            DataIdentifier inputParam = inputParams.get(i2);
            sb.append("Object ");
            sb.append(inputParam.getName());
        }
        sb.append(") {\n");
        sb.append("String scriptString = \"" + dmlFunctionCall + "\";\n");
        sb.append("org.apache.sysml.api.mlcontext.Script script = new org.apache.sysml.api.mlcontext.Script(scriptString);\n");
        ArrayList<DataIdentifier> outputParams = fs.getOutputParams();
        if (inputParams.size() > 0 || outputParams.size() > 0) {
            sb.append("script");
        }
        for (i = 0; i < inputParams.size(); ++i) {
            DataIdentifier inputParam = inputParams.get(i);
            name = inputParam.getName();
            sb.append(".in(\"" + name + "\", " + name + ")");
        }
        for (i = 0; i < outputParams.size(); ++i) {
            DataIdentifier outputParam = outputParams.get(i);
            name = outputParam.getName();
            sb.append(".out(\"" + name + "\")");
        }
        if (inputParams.size() > 0 || outputParams.size() > 0) {
            sb.append(";\n");
        }
        sb.append("org.apache.sysml.api.mlcontext.MLResults results = script.execute();\n");
        sb.append("return results;\n");
        sb.append("}\n");
        return sb.toString();
    }

    public static String generateDmlFunctionCall(String scriptFilePath, FunctionStatement fs) {
        StringBuilder sb = new StringBuilder();
        sb.append("source('" + scriptFilePath + "') as mlcontextns;");
        ArrayList<DataIdentifier> outputParams = fs.getOutputParams();
        if (outputParams.size() == 0) {
            sb.append("mlcontextns::");
        }
        if (outputParams.size() == 1) {
            DataIdentifier outputParam = outputParams.get(0);
            sb.append(outputParam.getName());
            sb.append(" = mlcontextns::");
        } else if (outputParams.size() > 1) {
            sb.append("[");
            for (int i = 0; i < outputParams.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(outputParams.get(i).getName());
            }
            sb.append("] = mlcontextns::");
        }
        sb.append(fs.getName());
        sb.append("(");
        ArrayList<DataIdentifier> inputParams = fs.getInputParams();
        for (int i = 0; i < inputParams.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            DataIdentifier inputParam = inputParams.get(i);
            sb.append(inputParam.getName());
        }
        sb.append(");");
        return sb.toString();
    }

    public static String fileToString(String filePath) {
        try {
            int n;
            File f = new File(filePath);
            FileReader fr = new FileReader(f);
            StringBuilder sb = new StringBuilder();
            char[] charArray = new char[1024];
            while ((n = fr.read(charArray)) > 0) {
                sb.append(charArray, 0, n);
            }
            fr.close();
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String scriptConstructorBody(String scriptFilePath) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("String scriptFilePath = \"" + scriptFilePath + "\";");
        sb.append("java.io.InputStream is = org.apache.sysml.api.mlcontext.Script.class.getResourceAsStream(\"/\"+scriptFilePath);");
        sb.append("java.io.InputStreamReader isr = new java.io.InputStreamReader(is);");
        sb.append("int n;");
        sb.append("char[] charArray = new char[1024];");
        sb.append("StringBuilder s = new StringBuilder();");
        sb.append("try {");
        sb.append("  while ((n = isr.read(charArray)) > 0) {");
        sb.append("    s.append(charArray, 0, n);");
        sb.append("  }");
        sb.append("} catch (java.io.IOException e) {");
        sb.append("  e.printStackTrace();");
        sb.append("}");
        sb.append("setScriptString(s.toString());");
        sb.append("}");
        return sb.toString();
    }
}

