/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.common;

import java.util.EnumSet;
import java.util.HashMap;
import org.apache.sysds.common.Types;

public enum Builtins {
    ABS("abs", false),
    ACOS("acos", false),
    ASIN("asin", false),
    ATAN("atan", false),
    AVG_POOL("avg_pool", false),
    AVG_POOL_BACKWARD("avg_pool_backward", false),
    BATCH_NORM2D("batch_norm2d", false, Types.ReturnType.MULTI_RETURN),
    BATCH_NORM2D_BACKWARD("batch_norm2d_backward", false, Types.ReturnType.MULTI_RETURN),
    BIASADD("bias_add", false),
    BIASMULT("bias_multiply", false),
    BITWAND("bitwAnd", false),
    BITWOR("bitwOr", false),
    BITWXOR("bitwXor", false),
    BITWSHIFTL("bitwShiftL", false),
    BITWSHIFTR("bitwShiftR", false),
    CAST_AS_SCALAR("as.scalar", "castAsScalar", false),
    CAST_AS_MATRIX("as.matrix", false),
    CAST_AS_FRAME("as.frame", false),
    CAST_AS_DOUBLE("as.double", false),
    CAST_AS_INT("as.integer", false),
    CAST_AS_BOOLEAN("as.logical", "as.boolean", false),
    CBIND("cbind", "append", false),
    CEIL("ceil", "ceiling", false),
    COLMAX("colMaxs", false),
    COLMEAN("colMeans", false),
    COLMIN("colMins", false),
    COLNAMES("colnames", false),
    COLPROD("colProds", false),
    COLSD("colSds", false),
    COLSUM("colSums", false),
    COLVAR("colVars", false),
    COMPONENTS("components", true),
    CONV2D("conv2d", false),
    CONV2D_BACKWARD_FILTER("conv2d_backward_filter", false),
    CONV2D_BACKWARD_DATA("conv2d_backward_data", false),
    COS("cos", false),
    COV("cov", false),
    COSH("cosh", false),
    CHOLESKY("cholesky", false),
    CUMMAX("cummax", false),
    CUMMIN("cummin", false),
    CUMPROD("cumprod", false),
    CUMSUM("cumsum", false),
    CUMSUMPROD("cumsumprod", false),
    CONFUSIONMATRIX("confusionMatrix", true),
    COR("cor", true),
    DBSCAN("dbscan", true),
    DETECTSCHEMA("detectSchema", false),
    DIAG("diag", false),
    DISCOVER_FD("discoverFD", true),
    DIST("dist", true),
    DROP_INVALID_TYPE("dropInvalidType", false),
    DROP_INVALID_LENGTH("dropInvalidLength", false),
    EIGEN("eigen", false, Types.ReturnType.MULTI_RETURN),
    EXISTS("exists", false),
    EXECUTE_PIPELINE("executePipeline", true),
    EXP("exp", false),
    EVAL("eval", false),
    FLOOR("floor", false),
    GLM("glm", true),
    GMM("gmm", true),
    GNMF("gnmf", true),
    GRID_SEARCH("gridSearch", true),
    HYPERBAND("hyperband", true),
    IFELSE("ifelse", false),
    IMG_MIRROR("img_mirror", true),
    IMG_BRIGHTNESS("img_brightness", true),
    IMG_CROP("img_crop", true),
    IMPUTE_FD("imputeByFD", true),
    INTERQUANTILE("interQuantile", false),
    INTERSECT("intersect", true),
    INVERSE("inv", "inverse", false),
    IQM("interQuartileMean", false),
    ISNA("is.na", false),
    ISNAN("is.nan", false),
    ISINF("is.infinite", false),
    KMEANS("kmeans", true),
    L2SVM("l2svm", true),
    LENGTH("length", false),
    LINEAGE("lineage", false),
    LIST("list", false),
    LM("lm", true),
    LMCG("lmCG", true),
    LMDS("lmDS", true),
    LMPREDICT("lmpredict", true),
    LOG("log", false),
    LSTM("lstm", false, Types.ReturnType.MULTI_RETURN),
    LSTM_BACKWARD("lstm_backward", false, Types.ReturnType.MULTI_RETURN),
    LU("lu", false, Types.ReturnType.MULTI_RETURN),
    MAP("map", false),
    MEAN("mean", "avg", false),
    MICE("mice", true),
    MIN("min", "pmin", false),
    MAX("max", "pmax", false),
    MAX_POOL("max_pool", false),
    MAX_POOL_BACKWARD("max_pool_backward", false),
    MEDIAN("median", false),
    MOMENT("moment", "centralMoment", false),
    MSVM("msvm", true),
    MSVMPREDICT("msvmPredict", true),
    MULTILOGREG("multiLogReg", true),
    MULTILOGREGPREDICT("multiLogRegPredict", true),
    NA_LOCF("na_locf", true),
    NCOL("ncol", false),
    NORMALIZE("normalize", true),
    NROW("nrow", false),
    NAIVEBAYES("naivebayes", true, false),
    OUTER("outer", false),
    OUTLIER("outlier", true, false),
    OUTLIER_SD("outlierBySd", true),
    OUTLIER_IQR("outlierByIQR", true),
    PCA("pca", true),
    PNMF("pnmf", true),
    PPRED("ppred", false),
    PROD("prod", false),
    QR("qr", false, Types.ReturnType.MULTI_RETURN),
    QUANTILE("quantile", false),
    RANGE("range", false),
    RBIND("rbind", false),
    REMOVE("remove", false, Types.ReturnType.MULTI_RETURN),
    REV("rev", false),
    ROUND("round", false),
    ROWINDEXMAX("rowIndexMax", false),
    ROWINDEXMIN("rowIndexMin", false),
    ROWMIN("rowMins", false),
    ROWMAX("rowMaxs", false),
    ROWMEAN("rowMeans", false),
    ROWPROD("rowProds", false),
    ROWSD("rowSds", false),
    ROWSUM("rowSums", false),
    ROWVAR("rowVars", false),
    SAMPLE("sample", false),
    SD("sd", false),
    SEQ("seq", false),
    SIGMOID("sigmoid", true),
    SIGN("sign", false),
    SIN("sin", false),
    SINH("sinh", false),
    STEPLM("steplm", true, Types.ReturnType.MULTI_RETURN),
    SLICEFINDER("slicefinder", true),
    SMOTE("smote", true),
    SOLVE("solve", false),
    SQRT("sqrt", false),
    SUM("sum", false),
    SVD("svd", false, Types.ReturnType.MULTI_RETURN),
    TRANS("t", false),
    TABLE("table", "ctable", false),
    TAN("tan", false),
    TANH("tanh", false),
    TRACE("trace", false),
    TO_ONE_HOT("toOneHot", true),
    TYPEOF("typeof", false),
    COUNT_DISTINCT("countDistinct", false),
    COUNT_DISTINCT_APPROX("countDistinctApprox", false),
    VAR("var", false),
    XOR("xor", false),
    UNIVAR("univar", true),
    WINSORIZE("winsorize", true, false),
    CDF("cdf", false, true),
    GROUPEDAGG("aggregate", "groupedAggregate", false, true),
    INVCDF("icdf", false, true),
    LISTNV("list", false, true),
    LOWER_TRI("lower.tri", false, true),
    ORDER("order", false, true),
    PARAMSERV("paramserv", false, true),
    PCHISQ("pchisq", false, true),
    PEXP("pexp", false, true),
    PF("pf", false, true),
    PNORM("pnorm", false, true),
    PT("pt", false, true),
    QCHISQ("qchisq", false, true),
    QF("qf", false, true),
    QNORM("qnorm", false, true),
    QT("qt", false, true),
    QEXP("qexp", false, true),
    REPLACE("replace", false, true),
    RMEMPTY("removeEmpty", false, true),
    SCALE("scale", true, false),
    TIME("time", false),
    CVLM("cvlm", true, false),
    TOSTRING("toString", false, true),
    TRANSFORMAPPLY("transformapply", false, true),
    TRANSFORMCOLMAP("transformcolmap", false, true),
    TRANSFORMDECODE("transformdecode", false, true),
    TRANSFORMENCODE("transformencode", false, true),
    TRANSFORMMETA("transformmeta", false, true),
    UPPER_TRI("upper.tri", false, true);

    private static final String BUILTIN_DIR = "scripts/builtin/";
    private static final HashMap<String, Builtins> _map;
    private final String _name;
    private final String _alias;
    private final boolean _script;
    private final boolean _parameterized;
    private final Types.ReturnType _retType;

    private Builtins(String name, boolean script) {
        this(name, null, script, false, Types.ReturnType.SINGLE_RETURN);
    }

    private Builtins(String name, boolean script, Types.ReturnType retType) {
        this(name, null, script, false, retType);
    }

    private Builtins(String name, boolean script, boolean parameterized) {
        this(name, null, script, parameterized, Types.ReturnType.SINGLE_RETURN);
    }

    private Builtins(String name, String alias, boolean script) {
        this(name, alias, script, false, Types.ReturnType.SINGLE_RETURN);
    }

    private Builtins(String name, String alias, boolean script, boolean parameterized) {
        this(name, alias, script, parameterized, Types.ReturnType.SINGLE_RETURN);
    }

    private Builtins(String name, String alias, boolean script, boolean parameterized, Types.ReturnType retType) {
        this._name = name;
        this._alias = alias;
        this._script = script;
        this._parameterized = parameterized;
        this._retType = retType;
    }

    public String getName() {
        return this._name;
    }

    public String getAlias() {
        return this._alias;
    }

    public boolean isScript() {
        return this._script;
    }

    public boolean isParameterized() {
        return this._parameterized;
    }

    public boolean isMultiReturn() {
        return this._retType == Types.ReturnType.MULTI_RETURN;
    }

    public static boolean contains(String name, boolean script, boolean parameterized) {
        Builtins tmp = Builtins.get(name);
        return tmp != null && script == tmp.isScript() && parameterized == tmp.isParameterized();
    }

    public static Builtins get(String name) {
        if (name.equals("list")) {
            return LIST;
        }
        return _map.get(name);
    }

    public static Builtins get(String name, boolean params) {
        if (name.equals("list")) {
            return params ? LISTNV : LIST;
        }
        Builtins tmp = Builtins.get(name);
        return tmp != null && params == tmp.isParameterized() ? tmp : null;
    }

    public static String getFilePath(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(BUILTIN_DIR);
        sb.append(name);
        sb.append(".dml");
        return sb.toString();
    }

    public static String getInternalFName(String name, Types.DataType dt) {
        return (dt.isMatrix() ? "m_" : "s_") + name;
    }

    static {
        _map = new HashMap();
        for (Builtins b : EnumSet.allOf(Builtins.class)) {
            _map.put(b.getName(), b);
            if (b.getAlias() == null) continue;
            _map.put(b.getAlias(), b);
        }
    }
}

