/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.spark_project.jetty.io.Connection;
import org.spark_project.jetty.io.EndPoint;
import org.spark_project.jetty.util.Callback;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;
import org.spark_project.jetty.util.thread.NonBlockingThread;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    public static final boolean EXECUTE_ONFILLABLE = true;
    private final List<Connection.Listener> listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final AtomicReference<State> _state = new AtomicReference<State>(IDLE);
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback _readCallback;
    private final boolean _executeOnfillable;
    private int _inputBufferSize = 2048;
    public static final State IDLE = new IdleState();
    public static final State FILL_INTERESTED = new FillInterestedState();
    public static final State FILLING = new FillingState();
    public static final State REFILLING = new RefillingState();
    public static final State FILLING_FILL_INTERESTED = new FillingFillInterestedState("FILLING_FILL_INTERESTED");
    private final Runnable _runOnFillable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                AbstractConnection.this.onFillable();
            }
            finally {
                State state;
                while (!AbstractConnection.this.next(state = (State)AbstractConnection.this._state.get(), state.onFilled())) {
                }
            }
        }
    };

    protected AbstractConnection(EndPoint endp, Executor executor) {
        this(endp, executor, true);
    }

    protected AbstractConnection(EndPoint endp, Executor executor, boolean executeOnfillable) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endp;
        this._executor = executor;
        this._readCallback = new ReadCallback();
        this._executeOnfillable = executeOnfillable;
        this._state.set(IDLE);
    }

    @Override
    public void addListener(Connection.Listener listener) {
        this.listeners.add(listener);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this._inputBufferSize = inputBufferSize;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    protected void failedCallback(final Callback callback, final Throwable x) {
        if (NonBlockingThread.isNonBlockingThread()) {
            try {
                this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.failed(x);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOG.debug(e);
                callback.failed(x);
            }
        } else {
            callback.failed(x);
        }
    }

    public void fillInterested() {
        State state;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {}", this);
        }
        while (!this.next(state = this._state.get(), state.fillInterested())) {
        }
    }

    public void fillInterested(Callback callback) {
        FillingInterestedCallback next2;
        State state;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {}", this);
        }
        while (!((state = this._state.get()) instanceof FillingInterestedCallback && ((FillingInterestedCallback)state)._callback == callback || this.next(state, next2 = new FillingInterestedCallback(callback, state)))) {
        }
    }

    public abstract void onFillable();

    protected void onFillInterestedFailed(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillInterestedFailed {}", this, cause);
        }
        if (this._endPoint.isOpen()) {
            boolean close2 = true;
            if (cause instanceof TimeoutException) {
                close2 = this.onReadTimeout();
            }
            if (close2) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                }
            }
        }
        if (this._endPoint.isOpen()) {
            this.fillInterested();
        }
    }

    protected boolean onReadTimeout() {
        return true;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", this);
        }
        for (Connection.Listener listener : this.listeners) {
            listener.onOpened(this);
        }
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", this);
        }
        for (Connection.Listener listener : this.listeners) {
            listener.onClosed(this);
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public int getMessagesIn() {
        return -1;
    }

    @Override
    public int getMessagesOut() {
        return -1;
    }

    @Override
    public long getBytesIn() {
        return -1L;
    }

    @Override
    public long getBytesOut() {
        return -1L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public String toString() {
        return String.format("%s@%x[%s,%s]", this.getClass().getSimpleName(), this.hashCode(), this._state.get(), this._endPoint);
    }

    public boolean next(State state, State next2) {
        if (next2 == null) {
            return true;
        }
        if (this._state.compareAndSet(state, next2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}-->{} {}", state, next2, this);
            }
            if (next2 != state) {
                next2.onEnter(this);
            }
            return true;
        }
        return false;
    }

    private class ReadCallback
    implements Callback {
        private ReadCallback() {
        }

        @Override
        public void succeeded() {
            State state;
            while (!AbstractConnection.this.next(state = (State)AbstractConnection.this._state.get(), state.onFillable())) {
            }
        }

        @Override
        public void failed(final Throwable x) {
            AbstractConnection.this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    State state;
                    while (!AbstractConnection.this.next(state = (State)AbstractConnection.this._state.get(), state.onFailed())) {
                    }
                    AbstractConnection.this.onFillInterestedFailed(x);
                }
            });
        }

        public String toString() {
            return String.format("AC.ReadCB@%x{%s}", AbstractConnection.this.hashCode(), AbstractConnection.this);
        }
    }

    public class FillingInterestedCallback
    extends NestedState {
        private final Callback _callback;

        FillingInterestedCallback(Callback callback, State nested) {
            super("FILLING_INTERESTED_CALLBACK", nested == FILLING ? REFILLING : nested);
            this._callback = callback;
        }

        @Override
        void onEnter(final AbstractConnection connection) {
            Callback callback = new Callback(){

                @Override
                public void succeeded() {
                    State nested;
                    State state;
                    while ((state = (State)connection._state.get()) instanceof NestedState && !connection.next(state, nested = ((NestedState)state)._nested)) {
                    }
                    FillingInterestedCallback.this._callback.succeeded();
                }

                @Override
                public void failed(Throwable x) {
                    State nested;
                    State state;
                    while ((state = (State)connection._state.get()) instanceof NestedState && !connection.next(state, nested = ((NestedState)state)._nested)) {
                    }
                    FillingInterestedCallback.this._callback.failed(x);
                }
            };
            connection.getEndPoint().fillInterested(callback);
        }
    }

    public class NestedState
    extends State {
        private final State _nested;

        NestedState(State nested) {
            super("NESTED(" + nested + ")");
            this._nested = nested;
        }

        NestedState(String name, State nested) {
            super(name + "(" + nested + ")");
            this._nested = nested;
        }

        @Override
        State fillInterested() {
            return new NestedState(this._nested.fillInterested());
        }

        @Override
        State onFillable() {
            return new NestedState(this._nested.onFillable());
        }

        @Override
        State onFilled() {
            return new NestedState(this._nested.onFilled());
        }
    }

    public static class State {
        private final String _name;

        State(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        void onEnter(AbstractConnection connection) {
        }

        State fillInterested() {
            throw new IllegalStateException(this.toString());
        }

        State onFillable() {
            throw new IllegalStateException(this.toString());
        }

        State onFilled() {
            throw new IllegalStateException(this.toString());
        }

        State onFailed() {
            throw new IllegalStateException(this.toString());
        }
    }

    private static final class FillingState
    extends State {
        private FillingState() {
            super("FILLING");
        }

        @Override
        public void onEnter(AbstractConnection connection) {
            if (connection._executeOnfillable) {
                connection.getExecutor().execute(connection._runOnFillable);
            } else {
                connection._runOnFillable.run();
            }
        }

        @Override
        State fillInterested() {
            return FILLING_FILL_INTERESTED;
        }

        @Override
        public State onFilled() {
            return IDLE;
        }
    }

    private static final class FillingFillInterestedState
    extends State {
        private FillingFillInterestedState(String name) {
            super(name);
        }

        @Override
        State fillInterested() {
            return this;
        }

        @Override
        State onFilled() {
            return FILL_INTERESTED;
        }
    }

    private static final class RefillingState
    extends State {
        private RefillingState() {
            super("REFILLING");
        }

        @Override
        State fillInterested() {
            return FILLING_FILL_INTERESTED;
        }

        @Override
        public State onFilled() {
            return IDLE;
        }
    }

    private static final class FillInterestedState
    extends State {
        private FillInterestedState() {
            super("FILL_INTERESTED");
        }

        @Override
        public void onEnter(AbstractConnection connection) {
            connection.getEndPoint().fillInterested(connection._readCallback);
        }

        @Override
        State fillInterested() {
            return this;
        }

        @Override
        public State onFillable() {
            return FILLING;
        }

        @Override
        State onFailed() {
            return IDLE;
        }
    }

    private static final class IdleState
    extends State {
        private IdleState() {
            super("IDLE");
        }

        @Override
        State fillInterested() {
            return FILL_INTERESTED;
        }
    }
}

