/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public final class BitmapLossy
extends ABitmap {
    private final byte[] _values;
    private final double _scale;

    public BitmapLossy(int numCols, IntArrayList[] offsetsLists, byte[] values, double scale, int rows) {
        super(numCols, offsetsLists, rows);
        this._values = values;
        this._scale = scale;
    }

    public byte[] getValues() {
        return this._values;
    }

    public byte[] getValues(int ix) {
        return Arrays.copyOfRange(this._values, ix * this._numCols, (ix + 1) * this._numCols);
    }

    @Override
    public int getNumNonZerosInOffset(int idx) {
        if (this._numCols == 1) {
            return this._offsetsLists[idx].size();
        }
        int nz = 0;
        for (int i = idx * this._numCols; i < (idx + 1) * this._numCols; ++i) {
            nz += this._values[i] == 0 ? 0 : 1;
        }
        return nz;
    }

    public double getScale() {
        return this._scale;
    }

    @Override
    public int getNumValues() {
        return this._values == null ? 0 : this._values.length / this._numCols;
    }

    @Override
    public IntArrayList getOffsetsList(int ix) {
        return this._offsetsLists[ix];
    }

    @Override
    public long getNumOffsets() {
        long ret = 0L;
        for (IntArrayList offlist : this._offsetsLists) {
            ret += (long)offlist.size();
        }
        return ret;
    }

    @Override
    public int getNumOffsets(int ix) {
        return this._offsetsLists[ix].size();
    }

    @Override
    public void sortValuesByFrequency() {
        throw new NotImplementedException("Not Implemented Sorting of Lossy Bit Map");
    }

    @Override
    public ABitmap.BitmapType getType() {
        return ABitmap.BitmapType.Lossy;
    }

    @Override
    public boolean lossy() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\nValues: " + Arrays.toString(this._values));
        sb.append("\ncolumns:" + this._numCols);
        sb.append("\nScale:  " + this._scale);
        sb.append("\nOffsets:" + Arrays.toString(this._offsetsLists));
        return sb.toString();
    }
}

