/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.FrameIndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ListIndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MatrixIndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.util.IndexRange;

public abstract class IndexingCPInstruction
extends UnaryCPInstruction {
    protected final CPOperand rowLower;
    protected final CPOperand rowUpper;
    protected final CPOperand colLower;
    protected final CPOperand colUpper;

    protected IndexingCPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.MatrixIndexing, null, in, out, opcode, istr);
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    protected IndexingCPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.MatrixIndexing, null, lhsInput, rhsInput, out, opcode, istr);
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    protected IndexRange getIndexRange(ExecutionContext ec) {
        return new IndexRange((int)(ec.getScalarInput(this.rowLower).getLongValue() - 1L), (int)(ec.getScalarInput(this.rowUpper).getLongValue() - 1L), (int)(ec.getScalarInput(this.colLower).getLongValue() - 1L), (int)(ec.getScalarInput(this.colUpper).getLongValue() - 1L));
    }

    public static IndexingCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rightIndex")) {
            if (parts.length == 7) {
                CPOperand in = new CPOperand(parts[1]);
                CPOperand rl = new CPOperand(parts[2]);
                CPOperand ru = new CPOperand(parts[3]);
                CPOperand cl = new CPOperand(parts[4]);
                CPOperand cu = new CPOperand(parts[5]);
                CPOperand out = new CPOperand(parts[6]);
                if (in.getDataType() == Types.DataType.MATRIX) {
                    return new MatrixIndexingCPInstruction(in, rl, ru, cl, cu, out, opcode, str);
                }
                if (in.getDataType() == Types.DataType.FRAME) {
                    return new FrameIndexingCPInstruction(in, rl, ru, cl, cu, out, opcode, str);
                }
                if (in.getDataType() == Types.DataType.LIST) {
                    return new ListIndexingCPInstruction(in, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on matrices, frames, and lists.");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (opcode.equalsIgnoreCase("leftIndex")) {
            if (parts.length == 8) {
                CPOperand lhsInput = new CPOperand(parts[1]);
                CPOperand rhsInput = new CPOperand(parts[2]);
                CPOperand rl = new CPOperand(parts[3]);
                CPOperand ru = new CPOperand(parts[4]);
                CPOperand cl = new CPOperand(parts[5]);
                CPOperand cu = new CPOperand(parts[6]);
                CPOperand out = new CPOperand(parts[7]);
                if (lhsInput.getDataType() == Types.DataType.MATRIX) {
                    return new MatrixIndexingCPInstruction(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                if (lhsInput.getDataType() == Types.DataType.FRAME) {
                    return new FrameIndexingCPInstruction(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                if (lhsInput.getDataType() == Types.DataType.LIST) {
                    return new ListIndexingCPInstruction(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on matrices, frames, and lists.");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a MatrixIndexingCPInstruction: " + str);
    }
}

