/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.functionobjects.ValueComparisonFunction;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.DMVUtils;
import org.apache.sysds.runtime.util.EMAUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;

public class FrameBlock
implements CacheBlock,
Externalizable {
    private static final long serialVersionUID = -3993450030207130665L;
    private static final Log LOG = LogFactory.getLog((String)FrameBlock.class.getName());
    private static final IDSequence CLASS_ID = new IDSequence();
    public static final int BUFFER_SIZE = 1000000;
    private static final boolean REUSE_RECODE_MAPS = true;
    private int _numRows = 0;
    private Types.ValueType[] _schema = null;
    private String[] _colnames = null;
    private ColumnMetadata[] _colmeta = null;
    private Array[] _coldata = null;
    long _msize = -1L;

    public FrameBlock() {
    }

    public FrameBlock(FrameBlock that) {
        this(that.getSchema(), that.getColumnNames(false));
        this.copy(that);
        this.setColumnMetadata(that.getColumnMetadata());
    }

    public FrameBlock(int ncols, Types.ValueType vt) {
        this();
        this._schema = UtilFunctions.nCopies(ncols, vt);
        this._colnames = null;
        this._colmeta = new ColumnMetadata[ncols];
        for (int j = 0; j < ncols; ++j) {
            this._colmeta[j] = new ColumnMetadata(0L);
        }
    }

    public FrameBlock(Types.ValueType[] schema) {
        this(schema, new String[0][]);
    }

    public FrameBlock(Types.ValueType[] schema, String[] names) {
        this(schema, names, new String[0][]);
    }

    public FrameBlock(Types.ValueType[] schema, String[][] data) {
        this(schema, null, data);
    }

    public FrameBlock(Types.ValueType[] schema, String[] names, String[][] data) {
        this._schema = schema;
        this._colnames = names;
        this._colmeta = new ColumnMetadata[this._schema.length];
        for (int j = 0; j < this._schema.length; ++j) {
            this._colmeta[j] = new ColumnMetadata(0L);
        }
        for (int i = 0; i < data.length; ++i) {
            this.appendRow(data[i]);
        }
    }

    @Override
    public int getNumRows() {
        return this._numRows;
    }

    public void setNumRows(int numRows) {
        this._numRows = numRows;
    }

    @Override
    public int getNumColumns() {
        return this._schema != null ? this._schema.length : 0;
    }

    @Override
    public DataCharacteristics getDataCharacteristics() {
        return new MatrixCharacteristics((long)this.getNumRows(), (long)this.getNumColumns(), -1);
    }

    public Types.ValueType[] getSchema() {
        return this._schema;
    }

    public void setSchema(Types.ValueType[] schema) {
        this._schema = schema;
    }

    public String[] getColumnNames() {
        return this.getColumnNames(true);
    }

    public FrameBlock getColumnNamesAsFrame() {
        FrameBlock fb = new FrameBlock(this.getNumColumns(), Types.ValueType.STRING);
        fb.appendRow(this.getColumnNames());
        return fb;
    }

    public String[] getColumnNames(boolean alloc) {
        if (this._colnames == null && alloc) {
            this._colnames = FrameBlock.createColNames(this.getNumColumns());
        }
        return this._colnames;
    }

    public String getColumnName(int c) {
        if (this._colnames == null) {
            this._colnames = FrameBlock.createColNames(this.getNumColumns());
        }
        return this._colnames[c];
    }

    public void setColumnNames(String[] colnames) {
        this._colnames = colnames;
    }

    public ColumnMetadata[] getColumnMetadata() {
        return this._colmeta;
    }

    public ColumnMetadata getColumnMetadata(int c) {
        return this._colmeta[c];
    }

    public boolean isColumnMetadataDefault() {
        boolean ret = true;
        for (int j = 0; j < this.getNumColumns() && ret; ret &= this.isColumnMetadataDefault(j), ++j) {
        }
        return ret;
    }

    public boolean isColumnMetadataDefault(int c) {
        return this._colmeta[c].getMvValue() == null && this._colmeta[c].getNumDistinct() == 0L;
    }

    public void setColumnMetadata(ColumnMetadata[] colmeta) {
        System.arraycopy(colmeta, 0, this._colmeta, 0, this._colmeta.length);
    }

    public void setColumnMetadata(int c, ColumnMetadata colmeta) {
        this._colmeta[c] = colmeta;
    }

    public Map<String, Integer> getColumnNameIDMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int j = 0; j < this.getNumColumns(); ++j) {
            ret.put(this.getColumnName(j), j + 1);
        }
        return ret;
    }

    public void ensureAllocatedColumns(int numRows) {
        int j;
        this._msize = -1L;
        if (this._coldata != null && this._schema.length == this._coldata.length) {
            if (this._numRows < numRows) {
                String[] tmp = new String[this.getNumColumns()];
                int len = numRows - this._numRows;
                for (int i = 0; i < len; ++i) {
                    this.appendRow(tmp);
                }
            }
            return;
        }
        if (this._colmeta == null || this._schema.length != this._colmeta.length) {
            this._colmeta = new ColumnMetadata[this._schema.length];
            for (j = 0; j < this._schema.length; ++j) {
                this._colmeta[j] = new ColumnMetadata(0L);
            }
        }
        this._coldata = new Array[this._schema.length];
        block10: for (j = 0; j < this._schema.length; ++j) {
            switch (this._schema[j]) {
                case STRING: {
                    this._coldata[j] = new StringArray(new String[numRows]);
                    continue block10;
                }
                case BOOLEAN: {
                    this._coldata[j] = new BooleanArray(new boolean[numRows]);
                    continue block10;
                }
                case INT32: {
                    this._coldata[j] = new IntegerArray(new int[numRows]);
                    continue block10;
                }
                case INT64: {
                    this._coldata[j] = new LongArray(new long[numRows]);
                    continue block10;
                }
                case FP32: {
                    this._coldata[j] = new FloatArray(new float[numRows]);
                    continue block10;
                }
                case FP64: {
                    this._coldata[j] = new DoubleArray(new double[numRows]);
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unsupported value type: " + (Object)((Object)this._schema[j]));
                }
            }
        }
        this._numRows = numRows;
    }

    public void ensureColumnCompatibility(int newlen) {
        if (this._coldata != null && this._coldata.length > 0 && this._numRows != newlen) {
            throw new RuntimeException("Mismatch in number of rows: " + newlen + " (expected: " + this._numRows + ")");
        }
    }

    public static String[] createColNames(int size) {
        return FrameBlock.createColNames(0, size);
    }

    public static String[] createColNames(int off, int size) {
        String[] ret = new String[size];
        for (int i = off + 1; i <= off + size; ++i) {
            ret[i - off - 1] = FrameBlock.createColName(i);
        }
        return ret;
    }

    public static String createColName(int i) {
        return "C" + i;
    }

    public boolean isColNamesDefault() {
        boolean ret = this._colnames != null;
        for (int j = 0; j < this.getNumColumns() && ret; ret &= this.isColNameDefault(j), ++j) {
        }
        return ret;
    }

    public boolean isColNameDefault(int i) {
        return this._colnames == null || this._colnames[i].equals("C" + (i + 1));
    }

    public void recomputeColumnCardinality() {
        for (int j = 0; j < this.getNumColumns(); ++j) {
            int card = 0;
            for (int i = 0; i < this.getNumRows(); ++i) {
                card += this.get(i, j) != null ? 1 : 0;
            }
            this._colmeta[j].setNumDistinct(card);
        }
    }

    public Object get(int r, int c) {
        return this._coldata[c].get(r);
    }

    public void set(int r, int c, Object val) {
        this._coldata[c].set(r, UtilFunctions.objectToObject(this._schema[c], val));
        this._msize = -1L;
    }

    public void reset(int nrow, boolean clearMeta) {
        int i;
        if (clearMeta) {
            this._schema = null;
            this._colnames = null;
            if (this._colmeta != null) {
                for (i = 0; i < this._colmeta.length; ++i) {
                    if (this.isColumnMetadataDefault(i)) continue;
                    this._colmeta[i] = new ColumnMetadata(0L);
                }
            }
        }
        if (this._coldata != null) {
            for (i = 0; i < this._coldata.length; ++i) {
                this._coldata[i].reset(nrow);
            }
        }
        this._msize = -1L;
    }

    public void reset() {
        this.reset(0, true);
    }

    public void appendRow(Object[] row) {
        this.ensureAllocatedColumns(0);
        for (int j = 0; j < row.length; ++j) {
            this._coldata[j].append(row[j]);
        }
        ++this._numRows;
    }

    public void appendRow(String[] row) {
        this.ensureAllocatedColumns(0);
        for (int j = 0; j < row.length; ++j) {
            this._coldata[j].append(row[j]);
        }
        ++this._numRows;
    }

    public void appendColumn(String[] col) {
        Array[] arrayArray;
        this.ensureColumnCompatibility(col.length);
        Object[] colnames = this.getColumnNames();
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)Types.ValueType.STRING));
        this._colnames = (String[])ArrayUtils.add((Object[])colnames, (Object)FrameBlock.createColName(this._schema.length));
        if (this._coldata == null) {
            Array[] arrayArray2 = new Array[1];
            arrayArray = arrayArray2;
            arrayArray2[0] = new StringArray(col);
        } else {
            arrayArray = (Array[])ArrayUtils.add((Object[])this._coldata, (Object)new StringArray(col));
        }
        this._coldata = arrayArray;
        this._numRows = col.length;
        this._msize = -1L;
    }

    public void appendColumn(boolean[] col) {
        Array[] arrayArray;
        this.ensureColumnCompatibility(col.length);
        Object[] colnames = this.getColumnNames();
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)Types.ValueType.BOOLEAN));
        this._colnames = (String[])ArrayUtils.add((Object[])colnames, (Object)FrameBlock.createColName(this._schema.length));
        if (this._coldata == null) {
            Array[] arrayArray2 = new Array[1];
            arrayArray = arrayArray2;
            arrayArray2[0] = new BooleanArray(col);
        } else {
            arrayArray = (Array[])ArrayUtils.add((Object[])this._coldata, (Object)new BooleanArray(col));
        }
        this._coldata = arrayArray;
        this._numRows = col.length;
        this._msize = -1L;
    }

    public void appendColumn(int[] col) {
        Array[] arrayArray;
        this.ensureColumnCompatibility(col.length);
        Object[] colnames = this.getColumnNames();
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)Types.ValueType.INT32));
        this._colnames = (String[])ArrayUtils.add((Object[])colnames, (Object)FrameBlock.createColName(this._schema.length));
        if (this._coldata == null) {
            Array[] arrayArray2 = new Array[1];
            arrayArray = arrayArray2;
            arrayArray2[0] = new IntegerArray(col);
        } else {
            arrayArray = (Array[])ArrayUtils.add((Object[])this._coldata, (Object)new IntegerArray(col));
        }
        this._coldata = arrayArray;
        this._numRows = col.length;
        this._msize = -1L;
    }

    public void appendColumn(long[] col) {
        Array[] arrayArray;
        this.ensureColumnCompatibility(col.length);
        Object[] colnames = this.getColumnNames();
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)Types.ValueType.INT64));
        this._colnames = (String[])ArrayUtils.add((Object[])colnames, (Object)FrameBlock.createColName(this._schema.length));
        if (this._coldata == null) {
            Array[] arrayArray2 = new Array[1];
            arrayArray = arrayArray2;
            arrayArray2[0] = new LongArray(col);
        } else {
            arrayArray = (Array[])ArrayUtils.add((Object[])this._coldata, (Object)new LongArray(col));
        }
        this._coldata = arrayArray;
        this._numRows = col.length;
        this._msize = -1L;
    }

    public void appendColumn(float[] col) {
        Array[] arrayArray;
        this.ensureColumnCompatibility(col.length);
        Object[] colnames = this.getColumnNames();
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)Types.ValueType.FP32));
        this._colnames = (String[])ArrayUtils.add((Object[])colnames, (Object)FrameBlock.createColName(this._schema.length));
        if (this._coldata == null) {
            Array[] arrayArray2 = new Array[1];
            arrayArray = arrayArray2;
            arrayArray2[0] = new FloatArray(col);
        } else {
            arrayArray = (Array[])ArrayUtils.add((Object[])this._coldata, (Object)new FloatArray(col));
        }
        this._coldata = arrayArray;
        this._numRows = col.length;
        this._msize = -1L;
    }

    public void appendColumn(double[] col) {
        Array[] arrayArray;
        this.ensureColumnCompatibility(col.length);
        Object[] colnames = this.getColumnNames();
        this._schema = (Types.ValueType[])ArrayUtils.add((Object[])this._schema, (Object)((Object)Types.ValueType.FP64));
        this._colnames = (String[])ArrayUtils.add((Object[])colnames, (Object)FrameBlock.createColName(this._schema.length));
        if (this._coldata == null) {
            Array[] arrayArray2 = new Array[1];
            arrayArray = arrayArray2;
            arrayArray2[0] = new DoubleArray(col);
        } else {
            arrayArray = (Array[])ArrayUtils.add((Object[])this._coldata, (Object)new DoubleArray(col));
        }
        this._coldata = arrayArray;
        this._numRows = col.length;
        this._msize = -1L;
    }

    public void appendColumns(double[][] cols) {
        int ncol = cols.length;
        boolean empty = this._schema == null;
        Types.ValueType[] tmpSchema = UtilFunctions.nCopies(ncol, Types.ValueType.FP64);
        Object[] tmpData = new Array[ncol];
        for (int j = 0; j < ncol; ++j) {
            tmpData[j] = new DoubleArray(cols[j]);
        }
        this._colnames = empty ? null : (String[])ArrayUtils.addAll((Object[])this.getColumnNames(), (Object[])FrameBlock.createColNames(this.getNumColumns(), ncol));
        this._schema = empty ? tmpSchema : (Types.ValueType[])ArrayUtils.addAll((Object[])this._schema, (Object[])tmpSchema);
        this._coldata = empty ? tmpData : (Array[])ArrayUtils.addAll((Object[])this._coldata, (Object[])tmpData);
        this._numRows = cols[0].length;
        this._msize = -1L;
    }

    public Object getColumnData(int c) {
        switch (this._schema[c]) {
            case STRING: {
                return ((StringArray)this._coldata[c])._data;
            }
            case BOOLEAN: {
                return ((BooleanArray)this._coldata[c])._data;
            }
            case INT64: {
                return ((LongArray)this._coldata[c])._data;
            }
            case FP64: {
                return ((DoubleArray)this._coldata[c])._data;
            }
        }
        return null;
    }

    public Array getColumn(int c) {
        return this._coldata[c];
    }

    public void setColumn(int c, Array column) {
        if (this._coldata == null) {
            this._coldata = new Array[this.getNumColumns()];
        }
        this._coldata[c] = column;
        this._msize = -1L;
    }

    public Iterator<String[]> getStringRowIterator() {
        return new StringRowIterator(0, this._numRows);
    }

    public Iterator<String[]> getStringRowIterator(int[] cols) {
        return new StringRowIterator(0, this._numRows, cols);
    }

    public Iterator<String[]> getStringRowIterator(int colID) {
        return new StringRowIterator(0, this._numRows, new int[]{colID});
    }

    public Iterator<String[]> getStringRowIterator(int rl, int ru) {
        return new StringRowIterator(rl, ru);
    }

    public Iterator<String[]> getStringRowIterator(int rl, int ru, int[] cols) {
        return new StringRowIterator(rl, ru, cols);
    }

    public Iterator<String[]> getStringRowIterator(int rl, int ru, int colID) {
        return new StringRowIterator(rl, ru, new int[]{colID});
    }

    public Iterator<Object[]> getObjectRowIterator() {
        return new ObjectRowIterator(0, this._numRows);
    }

    public Iterator<Object[]> getObjectRowIterator(Types.ValueType[] schema) {
        ObjectRowIterator iter = new ObjectRowIterator(0, this._numRows);
        iter.setSchema(schema);
        return iter;
    }

    public Iterator<Object[]> getObjectRowIterator(int[] cols) {
        return new ObjectRowIterator(0, this._numRows, cols);
    }

    public Iterator<Object[]> getObjectRowIterator(int rl, int ru) {
        return new ObjectRowIterator(rl, ru);
    }

    public Iterator<Object[]> getObjectRowIterator(int rl, int ru, int[] cols) {
        return new ObjectRowIterator(rl, ru, cols);
    }

    public void write(DataOutput out) throws IOException {
        boolean isDefaultMeta = this.isColNamesDefault() && this.isColumnMetadataDefault();
        out.writeInt(this.getNumRows());
        out.writeInt(this.getNumColumns());
        out.writeBoolean(isDefaultMeta);
        for (int j = 0; j < this.getNumColumns(); ++j) {
            byte type = (byte)this._schema[j].ordinal();
            if (this._coldata == null || this._coldata[j] == null) {
                type = (byte)(type * -1);
            }
            out.writeByte(type);
            if (!isDefaultMeta) {
                out.writeUTF(this.getColumnName(j));
                out.writeLong(this._colmeta[j].getNumDistinct());
                out.writeUTF(this._colmeta[j].getMvValue() != null ? this._colmeta[j].getMvValue() : "");
            }
            if (type < 0) continue;
            this._coldata[j].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._numRows = in.readInt();
        int numCols = in.readInt();
        boolean isDefaultMeta = in.readBoolean();
        this._schema = this._schema != null && this._schema.length == numCols ? this._schema : new Types.ValueType[numCols];
        this._colnames = this._colnames != null && this._colnames.length == numCols ? this._colnames : new String[numCols];
        this._colmeta = this._colmeta != null && this._colmeta.length == numCols ? this._colmeta : new ColumnMetadata[numCols];
        this._coldata = this._coldata != null && this._coldata.length == numCols ? this._coldata : new Array[numCols];
        for (int j = 0; j < numCols; ++j) {
            byte type = in.readByte();
            Types.ValueType vt = Types.ValueType.values()[Math.abs(type)];
            String name = isDefaultMeta ? FrameBlock.createColName(j) : in.readUTF();
            long ndistinct = isDefaultMeta ? 0L : in.readLong();
            String mvvalue = isDefaultMeta ? null : in.readUTF();
            Array arr = null;
            if (type > 0) {
                switch (vt) {
                    case STRING: {
                        arr = new StringArray(new String[this._numRows]);
                        break;
                    }
                    case BOOLEAN: {
                        arr = new BooleanArray(new boolean[this._numRows]);
                        break;
                    }
                    case INT64: {
                        arr = new LongArray(new long[this._numRows]);
                        break;
                    }
                    case FP64: {
                        arr = new DoubleArray(new double[this._numRows]);
                        break;
                    }
                    case INT32: {
                        arr = new IntegerArray(new int[this._numRows]);
                        break;
                    }
                    case FP32: {
                        arr = new FloatArray(new float[this._numRows]);
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported value type: " + (Object)((Object)vt));
                    }
                }
                arr.readFields(in);
            }
            this._schema[j] = vt;
            this._colnames[j] = name;
            this._colmeta[j] = new ColumnMetadata(ndistinct, mvvalue == null || mvvalue.isEmpty() ? null : mvvalue);
            this._coldata[j] = arr;
        }
        this._msize = -1L;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readFields(in);
    }

    @Override
    public long getInMemorySize() {
        int j;
        if (this._msize > 0L) {
            return this._msize;
        }
        long size = 20L;
        int clen = this.getNumColumns();
        size += (long)(40 + clen * 4);
        size += (long)(8 + (this._colnames != null ? 32 : 0));
        for (j = 0; j < clen && this._colnames != null; ++j) {
            size += FrameBlock.getInMemoryStringSize(this.getColumnName(j));
        }
        size += 40L;
        for (j = 0; j < clen; ++j) {
            size += 32L + FrameBlock.getInMemoryStringSize(this._colmeta[j].getMvValue());
        }
        size += (long)(40 + clen * 60);
        block7: for (j = 0; j < clen; ++j) {
            switch (this._schema[j]) {
                case BOOLEAN: {
                    size += (long)this._numRows;
                    continue block7;
                }
                case INT64: 
                case FP64: {
                    size += (long)(8 * this._numRows);
                    continue block7;
                }
                case STRING: {
                    StringArray arr = (StringArray)this._coldata[j];
                    for (int i = 0; i < this._numRows; ++i) {
                        size += FrameBlock.getInMemoryStringSize(arr.get(i));
                    }
                    continue block7;
                }
            }
        }
        this._msize = size;
        return this._msize;
    }

    @Override
    public long getExactSerializedSize() {
        long size = 9L;
        boolean isDefaultMeta = this.isColNamesDefault() && this.isColumnMetadataDefault();
        block5: for (int j = 0; j < this.getNumColumns(); ++j) {
            ++size;
            if (!isDefaultMeta) {
                size += (long)IOUtilFunctions.getUTFSize(this.getColumnName(j));
                size += 8L;
                size += (long)IOUtilFunctions.getUTFSize(this._colmeta[j].getMvValue());
            }
            switch (this._schema[j]) {
                case BOOLEAN: {
                    size += (long)this._numRows;
                    continue block5;
                }
                case INT64: 
                case FP64: {
                    size += (long)(8 * this._numRows);
                    continue block5;
                }
                case STRING: {
                    StringArray arr = (StringArray)this._coldata[j];
                    for (int i = 0; i < this._numRows; ++i) {
                        size += (long)IOUtilFunctions.getUTFSize(arr.get(i));
                    }
                    continue block5;
                }
            }
        }
        return size;
    }

    @Override
    public boolean isShallowSerialize() {
        return this.isShallowSerialize(false);
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        boolean ret = true;
        for (int j = 0; j < this._schema.length && ret; ret &= this._schema[j] != Types.ValueType.STRING, ++j) {
        }
        return ret;
    }

    @Override
    public void toShallowSerializeBlock() {
    }

    @Override
    public void compactEmptyBlock() {
    }

    private static long getInMemoryStringSize(String value) {
        if (value == null) {
            return 0L;
        }
        return 60 + value.length();
    }

    public FrameBlock binaryOperations(BinaryOperator bop, FrameBlock that, FrameBlock out) {
        if (this.getNumColumns() != that.getNumColumns() && this.getNumRows() != that.getNumColumns()) {
            throw new DMLRuntimeException("Frame dimension mismatch " + this.getNumRows() + " * " + this.getNumColumns() + " != " + that.getNumRows() + " * " + that.getNumColumns());
        }
        String[][] outputData = new String[this.getNumRows()][this.getNumColumns()];
        if (!(bop.fn instanceof ValueComparisonFunction)) {
            throw new DMLRuntimeException("Unsupported binary operation on frames (only comparisons supported)");
        }
        ValueComparisonFunction vcomp = (ValueComparisonFunction)bop.fn;
        for (int i = 0; i < this.getNumColumns(); ++i) {
            ScalarObject so2;
            ScalarObject so1;
            int j;
            if (this.getSchema()[i] == Types.ValueType.STRING || that.getSchema()[i] == Types.ValueType.STRING) {
                for (j = 0; j < this.getNumRows(); ++j) {
                    if (FrameBlock.checkAndSetEmpty(this, that, outputData, j, i)) continue;
                    String v1 = UtilFunctions.objectToString(this.get(j, i));
                    String v2 = UtilFunctions.objectToString(that.get(j, i));
                    outputData[j][i] = String.valueOf(vcomp.compare(v1, v2));
                }
                continue;
            }
            if (this.getSchema()[i] == Types.ValueType.FP64 || that.getSchema()[i] == Types.ValueType.FP64 || this.getSchema()[i] == Types.ValueType.FP32 || that.getSchema()[i] == Types.ValueType.FP32) {
                for (j = 0; j < this.getNumRows(); ++j) {
                    if (FrameBlock.checkAndSetEmpty(this, that, outputData, j, i)) continue;
                    so1 = new DoubleObject(Double.parseDouble(this.get(j, i).toString()));
                    so2 = new DoubleObject(Double.parseDouble(that.get(j, i).toString()));
                    outputData[j][i] = String.valueOf(vcomp.compare(so1.getDoubleValue(), so2.getDoubleValue()));
                }
                continue;
            }
            if (this.getSchema()[i] == Types.ValueType.INT64 || that.getSchema()[i] == Types.ValueType.INT64 || this.getSchema()[i] == Types.ValueType.INT32 || that.getSchema()[i] == Types.ValueType.INT32) {
                for (j = 0; j < this.getNumRows(); ++j) {
                    if (FrameBlock.checkAndSetEmpty(this, that, outputData, j, i)) continue;
                    so1 = new IntObject(Integer.parseInt(this.get(j, i).toString()));
                    so2 = new IntObject(Integer.parseInt(that.get(j, i).toString()));
                    outputData[j][i] = String.valueOf(vcomp.compare(so1.getLongValue(), so2.getLongValue()));
                }
                continue;
            }
            for (j = 0; j < this.getNumRows(); ++j) {
                if (FrameBlock.checkAndSetEmpty(this, that, outputData, j, i)) continue;
                so1 = new BooleanObject(Boolean.parseBoolean(this.get(j, i).toString()));
                so2 = new BooleanObject(Boolean.parseBoolean(that.get(j, i).toString()));
                outputData[j][i] = String.valueOf(vcomp.compare(so1.getBooleanValue(), so2.getBooleanValue()));
            }
        }
        return new FrameBlock(UtilFunctions.nCopies(this.getNumColumns(), Types.ValueType.BOOLEAN), outputData);
    }

    private static boolean checkAndSetEmpty(FrameBlock fb1, FrameBlock fb2, String[][] out, int r, int c) {
        if (fb1.get(r, c) == null || fb2.get(r, c) == null) {
            out[r][c] = fb1.get(r, c) == null && fb2.get(r, c) == null ? "true" : "false";
            return true;
        }
        return false;
    }

    public FrameBlock leftIndexingOperations(FrameBlock rhsFrame, IndexRange ixrange, FrameBlock ret) {
        return this.leftIndexingOperations(rhsFrame, (int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, ret);
    }

    public FrameBlock leftIndexingOperations(FrameBlock rhsFrame, int rl, int ru, int cl, int cu, FrameBlock ret) {
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cu >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for frame indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within frame dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "].");
        }
        if (ru - rl + 1 < rhsFrame.getNumRows() || cu - cl + 1 < rhsFrame.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for frame indexing: dimensions of the source frame [" + rhsFrame.getNumRows() + "x" + rhsFrame.getNumColumns() + "] do not match the shape of the frame specified by indices [" + (rl + 1) + ":" + (ru + 1) + ", " + (cl + 1) + ":" + (cu + 1) + "].");
        }
        if (ret == null) {
            ret = new FrameBlock();
        }
        ret._numRows = this._numRows;
        ret._schema = (Types.ValueType[])this._schema.clone();
        ret._colnames = this._colnames != null ? (String[])this._colnames.clone() : null;
        ret._colmeta = (ColumnMetadata[])this._colmeta.clone();
        ret._coldata = new Array[this.getNumColumns()];
        for (int j = 0; j < this.getNumColumns(); ++j) {
            Array tmp = this._coldata[j].clone();
            if (j >= cl && j <= cu) {
                if (this._schema[j] == rhsFrame._schema[j - cl]) {
                    tmp.set(rl, ru, rhsFrame._coldata[j - cl]);
                } else {
                    for (int i = rl; i <= ru; ++i) {
                        tmp.set(i, UtilFunctions.objectToObject(this._schema[j], rhsFrame._coldata[j - cl].get(i - rl)));
                    }
                }
            }
            ret._coldata[j] = tmp;
        }
        return ret;
    }

    public FrameBlock slice(IndexRange ixrange, FrameBlock ret) {
        return this.slice((int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, ret);
    }

    @Override
    public FrameBlock slice(int rl, int ru, int cl, int cu, CacheBlock retCache) {
        int j;
        FrameBlock ret = (FrameBlock)retCache;
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cu >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for frame indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within frame dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "]");
        }
        if (ret == null) {
            ret = new FrameBlock();
        } else {
            ret.reset(ru - rl + 1, true);
        }
        int numCols = cu - cl + 1;
        boolean isDefNames = this.isColNamesDefault();
        ret._schema = new Types.ValueType[numCols];
        ret._colnames = !isDefNames ? new String[numCols] : null;
        ret._colmeta = new ColumnMetadata[numCols];
        for (j = cl; j <= cu; ++j) {
            ret._schema[j - cl] = this._schema[j];
            ret._colmeta[j - cl] = this._colmeta[j];
            if (isDefNames) continue;
            ret._colnames[j - cl] = this.getColumnName(j);
        }
        ret._numRows = ru - rl + 1;
        if (ret._coldata == null) {
            ret._coldata = new Array[numCols];
        }
        if (ret._numRows == this._numRows) {
            for (j = cl; j <= cu; ++j) {
                ret._coldata[j - cl] = this._coldata[j];
            }
        } else {
            for (j = cl; j <= cu; ++j) {
                if (ret._coldata[j - cl] == null) {
                    ret._coldata[j - cl] = this._coldata[j].slice(rl, ru);
                    continue;
                }
                ret._coldata[j - cl].set(0, ru - rl, this._coldata[j], rl);
            }
        }
        return ret;
    }

    public void slice(ArrayList<Pair<Long, FrameBlock>> outlist, IndexRange range, int rowCut) {
        FrameBlock top = null;
        FrameBlock bottom = null;
        Iterator<Pair<Long, FrameBlock>> p = outlist.iterator();
        if (range.rowStart < (long)rowCut) {
            top = p.next().getValue();
        }
        if (range.rowEnd >= (long)rowCut) {
            bottom = p.next().getValue();
        }
        if (this.getNumRows() > 0) {
            int c;
            Object[] row;
            int r = (int)range.rowStart;
            while ((long)r < Math.min((long)rowCut, range.rowEnd + 1L)) {
                row = new Object[(int)(range.colEnd - range.colStart + 1L)];
                c = (int)range.colStart;
                while ((long)c < range.colEnd + 1L) {
                    row[(int)((long)c - range.colStart)] = this.get(r, c);
                    ++c;
                }
                top.appendRow(row);
                ++r;
            }
            while ((long)r <= range.rowEnd) {
                row = new Object[(int)(range.colEnd - range.colStart + 1L)];
                c = (int)range.colStart;
                while ((long)c < range.colEnd + 1L) {
                    row[(int)((long)c - range.colStart)] = this.get(r, c);
                    ++c;
                }
                bottom.appendRow(row);
                ++r;
            }
        }
    }

    public FrameBlock append(FrameBlock that, FrameBlock ret, boolean cbind) {
        if (cbind) {
            if (this.getNumRows() != that.getNumRows()) {
                throw new DMLRuntimeException("Incompatible number of rows for cbind: " + that.getNumRows() + " (expected: " + this.getNumRows() + ")");
            }
            if (ret == null) {
                ret = new FrameBlock();
            }
            ret._numRows = this._numRows;
            ret._schema = (Types.ValueType[])ArrayUtils.addAll((Object[])this._schema, (Object[])that._schema);
            ret._colnames = (String[])ArrayUtils.addAll((Object[])this.getColumnNames(), (Object[])that.getColumnNames());
            ret._colmeta = (ColumnMetadata[])ArrayUtils.addAll((Object[])this._colmeta, (Object[])that._colmeta);
            if (!Arrays.stream(ret._colnames).allMatch(new HashSet()::add)) {
                ret._colnames = FrameBlock.createColNames(ret.getNumColumns());
            }
            ret._coldata = (Array[])ArrayUtils.addAll((Object[])this._coldata, (Object[])that._coldata);
        } else {
            int j;
            if (this.getNumColumns() != that.getNumColumns()) {
                throw new DMLRuntimeException("Incompatible number of columns for rbind: " + that.getNumColumns() + " (expected: " + this.getNumColumns() + ")");
            }
            if (ret == null) {
                ret = new FrameBlock();
            }
            ret._numRows = this._numRows;
            ret._schema = (Types.ValueType[])this._schema.clone();
            ret._colnames = this._colnames != null ? (String[])this._colnames.clone() : null;
            ret._colmeta = new ColumnMetadata[this.getNumColumns()];
            for (j = 0; j < this._schema.length; ++j) {
                ret._colmeta[j] = new ColumnMetadata(0L);
            }
            ret._coldata = new Array[this.getNumColumns()];
            for (j = 0; j < this.getNumColumns(); ++j) {
                ret._coldata[j] = this._coldata[j].clone();
            }
            Iterator<Object[]> iter = that.getObjectRowIterator(this._schema);
            while (iter.hasNext()) {
                ret.appendRow(iter.next());
            }
        }
        return ret;
    }

    public void copy(FrameBlock src) {
        this.copy(0, src.getNumRows() - 1, 0, src.getNumColumns() - 1, src);
    }

    public void copy(int rl, int ru, int cl, int cu, FrameBlock src) {
        this.ensureAllocatedColumns(ru - rl + 1);
        for (int j = cl; j <= cu; ++j) {
            if (this._schema[j].equals((Object)src._schema[j - cl])) {
                this._coldata[j].set(rl, ru, src._coldata[j - cl]);
                continue;
            }
            for (int i = rl; i <= ru; ++i) {
                String tmp = src.get(i - rl, j - cl) != null ? src.get(i - rl, j - cl).toString() : null;
                this.set(i, j, UtilFunctions.stringToObject(this._schema[j], tmp));
            }
        }
    }

    public HashMap<String, Long> getRecodeMap(int col) {
        HashMap<String, Long> map;
        SoftReference<HashMap<String, Long>> tmp = this._coldata[col]._rcdMapCache;
        HashMap<String, Long> hashMap = map = tmp != null ? tmp.get() : null;
        if (map != null) {
            return map;
        }
        HashMap<String, Long> map2 = new HashMap<String, Long>();
        Array ldata = this._coldata[col];
        for (int i = 0; i < this.getNumRows(); ++i) {
            Object val = ldata.get(i);
            if (val == null) continue;
            String[] tmp2 = ColumnEncoderRecode.splitRecodeMapEntry(val.toString());
            map2.put(tmp2[0], Long.parseLong(tmp2[1]));
        }
        this._coldata[col]._rcdMapCache = new SoftReference(map2);
        return map2;
    }

    @Override
    public void merge(CacheBlock that, boolean bDummy) {
        this.merge((FrameBlock)that);
    }

    public void merge(FrameBlock that) {
        int j;
        if (that == null || that.getNumRows() == 0) {
            return;
        }
        if (this.getNumRows() != that.getNumRows() || this.getNumColumns() != that.getNumColumns()) {
            throw new DMLRuntimeException("Dimension mismatch on merge disjoint (target=" + this.getNumRows() + "x" + this.getNumColumns() + ", source=" + that.getNumRows() + "x" + that.getNumColumns() + ")");
        }
        for (j = 0; j < this.getNumColumns(); ++j) {
            if (that.isColumnMetadataDefault(j)) continue;
            this._colmeta[j].setNumDistinct(that._colmeta[j].getNumDistinct());
            this._colmeta[j].setMvValue(that._colmeta[j].getMvValue());
        }
        for (j = 0; j < this.getNumColumns(); ++j) {
            if (this._schema[j].equals((Object)that._schema[j])) {
                this._coldata[j].setNz(0, this._numRows - 1, that._coldata[j]);
                continue;
            }
            for (int i = 0; i < this._numRows; ++i) {
                Object obj = UtilFunctions.objectToObject(this._schema[j], that.get(i, j), true);
                if (obj == null) continue;
                this.set(i, j, obj);
            }
        }
    }

    public FrameBlock zeroOutOperations(FrameBlock result, IndexRange range, boolean complementary, int iRowStartSrc, int iRowStartDest, int blen, int iMaxRowsToCopy) {
        int clen = this.getNumColumns();
        if (result == null) {
            result = new FrameBlock(this.getSchema());
        } else {
            result.reset(0, true);
            result.setSchema(this.getSchema());
        }
        result.ensureAllocatedColumns(blen);
        if (complementary) {
            int r = (int)range.rowStart;
            while ((long)r <= range.rowEnd && r + iRowStartDest < blen) {
                int c = (int)range.colStart;
                while ((long)c <= range.colEnd) {
                    result.set(r + iRowStartDest, c, this.get(r + iRowStartSrc, c));
                    ++c;
                }
                ++r;
            }
        } else {
            int c;
            int r;
            for (r = iRowStartDest; r < (int)range.rowStart && r - iRowStartDest < iMaxRowsToCopy; ++r) {
                for (c = 0; c < clen; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
            }
            while (r <= (int)range.rowEnd && r - iRowStartDest < iMaxRowsToCopy) {
                for (c = 0; c < (int)range.colStart; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
                for (c = (int)range.colEnd + 1; c < clen; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
                ++r;
            }
            while (r - iRowStartDest < iMaxRowsToCopy) {
                for (c = 0; c < clen; ++c) {
                    result.set(r, c, this.get(r + iRowStartSrc - iRowStartDest, c));
                }
                ++r;
            }
        }
        return result;
    }

    public FrameBlock getSchemaTypeOf() {
        FrameBlock fb = new FrameBlock(UtilFunctions.nCopies(this.getNumColumns(), Types.ValueType.STRING));
        fb.appendRow((String[])Arrays.stream(this._schema).map((? super T vt) -> vt.toString()).toArray(String[]::new));
        return fb;
    }

    private static Types.ValueType isType(String val) {
        if ((val = val.trim().toLowerCase().replaceAll("\"", "")).matches("(true|false|t|f|0|1)")) {
            return Types.ValueType.BOOLEAN;
        }
        if (val.matches("[-+]?\\d+")) {
            long maxValue = Long.parseLong(val);
            if (maxValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE) {
                return Types.ValueType.INT32;
            }
            return Types.ValueType.INT64;
        }
        if (val.matches("[-+]?[0-9]+\\.?[0-9]*([e]?[-+]?[0-9]+)")) {
            double maxValue = Double.parseDouble(val);
            if (maxValue >= -3.4028234663852886E38 && maxValue <= 3.4028234663852886E38) {
                return Types.ValueType.FP32;
            }
            return Types.ValueType.FP64;
        }
        if (val.equals("infinity") || val.equals("-infinity") || val.equals("nan")) {
            return Types.ValueType.FP64;
        }
        return Types.ValueType.STRING;
    }

    public FrameBlock detectSchemaFromRow(double sampleFraction) {
        int rows = this.getNumRows();
        int cols = this.getNumColumns();
        String[] schemaInfo = new String[cols];
        int sample = (int)Math.min(Math.max(sampleFraction * (double)rows, 256.0), (double)rows);
        ExecutorService pool = CommonThreadPool.get(cols);
        ArrayList<DetectValueTypeTask> tasks = new ArrayList<DetectValueTypeTask>();
        for (int i = 0; i < cols; ++i) {
            Array obj = this.getColumn(i);
            tasks.add(new DetectValueTypeTask(obj, rows, sample));
        }
        try {
            List ret = pool.invokeAll(tasks);
            pool.shutdown();
            for (int i = 0; i < cols; ++i) {
                schemaInfo[i] = (String)ret.get(i).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DMLRuntimeException("Exception Interupted or Exception thrown in Detect Schema", e);
        }
        FrameBlock fb = new FrameBlock(UtilFunctions.nCopies(cols, Types.ValueType.STRING));
        fb.appendRow(schemaInfo);
        return fb;
    }

    public FrameBlock dropInvalidType(FrameBlock schema) {
        if (this.getNumColumns() != schema.getNumColumns()) {
            throw new DMLException("mismatch in number of columns in frame and its schema " + this.getNumColumns() + " != " + schema.getNumColumns());
        }
        String[] schemaString = schema.getStringRowIterator().next();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            String type;
            Array obj = this.getColumn(i);
            String schemaCol = schemaString[i];
            if (schemaCol.contains("FP")) {
                type = "FP";
            } else if (schemaCol.contains("INT")) {
                type = "INT";
            } else {
                if (schemaCol.contains("STRING")) continue;
                type = schemaCol;
            }
            for (int j = 0; j < this.getNumRows(); ++j) {
                String dataValue;
                Types.ValueType dataType;
                if (obj.get(j) == null || (dataType = FrameBlock.isType(dataValue = obj.get(j).toString().trim().replace("\"", "").toLowerCase())).toString().contains(type) || dataType == Types.ValueType.BOOLEAN && type.equals("INT") || dataType == Types.ValueType.BOOLEAN && type.equals("FP")) continue;
                LOG.warn((Object)("Datatype detected: " + (Object)((Object)dataType) + " where expected: " + schemaString[i] + " col: " + (i + 1) + ", row:" + (j + 1)));
                this.set(j, i, null);
            }
        }
        return this;
    }

    public FrameBlock invalidByLength(MatrixBlock feaLen) {
        if (this.getNumColumns() != feaLen.getNumColumns()) {
            throw new DMLException("mismatch in number of columns in frame and corresponding feature-length vector");
        }
        FrameBlock outBlock = new FrameBlock(this);
        for (int i = 0; i < this.getNumColumns(); ++i) {
            if (feaLen.quickGetValue(0, i) == -1.0) continue;
            int validLength = (int)feaLen.quickGetValue(0, i);
            Array obj = this.getColumn(i);
            for (int j = 0; j < obj._size; ++j) {
                String dataValue;
                if (obj.get(j) == null || (dataValue = obj.get(j).toString()).length() <= validLength) continue;
                outBlock.set(j, i, null);
            }
        }
        return outBlock;
    }

    public static FrameBlock mergeSchema(FrameBlock temp1, FrameBlock temp2) {
        String[] rowTemp2;
        String[] rowTemp1 = temp1.getStringRowIterator().next();
        if (rowTemp1.length != (rowTemp2 = temp2.getStringRowIterator().next()).length) {
            throw new DMLRuntimeException("Schema dimension mismatch: " + rowTemp1.length + " vs " + rowTemp2.length);
        }
        for (int i = 0; i < rowTemp1.length; ++i) {
            if (rowTemp1[i].equals(rowTemp2[i])) continue;
            if (rowTemp1[i].equals("STRING") || rowTemp2[i].equals("STRING")) {
                rowTemp1[i] = "STRING";
                continue;
            }
            if (rowTemp1[i].equals("FP64") || rowTemp2[i].equals("FP64")) {
                rowTemp1[i] = "FP64";
                continue;
            }
            if (rowTemp1[i].equals("FP32") && new ArrayList<String>(Arrays.asList("INT64", "INT32", "CHARACTER")).contains(rowTemp2[i])) {
                rowTemp1[i] = "FP32";
                continue;
            }
            if (rowTemp1[i].equals("INT64") && new ArrayList<String>(Arrays.asList("INT32", "CHARACTER")).contains(rowTemp2[i])) {
                rowTemp1[i] = "INT64";
                continue;
            }
            if (!rowTemp1[i].equals("INT32") && !rowTemp2[i].equals("CHARACTER")) continue;
            rowTemp1[i] = "INT32";
        }
        FrameBlock mergedFrame = new FrameBlock(UtilFunctions.nCopies(temp1.getNumColumns(), Types.ValueType.STRING));
        mergedFrame.appendRow(rowTemp1);
        return mergedFrame;
    }

    public void mapInplace(Function<String, String> fun) {
        for (int j = 0; j < this.getNumColumns(); ++j) {
            for (int i = 0; i < this.getNumRows(); ++i) {
                Object tmp = this.get(i, j);
                this.set(i, j, tmp == null ? tmp : UtilFunctions.objectToObject(this._schema[j], fun.apply(tmp.toString())));
            }
        }
    }

    public FrameBlock map(String lambdaExpr) {
        if (!lambdaExpr.contains("->")) {
            String args = lambdaExpr.substring(lambdaExpr.indexOf(40) + 1, lambdaExpr.indexOf(41));
            if (args.contains(",")) {
                String[] arguments = args.split(",");
                return DMVUtils.syntacticalPatternDiscovery(this, Double.parseDouble(arguments[0]), arguments[1]);
            }
            if (args.contains(";")) {
                String[] arguments = args.split(";");
                return EMAUtils.exponentialMovingAverageImputation(this, Integer.parseInt(arguments[0]), arguments[1], Integer.parseInt(arguments[2]), Double.parseDouble(arguments[3]), Double.parseDouble(arguments[4]), Double.parseDouble(arguments[5]));
            }
        }
        if (lambdaExpr.contains("jaccardSim")) {
            return this.mapDist(FrameBlock.getCompiledFunction(lambdaExpr));
        }
        return this.map(FrameBlock.getCompiledFunction(lambdaExpr));
    }

    public FrameBlock map(FrameMapFunction lambdaExpr) {
        String[][] output = new String[this.getNumRows()][this.getNumColumns()];
        for (int j = 0; j < this.getNumColumns(); ++j) {
            Array input = this.getColumn(j);
            for (int i = 0; i < input._size; ++i) {
                if (input.get(i) == null) continue;
                output[i][j] = lambdaExpr.apply(String.valueOf(input.get(i)));
            }
        }
        return new FrameBlock(UtilFunctions.nCopies(this.getNumColumns(), Types.ValueType.STRING), output);
    }

    public FrameBlock mapDist(FrameMapFunction lambdaExpr) {
        String[][] output;
        for (Object[] objectArray : output = new String[this.getNumRows()][this.getNumRows()]) {
            Arrays.fill(objectArray, "0.0");
        }
        Array input = this.getColumn(0);
        for (int j = 0; j < input._size - 1; ++j) {
            for (int i = j + 1; i < input._size; ++i) {
                if (input.get(i) == null || input.get(j) == null) continue;
                output[j][i] = lambdaExpr.apply(String.valueOf(input.get(j)), String.valueOf(input.get(i)));
            }
        }
        return new FrameBlock(UtilFunctions.nCopies(this.getNumRows(), Types.ValueType.STRING), output);
    }

    public static FrameMapFunction getCompiledFunction(String lambdaExpr) {
        String cname = "StringProcessing" + CLASS_ID.getNextID();
        StringBuilder sb = new StringBuilder();
        String[] parts = lambdaExpr.split("->");
        if (parts.length != 2) {
            throw new DMLRuntimeException("Unsupported lambda expression: " + lambdaExpr);
        }
        String[] varname = parts[0].replaceAll("[()]", "").split(",");
        String expr = parts[1].trim();
        sb.append("import org.apache.sysds.runtime.util.UtilFunctions;\n");
        sb.append("import org.apache.sysds.runtime.matrix.data.FrameBlock.FrameMapFunction;\n");
        sb.append("public class " + cname + " extends FrameMapFunction {\n");
        if (varname.length == 1) {
            sb.append("public String apply(String " + varname[0].trim() + ") {\n");
            sb.append("  return String.valueOf(" + expr + "); }}\n");
        } else if (varname.length == 2) {
            sb.append("public String apply(String " + varname[0].trim() + ", String " + varname[1].trim() + ") {\n");
            sb.append("  return String.valueOf(" + expr + "); }}\n");
        }
        try {
            return (FrameMapFunction)CodegenUtils.compileClass(cname, sb.toString()).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DMLRuntimeException("Failed to compile FrameMapFunction.", e);
        }
    }

    public static class FrameMapFunction
    implements Serializable {
        private static final long serialVersionUID = -8398572153616520873L;

        public String apply(String input) {
            return null;
        }

        public String apply(String input1, String input2) {
            return null;
        }
    }

    private static class DetectValueTypeTask
    implements Callable<String> {
        private final Array _obj;
        private final int _rows;
        private final int _sampleSize;

        protected DetectValueTypeTask(Array obj, int rows, int sampleSize) {
            this._obj = obj;
            this._rows = rows;
            this._sampleSize = sampleSize;
        }

        @Override
        public String call() {
            Types.ValueType state = Types.ValueType.UNKNOWN;
            for (int j = 0; j < this._sampleSize; ++j) {
                String dataValue;
                int randomIndex = ThreadLocalRandom.current().nextInt(0, this._rows - 1);
                String string = dataValue = this._obj.get(randomIndex) != null ? this._obj.get(randomIndex).toString().trim().replace("\"", "").toLowerCase() : null;
                if (dataValue == null) continue;
                Types.ValueType current = FrameBlock.isType(dataValue);
                if (current == Types.ValueType.STRING) {
                    state = Types.ValueType.STRING;
                    break;
                }
                if (current == Types.ValueType.FP64) {
                    state = Types.ValueType.FP64;
                    continue;
                }
                if (current == Types.ValueType.FP32) {
                    state = state == Types.ValueType.FP64 ? state : Types.ValueType.FP32;
                    continue;
                }
                if (current == Types.ValueType.INT64) {
                    state = state == Types.ValueType.FP64 || state == Types.ValueType.FP32 ? state : Types.ValueType.INT64;
                    continue;
                }
                if (current == Types.ValueType.INT32) {
                    state = state == Types.ValueType.FP64 || state == Types.ValueType.FP32 || state == Types.ValueType.INT64 ? state : Types.ValueType.INT32;
                    continue;
                }
                if (current != Types.ValueType.BOOLEAN) continue;
                state = state == Types.ValueType.FP64 || state == Types.ValueType.FP32 || state == Types.ValueType.INT64 || state == Types.ValueType.INT32 ? state : Types.ValueType.BOOLEAN;
            }
            return state.name();
        }
    }

    public static class ColumnMetadata
    implements Serializable {
        private static final long serialVersionUID = -90094082422100311L;
        private long _ndistinct = 0L;
        private String _mvValue = null;

        public ColumnMetadata(long ndistinct) {
            this._ndistinct = ndistinct;
        }

        public ColumnMetadata(long ndistinct, String mvval) {
            this._ndistinct = ndistinct;
            this._mvValue = mvval;
        }

        public ColumnMetadata(ColumnMetadata that) {
            this._ndistinct = that._ndistinct;
            this._mvValue = that._mvValue;
        }

        public long getNumDistinct() {
            return this._ndistinct;
        }

        public void setNumDistinct(long ndistinct) {
            this._ndistinct = ndistinct;
        }

        public String getMvValue() {
            return this._mvValue;
        }

        public void setMvValue(String mvVal) {
            this._mvValue = mvVal;
        }
    }

    private static class DoubleArray
    extends Array<Double> {
        private double[] _data = null;

        public DoubleArray(double[] data) {
            this._data = data;
            this._size = this._data.length;
        }

        @Override
        public Double get(int index) {
            return this._data[index];
        }

        @Override
        public void set(int index, Double value) {
            this._data[index] = value != null ? value : 0.0;
        }

        @Override
        public void set(int rl, int ru, Array value) {
            this.set(rl, ru, value, 0);
        }

        @Override
        public void set(int rl, int ru, Array value, int rlSrc) {
            System.arraycopy(((DoubleArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        }

        @Override
        public void setNz(int rl, int ru, Array value) {
            double[] data2 = ((DoubleArray)value)._data;
            for (int i = rl; i < ru + 1; ++i) {
                if (data2[i] == 0.0) continue;
                this._data[i] = data2[i];
            }
        }

        @Override
        public void append(String value) {
            this.append(value != null ? Double.valueOf(Double.parseDouble(value)) : null);
        }

        @Override
        public void append(Double value) {
            if (this._data.length <= this._size) {
                this._data = Arrays.copyOf(this._data, this.newSize());
            }
            this._data[this._size++] = value != null ? value : 0.0;
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < this._size; ++i) {
                out.writeDouble(this._data[i]);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this._size = this._data.length;
            for (int i = 0; i < this._size; ++i) {
                this._data[i] = in.readDouble();
            }
        }

        @Override
        public Array clone() {
            return new DoubleArray(Arrays.copyOf(this._data, this._size));
        }

        @Override
        public Array slice(int rl, int ru) {
            return new DoubleArray(Arrays.copyOfRange(this._data, rl, ru + 1));
        }

        @Override
        public void reset(int size) {
            if (this._data.length < size) {
                this._data = new double[size];
            }
            this._size = size;
        }
    }

    private static class FloatArray
    extends Array<Float> {
        private float[] _data = null;

        public FloatArray(float[] data) {
            this._data = data;
            this._size = this._data.length;
        }

        @Override
        public Float get(int index) {
            return Float.valueOf(this._data[index]);
        }

        @Override
        public void set(int index, Float value) {
            this._data[index] = value != null ? value.floatValue() : 0.0f;
        }

        @Override
        public void set(int rl, int ru, Array value) {
            this.set(rl, ru, value, 0);
        }

        @Override
        public void set(int rl, int ru, Array value, int rlSrc) {
            System.arraycopy(((FloatArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        }

        @Override
        public void setNz(int rl, int ru, Array value) {
            float[] data2 = ((FloatArray)value)._data;
            for (int i = rl; i < ru + 1; ++i) {
                if (data2[i] == 0.0f) continue;
                this._data[i] = data2[i];
            }
        }

        @Override
        public void append(String value) {
            this.append(value != null ? Float.valueOf(Float.parseFloat(value)) : null);
        }

        @Override
        public void append(Float value) {
            if (this._data.length <= this._size) {
                this._data = Arrays.copyOf(this._data, this.newSize());
            }
            this._data[this._size++] = value != null ? value.floatValue() : 0.0f;
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < this._size; ++i) {
                out.writeFloat(this._data[i]);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this._size = this._data.length;
            for (int i = 0; i < this._size; ++i) {
                this._data[i] = in.readFloat();
            }
        }

        @Override
        public Array clone() {
            return new FloatArray(Arrays.copyOf(this._data, this._size));
        }

        @Override
        public Array slice(int rl, int ru) {
            return new FloatArray(Arrays.copyOfRange(this._data, rl, ru + 1));
        }

        @Override
        public void reset(int size) {
            if (this._data.length < size) {
                this._data = new float[size];
            }
            this._size = size;
        }
    }

    private static class IntegerArray
    extends Array<Integer> {
        private int[] _data = null;

        public IntegerArray(int[] data) {
            this._data = data;
            this._size = this._data.length;
        }

        @Override
        public Integer get(int index) {
            return this._data[index];
        }

        @Override
        public void set(int index, Integer value) {
            this._data[index] = value != null ? value : 0;
        }

        @Override
        public void set(int rl, int ru, Array value) {
            this.set(rl, ru, value, 0);
        }

        @Override
        public void set(int rl, int ru, Array value, int rlSrc) {
            System.arraycopy(((IntegerArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        }

        @Override
        public void setNz(int rl, int ru, Array value) {
            int[] data2 = ((IntegerArray)value)._data;
            for (int i = rl; i < ru + 1; ++i) {
                if (data2[i] == 0) continue;
                this._data[i] = data2[i];
            }
        }

        @Override
        public void append(String value) {
            this.append(value != null ? Integer.valueOf(Integer.parseInt(value.trim())) : null);
        }

        @Override
        public void append(Integer value) {
            if (this._data.length <= this._size) {
                this._data = Arrays.copyOf(this._data, this.newSize());
            }
            this._data[this._size++] = value != null ? value : 0;
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < this._size; ++i) {
                out.writeLong(this._data[i]);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this._size = this._data.length;
            for (int i = 0; i < this._size; ++i) {
                this._data[i] = in.readInt();
            }
        }

        @Override
        public Array clone() {
            return new IntegerArray(Arrays.copyOf(this._data, this._size));
        }

        @Override
        public Array slice(int rl, int ru) {
            return new IntegerArray(Arrays.copyOfRange(this._data, rl, ru + 1));
        }

        @Override
        public void reset(int size) {
            if (this._data.length < size) {
                this._data = new int[size];
            }
            this._size = size;
        }
    }

    private static class LongArray
    extends Array<Long> {
        private long[] _data = null;

        public LongArray(long[] data) {
            this._data = data;
            this._size = this._data.length;
        }

        @Override
        public Long get(int index) {
            return this._data[index];
        }

        @Override
        public void set(int index, Long value) {
            this._data[index] = value != null ? value : 0L;
        }

        @Override
        public void set(int rl, int ru, Array value) {
            this.set(rl, ru, value, 0);
        }

        @Override
        public void set(int rl, int ru, Array value, int rlSrc) {
            System.arraycopy(((LongArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        }

        @Override
        public void setNz(int rl, int ru, Array value) {
            long[] data2 = ((LongArray)value)._data;
            for (int i = rl; i < ru + 1; ++i) {
                if (data2[i] == 0L) continue;
                this._data[i] = data2[i];
            }
        }

        @Override
        public void append(String value) {
            this.append(value != null ? Long.valueOf(Long.parseLong(value.trim())) : null);
        }

        @Override
        public void append(Long value) {
            if (this._data.length <= this._size) {
                this._data = Arrays.copyOf(this._data, this.newSize());
            }
            this._data[this._size++] = value != null ? value : 0L;
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < this._size; ++i) {
                out.writeLong(this._data[i]);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this._size = this._data.length;
            for (int i = 0; i < this._size; ++i) {
                this._data[i] = in.readLong();
            }
        }

        @Override
        public Array clone() {
            return new LongArray(Arrays.copyOf(this._data, this._size));
        }

        @Override
        public Array slice(int rl, int ru) {
            return new LongArray(Arrays.copyOfRange(this._data, rl, ru + 1));
        }

        @Override
        public void reset(int size) {
            if (this._data.length < size) {
                this._data = new long[size];
            }
            this._size = size;
        }
    }

    private static class BooleanArray
    extends Array<Boolean> {
        private boolean[] _data = null;

        public BooleanArray(boolean[] data) {
            this._data = data;
            this._size = this._data.length;
        }

        @Override
        public Boolean get(int index) {
            return this._data[index];
        }

        @Override
        public void set(int index, Boolean value) {
            this._data[index] = value != null ? value : false;
        }

        @Override
        public void set(int rl, int ru, Array value) {
            this.set(rl, ru, value, 0);
        }

        @Override
        public void set(int rl, int ru, Array value, int rlSrc) {
            System.arraycopy(((BooleanArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        }

        @Override
        public void setNz(int rl, int ru, Array value) {
            boolean[] data2 = ((BooleanArray)value)._data;
            for (int i = rl; i < ru + 1; ++i) {
                if (!data2[i]) continue;
                this._data[i] = data2[i];
            }
        }

        @Override
        public void append(String value) {
            this.append(Boolean.parseBoolean(value));
        }

        @Override
        public void append(Boolean value) {
            if (this._data.length <= this._size) {
                this._data = Arrays.copyOf(this._data, this.newSize());
            }
            this._data[this._size++] = value != null ? value : false;
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < this._size; ++i) {
                out.writeBoolean(this._data[i]);
            }
        }

        public void readFields(DataInput in) throws IOException {
            this._size = this._data.length;
            for (int i = 0; i < this._size; ++i) {
                this._data[i] = in.readBoolean();
            }
        }

        @Override
        public Array clone() {
            return new BooleanArray(Arrays.copyOf(this._data, this._size));
        }

        @Override
        public Array slice(int rl, int ru) {
            return new BooleanArray(Arrays.copyOfRange(this._data, rl, ru + 1));
        }

        @Override
        public void reset(int size) {
            if (this._data.length < size) {
                this._data = new boolean[size];
            }
            this._size = size;
        }
    }

    private static class StringArray
    extends Array<String> {
        private String[] _data = null;

        public StringArray(String[] data) {
            this._data = data;
            this._size = this._data.length;
        }

        @Override
        public String get(int index) {
            return this._data[index];
        }

        @Override
        public void set(int index, String value) {
            this._data[index] = value;
        }

        @Override
        public void set(int rl, int ru, Array value) {
            this.set(rl, ru, value, 0);
        }

        @Override
        public void set(int rl, int ru, Array value, int rlSrc) {
            System.arraycopy(((StringArray)value)._data, rlSrc, this._data, rl, ru - rl + 1);
        }

        @Override
        public void setNz(int rl, int ru, Array value) {
            String[] data2 = ((StringArray)value)._data;
            for (int i = rl; i < ru + 1; ++i) {
                if (data2[i] == null) continue;
                this._data[i] = data2[i];
            }
        }

        @Override
        public void append(String value) {
            if (this._data.length <= this._size) {
                this._data = Arrays.copyOf(this._data, this.newSize());
            }
            this._data[this._size++] = value;
        }

        public void write(DataOutput out) throws IOException {
            for (int i = 0; i < this._size; ++i) {
                out.writeUTF(this._data[i] != null ? this._data[i] : "");
            }
        }

        public void readFields(DataInput in) throws IOException {
            this._size = this._data.length;
            for (int i = 0; i < this._size; ++i) {
                String tmp = in.readUTF();
                this._data[i] = !tmp.isEmpty() ? tmp : null;
            }
        }

        @Override
        public Array clone() {
            return new StringArray(Arrays.copyOf(this._data, this._size));
        }

        @Override
        public Array slice(int rl, int ru) {
            return new StringArray(Arrays.copyOfRange(this._data, rl, ru + 1));
        }

        @Override
        public void reset(int size) {
            if (this._data.length < size) {
                this._data = new String[size];
            }
            this._size = size;
        }
    }

    private static abstract class Array<T>
    implements Writable {
        protected SoftReference<HashMap<String, Long>> _rcdMapCache = null;
        protected int _size = 0;

        private Array() {
        }

        protected int newSize() {
            return Math.max(this._size * 2, 4);
        }

        public abstract T get(int var1);

        public abstract void set(int var1, T var2);

        public abstract void set(int var1, int var2, Array var3);

        public abstract void set(int var1, int var2, Array var3, int var4);

        public abstract void setNz(int var1, int var2, Array var3);

        public abstract void append(String var1);

        public abstract void append(T var1);

        public abstract Array clone();

        public abstract Array slice(int var1, int var2);

        public abstract void reset(int var1);
    }

    private class ObjectRowIterator
    extends RowIterator<Object> {
        private Types.ValueType[] _tgtSchema;

        public ObjectRowIterator(int rl, int ru) {
            super(rl, ru);
            this._tgtSchema = null;
        }

        public ObjectRowIterator(int rl, int ru, int[] cols) {
            super(rl, ru, cols);
            this._tgtSchema = null;
        }

        public void setSchema(Types.ValueType[] schema) {
            this._tgtSchema = schema;
        }

        @Override
        protected Object[] createRow(int size) {
            return new Object[size];
        }

        @Override
        public Object[] next() {
            for (int j = 0; j < this._cols.length; ++j) {
                this._curRow[j] = this.getValue(this._curPos, this._cols[j] - 1);
            }
            ++this._curPos;
            return this._curRow;
        }

        private Object getValue(int i, int j) {
            Object val = FrameBlock.this.get(i, j);
            if (this._tgtSchema != null) {
                val = UtilFunctions.objectToObject(this._tgtSchema[j], val);
            }
            return val;
        }
    }

    private class StringRowIterator
    extends RowIterator<String> {
        public StringRowIterator(int rl, int ru) {
            super(rl, ru);
        }

        public StringRowIterator(int rl, int ru, int[] cols) {
            super(rl, ru, cols);
        }

        protected String[] createRow(int size) {
            return new String[size];
        }

        @Override
        public String[] next() {
            for (int j = 0; j < this._cols.length; ++j) {
                Object tmp = FrameBlock.this.get(this._curPos, this._cols[j] - 1);
                ((String[])this._curRow)[j] = tmp != null ? tmp.toString() : null;
            }
            ++this._curPos;
            return (String[])this._curRow;
        }
    }

    private abstract class RowIterator<T>
    implements Iterator<T[]> {
        protected final int[] _cols;
        protected final T[] _curRow;
        protected final int _maxPos;
        protected int _curPos = -1;

        protected RowIterator(int rl, int ru) {
            this(rl, ru, UtilFunctions.getSeqArray(1, frameBlock.getNumColumns(), 1));
        }

        protected RowIterator(int rl, int ru, int[] cols) {
            this._curRow = this.createRow(cols.length);
            this._cols = cols;
            this._maxPos = ru;
            this._curPos = rl;
        }

        @Override
        public boolean hasNext() {
            return this._curPos < this._maxPos;
        }

        @Override
        public void remove() {
            throw new RuntimeException("RowIterator.remove is unsupported!");
        }

        protected abstract T[] createRow(int var1);
    }
}

