/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;

public abstract class ColumnEncoder
implements Externalizable,
Encoder,
Comparable<ColumnEncoder> {
    protected static final Log LOG = LogFactory.getLog((String)ColumnEncoder.class.getName());
    private static final long serialVersionUID = 2299156350718979064L;
    protected int _colID;

    protected ColumnEncoder(int colID) {
        this._colID = colID;
    }

    public abstract MatrixBlock apply(MatrixBlock var1, MatrixBlock var2, int var3);

    public abstract MatrixBlock apply(MatrixBlock var1, MatrixBlock var2, int var3, int var4, int var5);

    public abstract MatrixBlock apply(FrameBlock var1, MatrixBlock var2, int var3, int var4, int var5);

    public boolean isApplicable() {
        return this._colID != -1;
    }

    public boolean isApplicable(int colID) {
        return colID == this._colID;
    }

    @Override
    public void prepareBuildPartial() {
    }

    @Override
    public void buildPartial(FrameBlock in) {
    }

    public void mergeAt(ColumnEncoder other) {
        throw new DMLRuntimeException(this.getClass().getSimpleName() + " does not support merging with " + other.getClass().getSimpleName());
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims, int colOffset) {
    }

    public MatrixBlock getColMapping(FrameBlock meta) {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeInt(this._colID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this._colID = in.readInt();
    }

    public int getColID() {
        return this._colID;
    }

    public void setColID(int colID) {
        this._colID = colID;
    }

    public void shiftCol(int columnOffset) {
        this._colID += columnOffset;
    }

    @Override
    public int compareTo(ColumnEncoder o) {
        return Integer.compare(EncoderFactory.getEncoderType(this), EncoderFactory.getEncoderType(o));
    }

    public abstract List<Callable<Object>> getPartialBuildTasks(FrameBlock var1, int var2);

    public abstract void mergeBuildPartial(List<Future<Object>> var1, int var2, int var3) throws ExecutionException, InterruptedException;

    public static enum EncoderType {
        Recode,
        FeatureHash,
        PassThrough,
        Bin,
        Dummycode,
        Omit,
        MVImpute,
        Composite;

    }
}

