/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.java;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;

abstract class JavaSparkContextVarargsWorkaround {
    JavaSparkContextVarargsWorkaround() {
    }

    @SafeVarargs
    public final <T> JavaRDD<T> union(JavaRDD<T> ... rdds) {
        if (rdds.length == 0) {
            throw new IllegalArgumentException("Union called on empty list");
        }
        ArrayList<JavaRDD<T>> rest = new ArrayList<JavaRDD<T>>(rdds.length - 1);
        for (int i = 1; i < rdds.length; ++i) {
            rest.add(rdds[i]);
        }
        return this.union(rdds[0], rest);
    }

    public JavaDoubleRDD union(JavaDoubleRDD ... rdds) {
        if (rdds.length == 0) {
            throw new IllegalArgumentException("Union called on empty list");
        }
        ArrayList<JavaDoubleRDD> rest = new ArrayList<JavaDoubleRDD>(rdds.length - 1);
        for (int i = 1; i < rdds.length; ++i) {
            rest.add(rdds[i]);
        }
        return this.union(rdds[0], rest);
    }

    @SafeVarargs
    public final <K, V> JavaPairRDD<K, V> union(JavaPairRDD<K, V> ... rdds) {
        if (rdds.length == 0) {
            throw new IllegalArgumentException("Union called on empty list");
        }
        ArrayList<JavaPairRDD<K, V>> rest = new ArrayList<JavaPairRDD<K, V>>(rdds.length - 1);
        for (int i = 1; i < rdds.length; ++i) {
            rest.add(rdds[i]);
        }
        return this.union(rdds[0], rest);
    }

    public abstract <T> JavaRDD<T> union(JavaRDD<T> var1, List<JavaRDD<T>> var2);

    public abstract JavaDoubleRDD union(JavaDoubleRDD var1, List<JavaDoubleRDD> var2);

    public abstract <K, V> JavaPairRDD<K, V> union(JavaPairRDD<K, V> var1, List<JavaPairRDD<K, V>> var2);
}

