/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroRecordReaderBase;

public class AvroKeyValueRecordReader<K, V>
extends AvroRecordReaderBase<AvroKey<K>, AvroValue<V>, GenericRecord> {
    private final AvroKey<K> mCurrentKey = new AvroKey<Object>(null);
    private final AvroValue<V> mCurrentValue = new AvroValue<Object>(null);

    public AvroKeyValueRecordReader(Schema keyReaderSchema, Schema valueReaderSchema) {
        super(AvroKeyValue.getSchema(keyReaderSchema, valueReaderSchema));
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean hasNext = super.nextKeyValue();
        if (hasNext) {
            AvroKeyValue avroKeyValue = new AvroKeyValue((GenericRecord)this.getCurrentRecord());
            this.mCurrentKey.datum(avroKeyValue.getKey());
            this.mCurrentValue.datum(avroKeyValue.getValue());
        } else {
            this.mCurrentKey.datum(null);
            this.mCurrentValue.datum(null);
        }
        return hasNext;
    }

    public AvroKey<K> getCurrentKey() throws IOException, InterruptedException {
        return this.mCurrentKey;
    }

    public AvroValue<V> getCurrentValue() throws IOException, InterruptedException {
        return this.mCurrentValue;
    }
}

