/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupOLE
extends AColGroupOffset {
    private static final long serialVersionUID = 5723227906925121066L;

    protected ColGroupOLE(int numRows) {
        super(numRows);
    }

    protected ColGroupOLE(int[] colIndices, int numRows, boolean zeros, ADictionary dict, char[] bitmaps, int[] bitmapOffs, int[] counts) {
        super(colIndices, numRows, zeros, dict, counts);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.OLE;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.OLE;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        throw new NotImplementedException();
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        throw new NotImplementedException();
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int blen = this.len(k);
            int count = 0;
            int boff = this._ptr[k];
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows - sum;
        }
        return counts;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupOLE(this._colIndexes, this._numRows, this._zeros, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, false, this._dict.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        throw new NotImplementedException("Not implemented because dictionaries no longer should support extending by a tuple Ideally implement a modification such that OLE becomes SDC group when materializing Zero tuples");
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        throw new NotImplementedException();
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        double[] values = this._dict.getValues();
        for (int k = 0; k < numVals; ++k) {
            int slen;
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin, values);
            int bix = this.skipScanVal(k, rl);
            for (int off = (rl + 1) / 65535 * 65535; bix < blen && off < ru; bix += slen + '\u0001', off += 65535) {
                slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int rix = off + this._data[boff + bix + i];
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    @Override
    protected boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int blksz = 65535;
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int off = 0;
            int bix = 0;
            while (bix < blen) {
                int slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int n = off + this._data[boff + bix + i];
                    ret[n] = ret[n] & false;
                }
                bix += slen + '\u0001';
                off += 65535;
            }
        }
        return ret;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int blksz = 65535;
        int blksz2 = 131070;
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] apos = this.skipScan(numVals, rl);
        for (int bi = rl; bi < ru; bi += 131070) {
            int bimax = Math.min(bi + 131070, ru);
            for (int k = 0; k < numVals; ++k) {
                int slen;
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = apos[k];
                for (int off = bi; bix < blen && off < bimax; bix += slen + '\u0001', off += 65535) {
                    slen = this._data[boff + bix];
                    for (int blckIx = 1; blckIx <= slen; ++blckIx) {
                        int n = off + this._data[boff + bix + blckIx] - rl;
                        rnnz[n] = rnnz[n] + numCols;
                    }
                }
                apos[k] = bix;
            }
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        int[] apos = this.skipScan(numVals, r);
        int offset = r % 65535;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = apos[k];
            int slen = this._data[boff + bix];
            for (int blckIx = 1; blckIx <= slen && blckIx < blen; ++blckIx) {
                if (this._data[boff + bix + blckIx] == offset) {
                    return this._dict.getValue(k * this._colIndexes.length + colIdx);
                }
                if (this._data[boff + bix + blckIx] <= offset) continue;
            }
        }
        return 0.0;
    }

    private int[] skipScan(int numVals, int rl) {
        int blksz = 65535;
        rl = rl / 65535 * 65535;
        int[] ret = new int[numVals];
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                int bix = 0;
                for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65535) {
                }
                ret[k] = bix;
            }
        }
        return ret;
    }

    private int skipScanVal(int k, int rl) {
        int blksz = 65535;
        if (rl > 0) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = 0;
            int bix = 0;
            for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65535) {
            }
            return bix;
        }
        return 0;
    }

    @Override
    public void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    public void tsmmAColGroup(AColGroup other, MatrixBlock result) {
        throw new NotImplementedException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d", "Data:", this._data.length));
        sb.append(ColGroupOLE.charsToString(this._data));
        return sb.toString();
    }

    public static char[] genOffsetBitmap(int[] offsets, int len) {
        if (offsets == null || offsets.length == 0 || len == 0) {
            return null;
        }
        int lastOffset = offsets[len - 1];
        int numBlocks = lastOffset / 65535 + 1;
        int[] blockLengths = new int[numBlocks];
        for (int ix = 0; ix < len; ++ix) {
            int blockForVal;
            int val = offsets[ix];
            int n = blockForVal = val / 65535;
            blockLengths[n] = blockLengths[n] + 1;
        }
        int totalSize = numBlocks;
        for (int block = 0; block < numBlocks; ++block) {
            totalSize += blockLengths[block];
        }
        char[] encodedBlocks = new char[totalSize];
        int inputIx = 0;
        int blockStartIx = 0;
        for (int block = 0; block < numBlocks; ++block) {
            int blockSz = blockLengths[block];
            encodedBlocks[blockStartIx] = (char)blockSz;
            for (int i = 0; i < blockSz; ++i) {
                encodedBlocks[blockStartIx + i + 1] = (char)(offsets[inputIx + i] % 65535);
            }
            inputIx += blockSz;
            blockStartIx += blockSz + 1;
        }
        return encodedBlocks;
    }
}

