/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToCharPByte
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    public static final int max = 8322945;
    private final char[] _data_c;
    private final byte[] _data_b;

    protected MapToCharPByte(int size) {
        this(65535, size);
    }

    public MapToCharPByte(int unique, int size) {
        super(Math.min(unique, 8322945));
        this._data_c = new char[size];
        this._data_b = new byte[size];
    }

    public MapToCharPByte(int unique, char[] data_c, byte[] data_b) {
        super(unique);
        this._data_c = data_c;
        this._data_b = data_b;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.CHAR_BYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data_c[n] + (this._data_b[n] << 16);
    }

    @Override
    public void fill(int v) {
        int m = v & 0xFFFFFF;
        Arrays.fill(this._data_c, (char)m);
        Arrays.fill(this._data_b, (byte)(m >> 16));
    }

    @Override
    public long getInMemorySize() {
        return MapToCharPByte.getInMemorySize(this._data_c.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 32L;
        size += MemoryEstimates.charArrayCost(dataLength);
        return size += MemoryEstimates.byteArrayCost(dataLength);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data_c.length * 3;
    }

    @Override
    public void set(int n, int v) {
        int m = v & 0xFFFFFF;
        this._data_c[n] = (char)m;
        this._data_b[n] = (byte)(m >> 16);
    }

    @Override
    public int setAndGet(int n, int v) {
        int m = v & 0xFFFFFF;
        this._data_c[n] = (char)m;
        this._data_b[n] = (byte)(m >> 16);
        return m;
    }

    @Override
    public int size() {
        return this._data_c.length;
    }

    @Override
    public void replace(int v, int r) {
        int m = v & 0xFFFFFF;
        int mr = r & 0xFFFFFF;
        char c = (char)m;
        char cr = (char)mr;
        byte b = (byte)(m >> 16);
        byte br = (byte)(mr >> 16);
        for (int i = 0; i < this._data_c.length; ++i) {
            if (this._data_b[i] != b || this._data_c[i] != c) continue;
            this._data_b[i] = br;
            this._data_c[i] = cr;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        out.writeByte(MapToFactory.MAP_TYPE.CHAR_BYTE.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data_c.length);
        for (i = 0; i < this._data_c.length; ++i) {
            out.writeChar(this._data_c[i]);
        }
        for (i = 0; i < this._data_c.length; ++i) {
            out.writeByte(this._data_b[i]);
        }
    }

    protected static MapToCharPByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data_c = new char[length];
        for (int i = 0; i < length; ++i) {
            data_c[i] = in.readChar();
        }
        byte[] data_b = new byte[length];
        for (int i = 0; i < length; ++i) {
            data_b[i] = in.readByte();
        }
        return new MapToCharPByte(unique, data_c, data_b);
    }

    protected char[] getChars() {
        return this._data_c;
    }

    protected byte[] getBytes() {
        return this._data_b;
    }

    @Override
    public int getUpperBoundValue() {
        return 8322945;
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.set(i, d[i]);
        }
    }

    @Override
    public void copyBit(BitSet d) {
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data_c[i] = '\u0001';
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data_c.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else if (unique < 65534) {
            ret = new MapToChar(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ((AMapToData)ret).copy(this);
        return ret;
    }
}

