/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;

public class CompressedSizeInfoColGroup {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeInfoColGroup.class.getName());
    private final int[] _cols;
    private final EstimationFactors _facts;
    private final double _cardinalityRatio;
    private final long _minSize;
    private final AColGroup.CompressionType _bestCompressionType;
    private final EnumMap<AColGroup.CompressionType, Long> _sizes;
    private IEncode _map;

    protected CompressedSizeInfoColGroup(int[] columns, EstimationFactors facts, Set<AColGroup.CompressionType> validCompressionTypes, IEncode map) {
        this._cols = columns;
        this._facts = facts;
        this._cardinalityRatio = (double)facts.numVals / (double)facts.numRows;
        this._sizes = CompressedSizeInfoColGroup.calculateCompressionSizes(this._cols.length, facts, validCompressionTypes);
        Map.Entry<AColGroup.CompressionType, Long> bestEntry = null;
        for (Map.Entry<AColGroup.CompressionType, Long> ent : this._sizes.entrySet()) {
            if (bestEntry != null && ent.getValue() >= bestEntry.getValue()) continue;
            bestEntry = ent;
        }
        this._bestCompressionType = (AColGroup.CompressionType)((Object)bestEntry.getKey());
        this._minSize = bestEntry.getValue();
        this._map = map;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)this);
        }
    }

    public CompressedSizeInfoColGroup(int[] columns, int nRows) {
        this._cols = columns;
        this._facts = new EstimationFactors(columns.length, 0, nRows);
        this._cardinalityRatio = 0.0;
        this._sizes = new EnumMap(AColGroup.CompressionType.class);
        AColGroup.CompressionType ct = AColGroup.CompressionType.EMPTY;
        this._sizes.put(ct, ColGroupSizes.estimateInMemorySizeEMPTY(columns.length));
        this._bestCompressionType = ct;
        this._minSize = this._sizes.get((Object)ct);
        this._map = null;
    }

    public long getCompressionSize(AColGroup.CompressionType ct) {
        if (this._sizes != null) {
            Long s = this._sizes.get((Object)ct);
            if (s == null) {
                throw new DMLCompressionException("Asked for valid " + ct + " but got null. contains:" + this._sizes);
            }
            return this._sizes.get((Object)ct);
        }
        throw new DMLCompressionException("There was no encodings analyzed");
    }

    public AColGroup.CompressionType getBestCompressionType(CompressionSettings cs) {
        return this._bestCompressionType;
    }

    public AColGroup.CompressionType getBestCompressionType() {
        return this._bestCompressionType;
    }

    public Map<AColGroup.CompressionType, Long> getAllCompressionSizes() {
        return this._sizes;
    }

    public long getMinSize() {
        return this._minSize;
    }

    public int getNumVals() {
        return this._facts != null ? this._facts.numVals : -1;
    }

    public int getNumOffs() {
        return this._facts.numOffs;
    }

    public int[] getColumns() {
        return this._cols;
    }

    public int getNumRows() {
        return this._facts.numRows;
    }

    public double getCardinalityRatio() {
        return this._cardinalityRatio;
    }

    public double getMostCommonFraction() {
        return (double)this._facts.largestOff / (double)this._facts.numRows;
    }

    public int getLargestOffInstances() {
        return this._facts.largestOff;
    }

    public double getTupleSparsity() {
        return this._facts.tupleSparsity;
    }

    public IEncode getMap() {
        return this._map;
    }

    public boolean containsZeros() {
        return this._facts.numOffs < this._facts.numRows;
    }

    private static EnumMap<AColGroup.CompressionType, Long> calculateCompressionSizes(int numCols, EstimationFactors fact, Set<AColGroup.CompressionType> validCompressionTypes) {
        EnumMap<AColGroup.CompressionType, Long> res = new EnumMap<AColGroup.CompressionType, Long>(AColGroup.CompressionType.class);
        for (AColGroup.CompressionType ct : validCompressionTypes) {
            long compSize = CompressedSizeInfoColGroup.getCompressionSize(numCols, ct, fact);
            if (compSize <= 0L) continue;
            res.put(ct, compSize);
        }
        return res;
    }

    public boolean isEmpty() {
        return this._bestCompressionType == AColGroup.CompressionType.EMPTY;
    }

    public boolean isConst() {
        return this._bestCompressionType == AColGroup.CompressionType.CONST;
    }

    private static long getCompressionSize(int numCols, AColGroup.CompressionType ct, EstimationFactors fact) {
        switch (ct) {
            case DeltaDDC: 
            case DDC: {
                int nv = fact.numVals + (fact.numOffs < fact.numRows ? 1 : 0);
                return ColGroupSizes.estimateInMemorySizeDDC(numCols, nv, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case RLE: {
                throw new NotImplementedException();
            }
            case OLE: {
                int nv = fact.numVals + (fact.zeroIsMostFrequent ? 1 : 0);
                return ColGroupSizes.estimateInMemorySizeOLE(numCols, nv, fact.numOffs + fact.numVals, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case UNCOMPRESSED: {
                return ColGroupSizes.estimateInMemorySizeUncompressed(fact.numRows, numCols, fact.overAllSparsity);
            }
            case SDC: {
                return ColGroupSizes.estimateInMemorySizeSDC(numCols, fact.numVals, fact.numRows, fact.largestOff, fact.tupleSparsity, fact.zeroIsMostFrequent, fact.lossy);
            }
            case CONST: {
                if (fact.numOffs == fact.numRows && fact.numVals == 1) {
                    return ColGroupSizes.estimateInMemorySizeCONST(numCols, fact.tupleSparsity, fact.lossy);
                }
                return -1L;
            }
            case EMPTY: {
                if (fact.numOffs == 0) {
                    return ColGroupSizes.estimateInMemorySizeEMPTY(numCols);
                }
                return -1L;
            }
        }
        throw new NotImplementedException("The col compression Type is not yet supported");
    }

    public void clearMap() {
        this._map = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("cols: " + Arrays.toString(this._cols));
        sb.append(String.format(" common: %4.3f", this.getMostCommonFraction()));
        sb.append(" Sizes: ");
        sb.append(this._sizes);
        sb.append(" facts: " + this._facts);
        sb.append("\n" + this._map);
        return sb.toString();
    }
}

