/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.IndexRange;

public class FederationMap {
    private long _ID = -1L;
    private final List<Pair<FederatedRange, FederatedData>> _fedMap;
    private FTypes.FType _type;

    public FederationMap(List<Pair<FederatedRange, FederatedData>> fedMap) {
        this(-1L, fedMap);
    }

    public FederationMap(long ID, List<Pair<FederatedRange, FederatedData>> fedMap) {
        this(ID, fedMap, FTypes.FType.OTHER);
    }

    public FederationMap(long ID, List<Pair<FederatedRange, FederatedData>> fedMap, FTypes.FType type) {
        this._ID = ID;
        this._fedMap = fedMap;
        this._type = type;
    }

    public long getID() {
        return this._ID;
    }

    public FTypes.FType getType() {
        return this._type;
    }

    public boolean isInitialized() {
        return this._ID >= 0L;
    }

    public void setType(FTypes.FType type) {
        this._type = type;
    }

    public int getSize() {
        return this._fedMap.size();
    }

    public FederatedRange[] getFederatedRanges() {
        return (FederatedRange[])this._fedMap.stream().map(e -> (FederatedRange)e.getKey()).toArray(FederatedRange[]::new);
    }

    public FederatedData[] getFederatedData() {
        return (FederatedData[])this._fedMap.stream().map(e -> (FederatedData)e.getValue()).toArray(FederatedData[]::new);
    }

    private FederatedData getFederatedData(FederatedRange range) {
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            if (!((FederatedRange)e.getKey()).equals(range)) continue;
            return (FederatedData)e.getValue();
        }
        return null;
    }

    private void removeFederatedData(FederatedRange range) {
        Iterator<Pair<FederatedRange, FederatedData>> iter = this._fedMap.iterator();
        while (iter.hasNext()) {
            if (!((FederatedRange)iter.next().getKey()).equals(range)) continue;
            iter.remove();
        }
    }

    public List<Pair<FederatedRange, FederatedData>> getMap() {
        return this._fedMap;
    }

    public FederatedRequest broadcast(CacheableData<?> data) {
        return this.broadcast(data, null);
    }

    public FederatedRequest broadcast(MatrixLineagePair moLin) {
        return this.broadcast(moLin.getMO(), moLin.getLI());
    }

    private FederatedRequest broadcast(CacheableData<?> data, LineageItem lineageItem) {
        if (data.isFederated(FTypes.FType.BROADCAST)) {
            return new FederatedRequest(FederatedRequest.RequestType.NOOP, data.getFedMapping().getID());
        }
        long id = FederationUtils.getNextFedDataID();
        Object cb = data.acquireReadAndRelease();
        data.setFedMapping(this.copyWithNewIDAndRange(cb.getNumRows(), cb.getNumColumns(), id, FTypes.FType.BROADCAST));
        return new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, lineageItem, id, cb);
    }

    public FederatedRequest broadcast(ScalarObject scalar) {
        long id = FederationUtils.getNextFedDataID();
        return new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, scalar);
    }

    public FederatedRequest[] broadcastSliced(CacheableData<?> data, boolean transposed) {
        return this.broadcastSliced(data, null, transposed);
    }

    public FederatedRequest[] broadcastSliced(MatrixLineagePair moLin, boolean transposed) {
        return this.broadcastSliced(moLin.getMO(), moLin.getLI(), transposed);
    }

    private FederatedRequest[] broadcastSliced(CacheableData<?> data, LineageItem lineageItem, boolean transposed) {
        if (this._type == FTypes.FType.FULL) {
            return new FederatedRequest[]{this.broadcast(data)};
        }
        long id = FederationUtils.getNextFedDataID();
        Object cb = data.acquireReadAndRelease();
        int[][] ix = new int[this._fedMap.size()][];
        int pos = 0;
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            int[] nArray;
            int beg = ((FederatedRange)e.getKey()).getBeginDimsInt()[this._type == FTypes.FType.ROW ? 0 : 1];
            int end = ((FederatedRange)e.getKey()).getEndDimsInt()[this._type == FTypes.FType.ROW ? 0 : 1];
            int nr = this._type == FTypes.FType.ROW ? cb.getNumRows() : cb.getNumColumns();
            int nc = this._type == FTypes.FType.ROW ? cb.getNumColumns() : cb.getNumRows();
            int rl = transposed ? 0 : beg;
            int ru = transposed ? nr - 1 : end - 1;
            int cl = transposed ? beg : 0;
            int cu = transposed ? end - 1 : nc - 1;
            int n = pos++;
            if (this._type == FTypes.FType.ROW) {
                int[] nArray2 = new int[4];
                nArray2[0] = rl;
                nArray2[1] = ru;
                nArray2[2] = cl;
                nArray = nArray2;
                nArray2[3] = cu;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = cl;
                nArray3[1] = cu;
                nArray3[2] = rl;
                nArray = nArray3;
                nArray3[3] = ru;
            }
            ix[n] = nArray;
        }
        FederationMap bmap = this.copyWithNewIDAndRange(ix, id, this._type == FTypes.FType.ROW || this._type == FTypes.FType.COL & transposed ? FTypes.FType.ROW : FTypes.FType.COL);
        FederatedRequest[] ret = new FederatedRequest[ix.length];
        if (data.isFederated(bmap.getType()) && data.getFedMapping().isAligned(bmap, false)) {
            Arrays.setAll(ret, i -> new FederatedRequest(FederatedRequest.RequestType.NOOP, data.getFedMapping().getID()));
            data.setFedMapping(bmap);
        } else {
            Arrays.parallelSetAll(ret, i -> this.sliceBroadcastBlock(ix[i], id, (CacheBlock)cb, lineageItem, false));
        }
        return ret;
    }

    public FederatedRequest[] broadcastSliced(CacheableData<?> data, boolean isFrame, int[][] ix) {
        return this.broadcastSliced(data, null, isFrame, ix);
    }

    public FederatedRequest[] broadcastSliced(MatrixLineagePair moLin, boolean isFrame, int[][] ix) {
        return this.broadcastSliced(moLin.getMO(), moLin.getLI(), isFrame, ix);
    }

    public FederatedRequest[] broadcastSliced(CacheableData<?> data, LineageItem lineageItem, boolean isFrame, int[][] ix) {
        if (this._type == FTypes.FType.FULL) {
            return new FederatedRequest[]{this.broadcast(data)};
        }
        long id = FederationUtils.getNextFedDataID();
        Object cb = data.acquireReadAndRelease();
        FederatedRequest[] ret = new FederatedRequest[ix.length];
        Arrays.setAll(ret, i -> this.sliceBroadcastBlock(ix[i], id, (CacheBlock)cb, lineageItem, isFrame));
        return ret;
    }

    private FederatedRequest sliceBroadcastBlock(int[] ix, long id, CacheBlock cb, LineageItem objLi, boolean isFrame) {
        LineageItem li = null;
        if (objLi != null) {
            CPOperand rl = new CPOperand(String.valueOf(ix[0] + 1), Types.ValueType.INT64, Types.DataType.SCALAR, true);
            CPOperand ru = new CPOperand(String.valueOf(ix[1] + 1), Types.ValueType.INT64, Types.DataType.SCALAR, true);
            CPOperand cl = new CPOperand(String.valueOf(ix[2] + 1), Types.ValueType.INT64, Types.DataType.SCALAR, true);
            CPOperand cu = new CPOperand(String.valueOf(ix[3] + 1), Types.ValueType.INT64, Types.DataType.SCALAR, true);
            li = new LineageItem("rightIndex", new LineageItem[]{objLi, rl.getLiteralLineageItem(), ru.getLiteralLineageItem(), cl.getLiteralLineageItem(), cu.getLiteralLineageItem()});
        }
        FederatedRequest fr = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, li, id, cb.slice(ix[0], ix[1], ix[2], ix[3], isFrame ? new FrameBlock() : new MatrixBlock()));
        return fr;
    }

    public boolean isAligned(FederationMap that, FTypes.AlignType ... alignTypes) {
        boolean ret = false;
        for (FTypes.AlignType at : alignTypes) {
            ret = at.isFullType() ? (ret |= this.isAligned(that, at.isTransposed())) : (ret |= this.isAligned(that, at.isTransposed(), at.isRowType(), at.isColType()));
            if (ret) break;
        }
        return ret;
    }

    public boolean isAligned(FederationMap that, boolean transposed) {
        boolean ret = true;
        if (this._type == FTypes.FType.BROADCAST) {
            return false;
        }
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            FederatedRange range = !transposed ? (FederatedRange)e.getKey() : new FederatedRange((FederatedRange)e.getKey()).transpose();
            FederatedData dat2 = that.getFederatedData(range);
            ret &= ((FederatedData)e.getValue()).equalAddress(dat2);
        }
        return ret;
    }

    public boolean isAligned(FederationMap that, boolean transposed, boolean equalRows, boolean equalCols) {
        boolean ret = true;
        int ROW_IX = transposed ? 1 : 0;
        int COL_IX = transposed ? 0 : 1;
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            boolean rangeFound = false;
            for (FederatedRange r : that.getFederatedRanges()) {
                long[] rbd = r.getBeginDims();
                long[] red = r.getEndDims();
                long[] ebd = ((FederatedRange)e.getKey()).getBeginDims();
                long[] eed = ((FederatedRange)e.getKey()).getEndDims();
                if (equalRows && (rbd[ROW_IX] != ebd[0] || red[ROW_IX] != eed[0]) || equalCols && (rbd[COL_IX] != ebd[1] || red[COL_IX] != eed[1])) continue;
                rangeFound = true;
                FederatedData dat2 = that.getFederatedData(r);
                ret &= ((FederatedData)e.getValue()).equalAddress(dat2);
            }
            if (ret &= rangeFound) continue;
            break;
        }
        return ret;
    }

    public Future<FederatedResponse>[] execute(long tid, FederatedRequest ... fr) {
        return this.execute(tid, false, fr);
    }

    public Future<FederatedResponse>[] execute(long tid, boolean wait, FederatedRequest ... fr) {
        return this.execute(tid, wait, (FederatedRequest[])null, fr);
    }

    public Future<FederatedResponse>[] execute(long tid, FederatedRequest[] frSlices, FederatedRequest ... fr) {
        return this.execute(tid, false, frSlices, fr);
    }

    public Future<FederatedResponse>[] execute(long tid, boolean wait, FederatedRequest[] frSlices, FederatedRequest ... fr) {
        FederationMap.setThreadID(tid, frSlices, fr);
        ArrayList<Future<FederatedResponse>> ret = new ArrayList<Future<FederatedResponse>>();
        int pos = 0;
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            ret.add(((FederatedData)e.getValue()).executeFederatedOperation(frSlices != null ? FederationMap.addAll(frSlices[pos++], fr) : fr));
        }
        if (wait) {
            FederationUtils.waitFor(ret);
        }
        return ret.toArray(new Future[0]);
    }

    public Future<FederatedResponse>[] execute(long tid, boolean wait, FederatedRange[] fedRange1, FederatedRequest elseFr, FederatedRequest frSlice1, FederatedRequest frSlice2, FederatedRequest fr) {
        return this.execute(tid, wait, fedRange1, elseFr, new FederatedRequest[]{frSlice1}, new FederatedRequest[]{frSlice2}, fr);
    }

    public Future<FederatedResponse>[] execute(long tid, boolean wait, FederatedRange[] fedRange1, FederatedRequest elseFr, FederatedRequest[] frSlices1, FederatedRequest[] frSlices2, FederatedRequest ... fr) {
        FederationMap.setThreadID(tid, frSlices1, fr);
        FederationMap.setThreadID(tid, frSlices2, fr);
        ArrayList<Future<FederatedResponse>> ret = new ArrayList<Future<FederatedResponse>>();
        int pos = 0;
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            if (Arrays.asList(fedRange1).contains(e.getKey())) {
                FederatedRequest[] newFr = frSlices1 != null ? (frSlices2 != null ? FederationMap.addAll(frSlices2[pos], FederationMap.addAll(frSlices1[pos++], fr)) : FederationMap.addAll(frSlices1[pos++], fr)) : fr;
                ret.add(((FederatedData)e.getValue()).executeFederatedOperation(newFr));
                continue;
            }
            ret.add(((FederatedData)e.getValue()).executeFederatedOperation(elseFr));
        }
        if (wait) {
            FederationUtils.waitFor(ret);
        }
        return ret.toArray(new Future[0]);
    }

    public Future<FederatedResponse>[] execute(long tid, boolean wait, FederatedRequest[] frSlices1, FederatedRequest[] frSlices2, FederatedRequest ... fr) {
        return this.execute(tid, wait, (FederatedRange[])this._fedMap.stream().map(e -> (FederatedRange)e.getKey()).toArray(FederatedRange[]::new), null, frSlices1, frSlices2, fr);
    }

    public Future<FederatedResponse>[] executeMultipleSlices(long tid, boolean wait, FederatedRequest[][] frSlices, FederatedRequest[] fr) {
        FederatedRequest[] allSlices = (FederatedRequest[])Arrays.stream(frSlices).flatMap(Stream::of).toArray(FederatedRequest[]::new);
        FederationMap.setThreadID(tid, allSlices, fr);
        ArrayList<Future<FederatedResponse>> ret = new ArrayList<Future<FederatedResponse>>();
        int pos = 0;
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            FederatedRequest[] fedReq = fr;
            for (FederatedRequest[] slice : frSlices) {
                fedReq = FederationMap.addAll(slice[pos], fedReq);
            }
            ret.add(((FederatedData)e.getValue()).executeFederatedOperation(fedReq));
            ++pos;
        }
        if (wait) {
            FederationUtils.waitFor(ret);
        }
        return ret.toArray(new Future[0]);
    }

    public List<Pair<FederatedRange, Future<FederatedResponse>>> requestFederatedData() {
        if (!this.isInitialized()) {
            throw new DMLRuntimeException("Federated matrix read only supported on initialized FederatedData");
        }
        ArrayList<Pair<FederatedRange, Future<FederatedResponse>>> readResponses = new ArrayList<Pair<FederatedRange, Future<FederatedResponse>>>();
        FederatedRequest request = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, this._ID);
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            readResponses.add((Pair<FederatedRange, Future<FederatedResponse>>)Pair.of((Object)((FederatedRange)e.getKey()), ((FederatedData)e.getValue()).executeFederatedOperation(request)));
        }
        return readResponses;
    }

    public FederatedRequest cleanup(long tid, long ... id) {
        FederatedRequest request = new FederatedRequest(FederatedRequest.RequestType.EXEC_INST, -1L, VariableCPInstruction.prepareRemoveInstruction(id).toString());
        request.setTID(tid);
        return request;
    }

    public void execCleanup(long tid, long ... id) {
        FederatedRequest request = new FederatedRequest(FederatedRequest.RequestType.EXEC_INST, -1L, VariableCPInstruction.prepareRemoveInstruction(id).toString());
        request.setTID(tid);
        ArrayList<Future<FederatedResponse>> tmp = new ArrayList<Future<FederatedResponse>>();
        for (Pair<FederatedRange, FederatedData> fd : this._fedMap) {
            tmp.add(((FederatedData)fd.getValue()).executeFederatedOperation(request));
        }
    }

    private static FederatedRequest[] addAll(FederatedRequest a, FederatedRequest[] b) {
        if (b == null || b.length == 0) {
            return new FederatedRequest[]{a};
        }
        FederatedRequest[] ret = new FederatedRequest[b.length + 1];
        ret[0] = a;
        System.arraycopy(b, 0, ret, 1, b.length);
        return ret;
    }

    public FederationMap identCopy(long tid, long id) {
        Future<FederatedResponse>[] copyInstr;
        for (Future<FederatedResponse> future : copyInstr = this.execute(tid, new FederatedRequest(FederatedRequest.RequestType.EXEC_INST, this._ID, VariableCPInstruction.prepareCopyInstruction(Long.toString(this._ID), Long.toString(id)).toString()))) {
            try {
                FederatedResponse response = future.get();
                if (response.isSuccessful()) continue;
                response.throwExceptionFromResponse();
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        }
        FederationMap copyFederationMap = this.copyWithNewID(id);
        copyFederationMap._type = this._type;
        return copyFederationMap;
    }

    public FederationMap copyWithNewID() {
        return this.copyWithNewID(FederationUtils.getNextFedDataID());
    }

    public FederationMap copyWithNewID(long id) {
        ArrayList<Pair<FederatedRange, FederatedData>> map = new ArrayList<Pair<FederatedRange, FederatedData>>();
        for (Map.Entry entry : this._fedMap) {
            if (((FederatedRange)entry.getKey()).getSize() == 0L) continue;
            map.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)new FederatedRange((FederatedRange)entry.getKey()), (Object)((FederatedData)entry.getValue()).copyWithNewID(id)));
        }
        return new FederationMap(id, map, this._type);
    }

    public FederationMap copyWithNewID(long id, long clen) {
        ArrayList<Pair<FederatedRange, FederatedData>> map = new ArrayList<Pair<FederatedRange, FederatedData>>();
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            map.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)new FederatedRange((FederatedRange)e.getKey(), clen), (Object)((FederatedData)e.getValue()).copyWithNewID(id)));
        }
        return new FederationMap(id, map, this._type);
    }

    public FederationMap copyWithNewIDAndRange(long rowRangeEnd, long colRangeEnd, long outputID) {
        return this.copyWithNewIDAndRange(rowRangeEnd, colRangeEnd, outputID, FTypes.FType.PART);
    }

    public FederationMap copyWithNewIDAndRange(long rowRangeEnd, long colRangeEnd, long outputID, FTypes.FType type) {
        ArrayList<Pair<FederatedRange, FederatedData>> outputMap = new ArrayList<Pair<FederatedRange, FederatedData>>();
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            if (((FederatedRange)e.getKey()).getSize() == 0L) continue;
            outputMap.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)new FederatedRange(new long[]{0L, 0L}, new long[]{rowRangeEnd, colRangeEnd}), (Object)((FederatedData)e.getValue()).copyWithNewID(outputID)));
        }
        return new FederationMap(outputID, outputMap, type);
    }

    public FederationMap copyWithNewIDAndRange(int[][] ix, long outputID, FTypes.FType type) {
        ArrayList<Pair<FederatedRange, FederatedData>> outputMap = new ArrayList<Pair<FederatedRange, FederatedData>>();
        int pos = 0;
        for (Pair<FederatedRange, FederatedData> e : this._fedMap) {
            outputMap.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)new FederatedRange(new long[]{ix[pos][0], ix[pos][1]}, new long[]{ix[pos][2], ix[pos][3]}), (Object)((FederatedData)e.getValue()).copyWithNewID(outputID)));
            ++pos;
        }
        return new FederationMap(outputID, outputMap, type);
    }

    public FederationMap bind(long rOffset, long cOffset, FederationMap that) {
        for (Map.Entry entry : that._fedMap) {
            this._fedMap.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)new FederatedRange((FederatedRange)entry.getKey()).shift(rOffset, cOffset), (Object)((FederatedData)entry.getValue()).copyWithNewID(this._ID)));
        }
        return this;
    }

    public FederationMap modifyFedRanges(long value, int dim) {
        if (this.getType() == (dim == 0 ? FTypes.FType.ROW : FTypes.FType.COL)) {
            throw new DMLRuntimeException("Federated ranges cannot be modified in the direction of its partitioning.");
        }
        IntStream.range(0, this.getFederatedRanges().length).forEach(i -> {
            this.getFederatedRanges()[i].setBeginDim(dim, 0L);
            this.getFederatedRanges()[i].setEndDim(dim, value);
        });
        return this;
    }

    public FederationMap transpose() {
        ArrayList<Pair<FederatedRange, FederatedData>> tmp = new ArrayList<Pair<FederatedRange, FederatedData>>(this._fedMap);
        this._fedMap.clear();
        for (Pair pair : tmp) {
            this._fedMap.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)new FederatedRange((FederatedRange)pair.getKey()).transpose(), (Object)((FederatedData)pair.getValue()).copyWithNewID(this._ID)));
        }
        switch (this._type) {
            case ROW: {
                this._type = FTypes.FType.COL;
                break;
            }
            case COL: {
                this._type = FTypes.FType.ROW;
                break;
            }
            case FULL: 
            case PART: {
                break;
            }
            default: {
                this._type = FTypes.FType.OTHER;
            }
        }
        return this;
    }

    public long getMaxIndexInRange(int dim) {
        return this._fedMap.stream().mapToLong(range -> ((FederatedRange)range.getKey()).getEndDims()[dim]).max().orElse(-1L);
    }

    public void forEachParallel(BiFunction<FederatedRange, FederatedData, Void> forEachFunction) {
        ExecutorService pool = CommonThreadPool.get(this._fedMap.size());
        ArrayList<MappingTask> mappingTasks = new ArrayList<MappingTask>();
        for (Pair<FederatedRange, FederatedData> fedMap : this._fedMap) {
            mappingTasks.add(new MappingTask((FederatedRange)fedMap.getKey(), (FederatedData)fedMap.getValue(), forEachFunction, this._ID));
        }
        CommonThreadPool.invokeAndShutdown(pool, mappingTasks);
    }

    public FederationMap mapParallel(long newVarID, BiFunction<FederatedRange, FederatedData, Void> mappingFunction) {
        ExecutorService pool = CommonThreadPool.get(this._fedMap.size());
        FederationMap fedMapCopy = this.copyWithNewID(this._ID);
        ArrayList<MappingTask> mappingTasks = new ArrayList<MappingTask>();
        for (Pair<FederatedRange, FederatedData> fedMap : fedMapCopy._fedMap) {
            mappingTasks.add(new MappingTask((FederatedRange)fedMap.getKey(), (FederatedData)fedMap.getValue(), mappingFunction, newVarID));
        }
        CommonThreadPool.invokeAndShutdown(pool, mappingTasks);
        fedMapCopy._ID = newVarID;
        return fedMapCopy;
    }

    public FederationMap filter(IndexRange ixrange) {
        FederationMap ret = this.clone();
        Iterator<Pair<FederatedRange, FederatedData>> iter = ret._fedMap.iterator();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            FederatedRange range = (FederatedRange)e.getKey();
            long rs = range.getBeginDims()[0];
            long re = range.getEndDims()[0];
            long cs = range.getBeginDims()[1];
            long ce = range.getEndDims()[1];
            boolean overlap = ixrange.colStart <= ce && ixrange.colEnd >= cs && ixrange.rowStart <= re && ixrange.rowEnd >= rs;
            if (overlap) continue;
            iter.remove();
        }
        return ret;
    }

    private static void setThreadID(long tid, FederatedRequest[] ... frsets) {
        for (FederatedRequest[] frset : frsets) {
            if (frset == null) continue;
            Arrays.stream(frset).forEach(fr -> fr.setTID(tid));
        }
    }

    public void reverseFedMap() {
        FederatedRange[] fedRanges = this.getFederatedRanges();
        int i = 0;
        while ((double)i < Math.floor((double)fedRanges.length / 2.0)) {
            FederatedData data1 = this.getFederatedData(fedRanges[i]);
            FederatedData data2 = this.getFederatedData(fedRanges[fedRanges.length - 1 - i]);
            this.removeFederatedData(fedRanges[i]);
            this.removeFederatedData(fedRanges[fedRanges.length - 1 - i]);
            this._fedMap.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)fedRanges[i], (Object)data2));
            this._fedMap.add((Pair<FederatedRange, FederatedData>)Pair.of((Object)fedRanges[fedRanges.length - 1 - i], (Object)data1));
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Fed Map: " + this._type);
        sb.append("\t ID:" + this._ID);
        sb.append("\n" + this._fedMap);
        return sb.toString();
    }

    public FederationMap clone() {
        return this.copyWithNewID(this.getID());
    }

    private static class MappingTask
    implements Callable<Void> {
        private final FederatedRange _range;
        private final FederatedData _data;
        private final BiFunction<FederatedRange, FederatedData, Void> _mappingFunction;
        private final long _varID;

        public MappingTask(FederatedRange range, FederatedData data, BiFunction<FederatedRange, FederatedData, Void> mappingFunction, long varID) {
            this._range = range;
            this._data = data;
            this._mappingFunction = mappingFunction;
            this._varID = varID;
        }

        @Override
        public Void call() throws Exception {
            this._mappingFunction.apply(this._range, this._data);
            this._data.setVarID(this._varID);
            return null;
        }
    }
}

