/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.BaseEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.NodeEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.StatsEntityModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.EntityEnum;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.repositories.IRepository;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.MapperService;

public class DerbyRepository
implements IRepository {
    private static final String DB_CONNECTION = "jdbc:derby:memory:derbyDB";
    private final Connection _db = this.createMonitoringDatabase();
    private static final String ENTITY_SCHEMA_CREATE_STMT = "CREATE TABLE %s (id INTEGER PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), %s VARCHAR(60), %s VARCHAR(120))";
    private static final String ENTITY_SCHEMA_CREATE_STATS_STMT = "CREATE TABLE %s (id INTEGER PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), %s INTEGER, %s DOUBLE, %s DOUBLE,%s VARCHAR(1000),%s VARCHAR(1000))";
    private static final String ENTITY_INSERT_STMT = "INSERT INTO %s (%s, %s) VALUES (?, ?)";
    private static final String ENTITY_STATS_INSERT_STMT = "INSERT INTO %s (%s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?)";
    private static final String GET_ENTITY_WITH_COL_STMT = "SELECT * FROM %s WHERE %s = ?";
    private static final String DELETE_ENTITY_WITH_COL_STMT = "DELETE FROM %s WHERE %s = ?";
    private static final String UPDATE_ENTITY_WITH_COL_STMT = "UPDATE %s SET %s = ?, %s = ? WHERE %s = ?";
    private static final String GET_ALL_ENTITIES_STMT = "SELECT * FROM %s";

    private Connection createMonitoringDatabase() {
        Connection db = null;
        try {
            db = DriverManager.getConnection("jdbc:derby:memory:derbyDB;create=true");
            this.createMonitoringEntitiesInDB(db);
            return db;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createMonitoringEntitiesInDB(Connection db) {
        try {
            PreparedStatement st;
            DatabaseMetaData dbMetaData = db.getMetaData();
            ResultSet workersExist = dbMetaData.getTables(null, null, "workers".toUpperCase(), null);
            ResultSet statsExist = dbMetaData.getTables(null, null, "statistics".toUpperCase(), null);
            ResultSet coordinatorsExist = dbMetaData.getTables(null, null, "coordinators".toUpperCase(), null);
            if (!workersExist.next()) {
                st = db.prepareStatement(String.format(ENTITY_SCHEMA_CREATE_STMT, "workers", "name", "address"));
                st.executeUpdate();
            }
            if (!statsExist.next()) {
                st = db.prepareStatement(String.format(ENTITY_SCHEMA_CREATE_STATS_STMT, "statistics", "workerId", "cpuUsage", "memoryUsage", "coordinatorTraffic", "heavyHitters"));
                st.executeUpdate();
            }
            if (!coordinatorsExist.next()) {
                st = db.prepareStatement(String.format(ENTITY_SCHEMA_CREATE_STMT, "coordinators", "name", "address"));
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Long createEntity(EntityEnum type, BaseEntityModel model) {
        PreparedStatement st = null;
        long id = -1L;
        try {
            BaseEntityModel newModel;
            if (type == EntityEnum.WORKER_STATS) {
                st = this._db.prepareStatement(String.format(ENTITY_STATS_INSERT_STMT, "statistics", "workerId", "cpuUsage", "memoryUsage", "coordinatorTraffic", "heavyHitters"), 1);
                newModel = (StatsEntityModel)model;
                st.setLong(1, ((StatsEntityModel)newModel).getWorkerId());
                st.setDouble(2, ((StatsEntityModel)newModel).getCPUUsage());
                st.setDouble(3, ((StatsEntityModel)newModel).getMemoryUsage());
                st.setString(4, ((StatsEntityModel)newModel).getTransferredBytes());
                st.setString(5, ((StatsEntityModel)newModel).getHeavyHitterInstructions());
            } else {
                st = this._db.prepareStatement(String.format(ENTITY_INSERT_STMT, "workers", "name", "address"), 1);
                newModel = (NodeEntityModel)model;
                if (type == EntityEnum.COORDINATOR) {
                    st = this._db.prepareStatement(String.format(ENTITY_INSERT_STMT, "coordinators", "name", "address"), 1);
                }
                st.setString(1, ((NodeEntityModel)newModel).getName());
                st.setString(2, ((NodeEntityModel)newModel).getAddress());
            }
            st.executeUpdate();
            ResultSet rs = st.getGeneratedKeys();
            if (rs.next()) {
                id = rs.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return id;
    }

    @Override
    public BaseEntityModel getEntity(EntityEnum type, Long id) {
        BaseEntityModel resultModel = null;
        try {
            PreparedStatement st = this._db.prepareStatement(String.format(GET_ENTITY_WITH_COL_STMT, "workers", "id"));
            if (type == EntityEnum.COORDINATOR) {
                st = this._db.prepareStatement(String.format(GET_ENTITY_WITH_COL_STMT, "coordinators", "id"));
            } else if (type == EntityEnum.WORKER_STATS) {
                st = this._db.prepareStatement(String.format(GET_ENTITY_WITH_COL_STMT, "statistics", "workerId"));
            }
            st.setLong(1, id);
            ResultSet resultSet = st.executeQuery();
            if (resultSet.next()) {
                resultModel = MapperService.mapEntityToModel(resultSet, type);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultModel;
    }

    @Override
    public List<BaseEntityModel> getAllEntities(EntityEnum type) {
        ArrayList<BaseEntityModel> resultModels = new ArrayList<BaseEntityModel>();
        try {
            PreparedStatement st = this._db.prepareStatement(String.format(GET_ALL_ENTITIES_STMT, "workers"));
            if (type == EntityEnum.COORDINATOR) {
                st = this._db.prepareStatement(String.format(GET_ALL_ENTITIES_STMT, "coordinators"));
            }
            ResultSet resultSet = st.executeQuery();
            while (resultSet.next()) {
                resultModels.add(MapperService.mapEntityToModel(resultSet, type));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultModels;
    }

    @Override
    public List<BaseEntityModel> getAllEntitiesByField(EntityEnum type, Object fieldValue) {
        ArrayList<BaseEntityModel> resultModels = new ArrayList<BaseEntityModel>();
        PreparedStatement st = null;
        try {
            if (type != EntityEnum.WORKER_STATS) {
                throw new NotImplementedException();
            }
            st = this._db.prepareStatement(String.format(GET_ENTITY_WITH_COL_STMT, "statistics", "workerId"));
            st.setLong(1, (Long)fieldValue);
            ResultSet resultSet = st.executeQuery();
            while (resultSet.next()) {
                resultModels.add(MapperService.mapEntityToModel(resultSet, type));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultModels;
    }

    @Override
    public void updateEntity(EntityEnum type, BaseEntityModel model) {
        try {
            PreparedStatement st = this._db.prepareStatement(String.format(UPDATE_ENTITY_WITH_COL_STMT, "workers", "name", "address", "id"));
            NodeEntityModel editModel = (NodeEntityModel)model;
            if (type == EntityEnum.COORDINATOR) {
                st = this._db.prepareStatement(String.format(UPDATE_ENTITY_WITH_COL_STMT, "coordinators", "name", "address", "id"));
            }
            st.setString(1, editModel.getName());
            st.setString(2, editModel.getAddress());
            st.setLong(3, editModel.getId());
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeEntity(EntityEnum type, Long id) {
        PreparedStatement st = null;
        try {
            if (type == EntityEnum.WORKER) {
                st = this._db.prepareStatement(String.format(DELETE_ENTITY_WITH_COL_STMT, "workers", "id"));
                st.setLong(1, id);
            } else {
                st = this._db.prepareStatement(String.format(DELETE_ENTITY_WITH_COL_STMT, "coordinators", "id"));
                st.setLong(1, id);
            }
            st.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

