/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import java.util.HashMap;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateTernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AppendFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CentralMomentFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CovarianceFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.InitFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantilePickFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantileSortFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReorgFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TsmmFEDInstruction;

public class FEDInstructionParser
extends InstructionParser {
    public static final HashMap<String, FEDInstruction.FEDType> String2FEDInstructionType = new HashMap();

    public static FEDInstruction parseSingleInstruction(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        FEDInstruction.FEDType fedtype = InstructionUtils.getFEDType(str);
        if (fedtype == null) {
            throw new DMLRuntimeException("Unable derive fedtype for instruction: " + str);
        }
        FEDInstruction cpinst = FEDInstructionParser.parseSingleInstruction(fedtype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static FEDInstruction parseSingleInstruction(FEDInstruction.FEDType fedtype, String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (fedtype) {
            case Init: {
                return InitFEDInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryFEDInstruction.parseInstruction(str);
            }
            case AggregateUnary: {
                return AggregateUnaryFEDInstruction.parseInstruction(str);
            }
            case Tsmm: {
                return TsmmFEDInstruction.parseInstruction(str);
            }
            case Binary: {
                return BinaryFEDInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryFEDInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgFEDInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendFEDInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernaryFEDInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentFEDInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceFEDInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortFEDInstruction.parseInstruction(str, true);
            }
            case QPick: {
                return QuantilePickFEDInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid FEDERATED Instruction Type: " + fedtype);
    }

    static {
        String2FEDInstructionType.put("fedinit", FEDInstruction.FEDType.Init);
        String2FEDInstructionType.put("tsmm", FEDInstruction.FEDType.Tsmm);
        String2FEDInstructionType.put("ba+*", FEDInstruction.FEDType.AggregateBinary);
        String2FEDInstructionType.put("tak+*", FEDInstruction.FEDType.AggregateTernary);
        String2FEDInstructionType.put("uak+", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uark+", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uack+", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uamax", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uamin", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uasqk+", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uarsqk+", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uacsqk+", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uavar", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uarvar", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("uacvar", FEDInstruction.FEDType.AggregateUnary);
        String2FEDInstructionType.put("+", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("-", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("*", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("/", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("1-*", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("^2", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("max", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("==", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("!=", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("<", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put(">", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("<=", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put(">=", FEDInstruction.FEDType.Binary);
        String2FEDInstructionType.put("r'", FEDInstruction.FEDType.Reorg);
        String2FEDInstructionType.put("rdiag", FEDInstruction.FEDType.Reorg);
        String2FEDInstructionType.put("rev", FEDInstruction.FEDType.Reorg);
        String2FEDInstructionType.put("+*", FEDInstruction.FEDType.Ternary);
        String2FEDInstructionType.put("-*", FEDInstruction.FEDType.Ternary);
        String2FEDInstructionType.put("cm", FEDInstruction.FEDType.CentralMoment);
        String2FEDInstructionType.put("cov", FEDInstruction.FEDType.Covariance);
        String2FEDInstructionType.put("qsort", FEDInstruction.FEDType.QSort);
        String2FEDInstructionType.put("qpick", FEDInstruction.FEDType.QPick);
        String2FEDInstructionType.put("append", FEDInstruction.FEDType.Append);
    }
}

