/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.LanguageException;

public class IPAPassRemoveUnusedFunctions
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return !fgraph.containsSecondOrderCall();
    }

    @Override
    public boolean rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        try {
            Set<String> fnamespaces = prog.getNamespaces().keySet();
            for (String fnspace : fnamespaces) {
                Map<String, FunctionStatementBlock> fsbs = prog.getFunctionStatementBlocks(fnspace);
                Iterator<Map.Entry<String, FunctionStatementBlock>> iter = fsbs.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, FunctionStatementBlock> e = iter.next();
                    if (fgraph.isReachableFunction(fnspace, e.getKey())) continue;
                    iter.remove();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("IPA: Removed unused function: " + DMLProgram.constructFunctionKey(fnspace, e.getKey())));
                }
            }
        }
        catch (LanguageException ex) {
            throw new HopsException(ex);
        }
        return false;
    }
}

